/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.jdbc;

import com.p6spy.engine.common.ConnectionInformation;
import com.p6spy.engine.common.StatementInformation;
import com.p6spy.engine.event.SimpleJdbcEventListener;
import io.sentry.IScopes;
import io.sentry.ISentryLifecycleToken;
import io.sentry.ISpan;
import io.sentry.ScopesAdapter;
import io.sentry.SentryIntegrationPackageStorage;
import io.sentry.SpanOptions;
import io.sentry.SpanStatus;
import io.sentry.jdbc.DatabaseUtils;
import io.sentry.util.AutoClosableReentrantLock;
import io.sentry.util.Objects;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SentryJdbcEventListener
extends SimpleJdbcEventListener {
    private static final String TRACE_ORIGIN = "auto.db.jdbc";
    @NotNull
    private final IScopes scopes;
    @NotNull
    private static final ThreadLocal<ISpan> CURRENT_QUERY_SPAN = new ThreadLocal();
    @NotNull
    private static final ThreadLocal<ISpan> CURRENT_TRANSACTION_SPAN = new ThreadLocal();
    @Nullable
    private volatile DatabaseUtils.DatabaseDetails cachedDatabaseDetails = null;
    @NotNull
    protected final AutoClosableReentrantLock databaseDetailsLock = new AutoClosableReentrantLock();

    public SentryJdbcEventListener(@NotNull IScopes scopes) {
        this.scopes = (IScopes)Objects.requireNonNull((Object)scopes, (String)"scopes are required");
        this.addPackageAndIntegrationInfo();
    }

    public SentryJdbcEventListener() {
        this((IScopes)ScopesAdapter.getInstance());
    }

    public void onBeforeAnyExecute(@NotNull StatementInformation statementInformation) {
        this.startSpan(CURRENT_QUERY_SPAN, "db.query", statementInformation.getSql());
    }

    public void onAfterAnyExecute(@NotNull StatementInformation statementInformation, long timeElapsedNanos, @Nullable SQLException e) {
        this.finishSpan(CURRENT_QUERY_SPAN, statementInformation.getConnectionInformation(), e);
    }

    public void onBeforeSetAutoCommit(@NotNull ConnectionInformation connectionInformation, boolean newAutoCommit, boolean currentAutoCommit) {
        boolean isSwitchingToManualCommit;
        if (!this.isDatabaseTransactionTracingEnabled()) {
            return;
        }
        boolean bl = isSwitchingToManualCommit = !newAutoCommit && currentAutoCommit;
        if (isSwitchingToManualCommit) {
            this.startSpan(CURRENT_TRANSACTION_SPAN, "db.sql.transaction.begin", "BEGIN");
        }
    }

    public void onAfterSetAutoCommit(@NotNull ConnectionInformation connectionInformation, boolean newAutoCommit, boolean oldAutoCommit, @Nullable SQLException e) {
        boolean isSwitchingToManualCommit;
        if (!this.isDatabaseTransactionTracingEnabled()) {
            return;
        }
        boolean bl = isSwitchingToManualCommit = !newAutoCommit && oldAutoCommit;
        if (isSwitchingToManualCommit) {
            this.finishSpan(CURRENT_TRANSACTION_SPAN, connectionInformation, e);
        }
    }

    public void onBeforeCommit(@NotNull ConnectionInformation connectionInformation) {
        if (!this.isDatabaseTransactionTracingEnabled()) {
            return;
        }
        this.startSpan(CURRENT_TRANSACTION_SPAN, "db.sql.transaction.commit", "COMMIT");
    }

    public void onAfterCommit(@NotNull ConnectionInformation connectionInformation, long timeElapsedNanos, @Nullable SQLException e) {
        if (!this.isDatabaseTransactionTracingEnabled()) {
            return;
        }
        this.finishSpan(CURRENT_TRANSACTION_SPAN, connectionInformation, e);
    }

    public void onBeforeRollback(@NotNull ConnectionInformation connectionInformation) {
        if (!this.isDatabaseTransactionTracingEnabled()) {
            return;
        }
        this.startSpan(CURRENT_TRANSACTION_SPAN, "db.sql.transaction.rollback", "ROLLBACK");
    }

    public void onAfterRollback(@NotNull ConnectionInformation connectionInformation, long timeElapsedNanos, @Nullable SQLException e) {
        if (!this.isDatabaseTransactionTracingEnabled()) {
            return;
        }
        this.finishSpan(CURRENT_TRANSACTION_SPAN, connectionInformation, e);
    }

    private boolean isDatabaseTransactionTracingEnabled() {
        return this.scopes.getOptions().isEnableDatabaseTransactionTracing();
    }

    private void startSpan(@NotNull ThreadLocal<ISpan> spanHolder, @NotNull String operation, @Nullable String description) {
        @Nullable ISpan parent = this.scopes.getSpan();
        if (parent != null && !parent.isNoOp()) {
            @NotNull SpanOptions spanOptions = new SpanOptions();
            spanOptions.setOrigin(TRACE_ORIGIN);
            @NotNull ISpan span = parent.startChild(operation, description, spanOptions);
            spanHolder.set(span);
        }
    }

    private void finishSpan(@NotNull ThreadLocal<ISpan> spanHolder, @Nullable ConnectionInformation connectionInformation, @Nullable SQLException e) {
        @Nullable ISpan span = spanHolder.get();
        if (span != null) {
            this.applyDatabaseDetailsToSpan(connectionInformation, span);
            if (e != null) {
                span.setThrowable((Throwable)e);
                span.setStatus(SpanStatus.INTERNAL_ERROR);
            } else {
                span.setStatus(SpanStatus.OK);
            }
            span.finish();
            spanHolder.remove();
        }
    }

    private void addPackageAndIntegrationInfo() {
        SentryIntegrationPackageStorage.getInstance().addIntegration("JDBC");
    }

    private void applyDatabaseDetailsToSpan(@Nullable ConnectionInformation connectionInformation, @NotNull ISpan span) {
        @NotNull DatabaseUtils.DatabaseDetails databaseDetails = this.getOrComputeDatabaseDetails(connectionInformation);
        if (databaseDetails.getDbSystem() != null) {
            span.setData("db.system", (Object)databaseDetails.getDbSystem());
        }
        if (databaseDetails.getDbName() != null) {
            span.setData("db.name", (Object)databaseDetails.getDbName());
        }
    }

    @NotNull
    private DatabaseUtils.DatabaseDetails getOrComputeDatabaseDetails(@Nullable ConnectionInformation connectionInformation) {
        if (this.cachedDatabaseDetails == null) {
            try (@NotNull ISentryLifecycleToken ignored = this.databaseDetailsLock.acquire();){
                if (this.cachedDatabaseDetails == null) {
                    this.cachedDatabaseDetails = DatabaseUtils.readFrom(connectionInformation);
                }
            }
        }
        return this.cachedDatabaseDetails;
    }

    static {
        SentryIntegrationPackageStorage.getInstance().addPackage("maven:io.sentry:sentry-jdbc", "8.32.0");
    }
}

