/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.ddl;

import com.baomidou.mybatisplus.core.toolkit.ClassUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.ddl.DdlHelper;
import com.baomidou.mybatisplus.extension.ddl.DdlScriptErrorHandler;
import com.baomidou.mybatisplus.extension.ddl.history.IDdlGenerator;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.List;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.apache.ibatis.datasource.unpooled.UnpooledDataSource;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;

public class DdlScript {
    private static final Log LOG = LogFactory.getLog(DdlScript.class);
    private final DataSource dataSource;
    @Deprecated
    private IDdlGenerator ddlGenerator;
    private boolean autoCommit;
    private Consumer<ScriptRunner> scriptRunnerConsumer;

    public DdlScript(String driverClassName, String url, String user, String password) {
        this(driverClassName, url, user, password, false);
    }

    public DdlScript(String driverClassName, String url, String user, String password, boolean autoCommit) {
        this.dataSource = new UnpooledDataSource(driverClassName, url, user, password);
        this.autoCommit = autoCommit;
    }

    public DdlScript(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Deprecated
    public DdlScript(DataSource dataSource, IDdlGenerator ddlGenerator) {
        this(dataSource, ddlGenerator, false);
    }

    @Deprecated
    public DdlScript(DataSource dataSource, IDdlGenerator ddlGenerator, boolean autoCommit) {
        this.dataSource = dataSource;
        this.ddlGenerator = ddlGenerator;
        this.autoCommit = autoCommit;
    }

    @Deprecated
    public void run(List<String> sqlFiles) {
        this.run(sqlFiles, this.autoCommit);
    }

    @Deprecated
    public void run(List<String> sqlFiles, boolean autoCommit) {
        try (Connection connection = this.dataSource.getConnection();){
            DdlHelper.runScript(this.ddlGenerator, connection, sqlFiles, this.scriptRunnerConsumer, autoCommit, (DdlScriptErrorHandler)DdlScriptErrorHandler.PrintlnLogErrorHandler.INSTANCE);
        }
        catch (Exception e) {
            LOG.error("Run script error: ", (Throwable)e);
        }
    }

    public DdlScript scriptRunner(Consumer<ScriptRunner> scriptRunnerConsumer) {
        this.scriptRunnerConsumer = scriptRunnerConsumer;
        return this;
    }

    public void run(String sqlScript) throws Exception {
        this.run(sqlScript, ";");
    }

    public void run(String sqlScript, String delimiter) throws Exception {
        this.run(new StringReader(sqlScript), this.autoCommit, delimiter);
    }

    public void run(Reader reader) throws Exception {
        this.run(reader, this.autoCommit, ";");
    }

    public void run(Reader reader, boolean autoCommit) throws Exception {
        this.run(reader, autoCommit, ";");
    }

    public void run(Reader reader, boolean autoCommit, String delimiter) throws Exception {
        try (Connection connection = this.dataSource.getConnection();){
            this.run(connection, reader, autoCommit, delimiter);
        }
    }

    public void run(Connection connection, Reader reader, boolean autoCommit, String delimiter) {
        ScriptRunner scriptRunner = DdlHelper.getScriptRunner(connection, autoCommit);
        if (this.scriptRunnerConsumer != null) {
            this.scriptRunnerConsumer.accept(scriptRunner);
        }
        if (StringUtils.isNotBlank((CharSequence)delimiter)) {
            scriptRunner.setDelimiter(delimiter);
        }
        scriptRunner.runScript(reader);
    }

    @Deprecated
    public boolean execute(String driverClassName, String url, String user, String password, String sqlScript, Consumer<String> exceptionConsumer) {
        return this.execute(driverClassName, url, user, password, sqlScript, ";", exceptionConsumer);
    }

    public boolean run(String sqlScript, Consumer<String> exceptionConsumer) {
        return this.run(sqlScript, ";", exceptionConsumer);
    }

    @Deprecated
    public boolean execute(String driverClassName, String url, String user, String password, String sqlScript, String delimiter, Consumer<String> exceptionConsumer) {
        boolean bl;
        block10: {
            if (StringUtils.isNotBlank((CharSequence)driverClassName)) {
                Class driverClass = ClassUtils.toClassConfident((String)driverClassName);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Load driver class: " + driverClass.getName());
                }
            }
            Connection connection = DriverManager.getConnection(url, user, password);
            try {
                this.run(connection, new StringReader(sqlScript), this.autoCommit, delimiter);
                bl = true;
                if (connection == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOG.error("Execute sqlScript: " + sqlScript + " , fail:", (Throwable)e);
                    exceptionConsumer.accept(e.getMessage());
                    return false;
                }
            }
            connection.close();
        }
        return bl;
    }

    public boolean run(String sqlScript, String delimiter, Consumer<String> exceptionConsumer) {
        boolean bl;
        block8: {
            Connection connection = this.dataSource.getConnection();
            try {
                this.run(connection, new StringReader(sqlScript), this.autoCommit, delimiter);
                bl = true;
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOG.error("Execute sqlScript: " + sqlScript + " , fail:", (Throwable)e);
                    exceptionConsumer.accept(e.getMessage());
                    return false;
                }
            }
            connection.close();
        }
        return bl;
    }
}

