/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.SizeAndTimeBasedRollingPolicy;
import com.ghostchu.peerbanhelper.AppConfig;
import com.ghostchu.peerbanhelper.BuildMeta;
import com.ghostchu.peerbanhelper.ExternalSwitch;
import com.ghostchu.peerbanhelper.PeerBanHelper;
import com.ghostchu.peerbanhelper.config.MainConfigUpdateScript;
import com.ghostchu.peerbanhelper.config.PBHConfigUpdater;
import com.ghostchu.peerbanhelper.config.ProfileUpdateScript;
import com.ghostchu.peerbanhelper.event.program.PBHShutdownEvent;
import com.ghostchu.peerbanhelper.exchange.ExchangeMap;
import com.ghostchu.peerbanhelper.gui.PBHGuiManager;
import com.ghostchu.peerbanhelper.gui.TaskbarState;
import com.ghostchu.peerbanhelper.gui.impl.console.ConsoleGuiImpl;
import com.ghostchu.peerbanhelper.gui.impl.swing.SwingGuiImpl;
import com.ghostchu.peerbanhelper.platform.Platform;
import com.ghostchu.peerbanhelper.platform.impl.win32.WindowsPlatform;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.util.ByteUtil;
import com.ghostchu.peerbanhelper.util.CommonUtil;
import com.ghostchu.peerbanhelper.util.HTTPUtil;
import com.ghostchu.peerbanhelper.util.IPAddressUtil;
import com.ghostchu.peerbanhelper.util.InfoHashUtil;
import com.ghostchu.peerbanhelper.util.MiscUtil;
import com.ghostchu.peerbanhelper.util.MsgUtil;
import com.ghostchu.peerbanhelper.util.SharedObject;
import com.ghostchu.peerbanhelper.util.StrUtil;
import com.ghostchu.peerbanhelper.util.URLUtil;
import com.ghostchu.peerbanhelper.util.UrlEncoderDecoder;
import com.ghostchu.peerbanhelper.util.WebUtil;
import com.ghostchu.peerbanhelper.util.encrypt.RSAUtils;
import com.ghostchu.peerbanhelper.util.json.JsonUtil;
import com.ghostchu.peerbanhelper.util.query.Pageable;
import com.ghostchu.peerbanhelper.web.JavalinWebContainer;
import com.ghostchu.simplereloadlib.ReloadManager;
import com.ghostchu.simplereloadlib.ReloadResult;
import com.ghostchu.simplereloadlib.ReloadStatus;
import com.google.common.eventbus.EventBus;
import com.googlecode.aviator.AviatorEvaluator;
import com.googlecode.aviator.EvalMode;
import com.googlecode.aviator.FunctionMissing;
import com.googlecode.aviator.Options;
import com.googlecode.aviator.runtime.JavaMethodReflectionFunctionMissing;
import com.maxmind.geoip2.exception.AddressNotFoundException;
import cordelia.client.TransmissionIOException;
import io.javalin.util.JavalinBindException;
import io.sentry.Sentry;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.math.MathContext;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import javax.crypto.BadPaddingException;
import javax.net.ssl.SSLHandshakeException;
import javax.swing.JOptionPane;
import lombok.Generated;
import org.bspfsystems.yamlconfiguration.configuration.InvalidConfigurationException;
import org.bspfsystems.yamlconfiguration.file.YamlConfiguration;
import org.jetbrains.annotations.Nullable;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import oshi.SystemInfo;
import oshi.software.os.OperatingSystem;
import raccoonfink.deluge.DelugeException;

public class Main {
    @Generated
    private static final org.slf4j.Logger log = LoggerFactory.getLogger(Main.class);
    private static final UUID runtimeInstanceId = UUID.randomUUID();
    private static final EventBus eventBus = new EventBus();
    private static final ReloadManager reloadManager = new ReloadManager();
    public static String DEF_LOCALE = Locale.getDefault().toLanguageTag().toLowerCase(Locale.ROOT).replace("-", "_");
    private static File dataDirectory;
    private static File cacheDirectory;
    private static File logsDirectory;
    private static File configDirectory;
    private static File pluginDirectory;
    private static File debugDirectory;
    private static PeerBanHelper server;
    private static PBHGuiManager guiManager;
    private static File mainConfigFile;
    private static File profileConfigFile;
    private static AnnotationConfigApplicationContext applicationContext;
    private static String pbhServerAddress;
    private static YamlConfiguration mainConfig;
    private static YamlConfiguration profileConfig;
    private static BuildMeta meta;
    private static String[] startupArgs;
    private static final long startupAt;
    @Nullable
    private static Platform platform;
    private static String userAgent;
    public static final int PBH_BTN_PROTOCOL_IMPL_VERSION = 20;
    public static final String PBH_BTN_PROTOCOL_READABLE_VERSION = "2.0.1";
    private static long bootSince;
    private static JavalinWebContainer webContainer;

    public static void main(String[] args) {
        try {
            bootSince = System.currentTimeMillis();
            startupArgs = args;
            System.setProperty("sun.net.useExclusiveBind", "false");
            Main.setupReloading();
            Main.setupConfDirectory(args);
            Main.loadFlagsProperties();
            Main.setupConfiguration();
            meta = Main.buildMeta();
            Main.setupLogback();
            Main.setupSentry();
            String defLocaleTag = Locale.getDefault().getLanguage() + "-" + Locale.getDefault().getCountry();
            Sentry.setTag((String)"locale", (String)defLocaleTag);
            log.info("Current system language tag: {}", (Object)defLocaleTag);
            DEF_LOCALE = mainConfig.getString("language");
            if ((DEF_LOCALE == null || "default".equalsIgnoreCase(DEF_LOCALE)) && (DEF_LOCALE = ExternalSwitch.parse("pbh.userLocale")) == null) {
                DEF_LOCALE = defLocaleTag;
            }
            Main.loadPlatform();
            Main.setupHttpServer();
            pbhServerAddress = mainConfig.getString("server.prefix", "http://127.0.0.1:" + mainConfig.getInt("server.http"));
            Main.initGUI(args);
            Thread.ofPlatform().name("Bootstrap").start(() -> {
                try {
                    guiManager.taskbarControl().updateProgress(null, TaskbarState.INDETERMINATE, 0.0f);
                    Main.setupScriptEngine();
                    log.info(TextManager.tlUI(Lang.SPRING_CONTEXT_LOADING, new Object[0]));
                    applicationContext = new AnnotationConfigApplicationContext();
                    applicationContext.register(new Class[]{AppConfig.class});
                    applicationContext.refresh();
                    server = (PeerBanHelper)applicationContext.getBean(PeerBanHelper.class);
                    server.start();
                    log.info(TextManager.tlUI(Lang.BOOT_TIME, System.currentTimeMillis() - bootSince));
                }
                catch (Throwable e) {
                    log.error(TextManager.tlUI(Lang.PBH_STARTUP_FATAL_ERROR, new Object[0]), e);
                    Sentry.captureException((Throwable)e);
                    throw e;
                }
                Main.setupShutdownHook();
            });
            guiManager.sync();
        }
        catch (Throwable throwable) {
            log.error(TextManager.tlUI(Lang.PBH_STARTUP_FATAL_ERROR, new Object[0]), throwable);
            Sentry.captureException((Throwable)throwable);
            throw throwable;
        }
    }

    private static void setupHttpServer() {
        webContainer = new JavalinWebContainer();
        String token = ExternalSwitch.parse("pbh.apiToken", Main.getMainConfig().getString("server.token"));
        String host = ExternalSwitch.parse("pbh.serverAddress", Main.getMainConfig().getString("server.address"));
        if ("0.0.0.0".equals(host) || "::".equals(host) || "localhost".equals(host)) {
            host = null;
        }
        int httpdPort = ExternalSwitch.parseInt("pbh.port", Main.getMainConfig().getInt("server.http"));
        try {
            webContainer.setupJavalin();
            webContainer.start(host, httpdPort, token);
        }
        catch (JavalinBindException e) {
            if (e.getMessage().contains("Port already in use")) {
                log.error(TextManager.tlUI(Lang.JAVALIN_PORT_IN_USE, httpdPort));
                throw new JavalinBindException(TextManager.tlUI(Lang.JAVALIN_PORT_IN_USE, httpdPort), (Throwable)e);
            }
            if (e.getMessage().contains("require elevated privileges")) {
                log.error(TextManager.tlUI(Lang.JAVALIN_PORT_REQUIRE_PRIVILEGES, new Object[0]));
                throw new JavalinBindException(TextManager.tlUI(Lang.JAVALIN_PORT_REQUIRE_PRIVILEGES, httpdPort), (Throwable)e);
            }
            Sentry.captureException((Throwable)e);
            log.error("Unable to start Javalin http server", (Throwable)e);
        }
    }

    private static void setupSentry() {
        Sentry.init(sentryOptions -> {
            sentryOptions.setDsn(ExternalSwitch.parse("sentry.dsn", "https://8c37f36e8a0244279b1142e4b82eb81a@glitchtip.pbh-btn.com/1"));
            sentryOptions.setEnableExternalConfiguration(true);
            sentryOptions.setCacheDirPath(cacheDirectory.getAbsolutePath());
            sentryOptions.setEnabled(mainConfig.getBoolean("privacy.analytics"));
            sentryOptions.setDistinctId(mainConfig.getString("installation-id"));
            sentryOptions.setServerName(mainConfig.getString("installation-id"));
            sentryOptions.setEnvironment(meta.isSnapshotOrBeta() ? "development" : "production");
            sentryOptions.setSendDefaultPii(false);
            sentryOptions.setEnableDeduplication(true);
            sentryOptions.setAttachThreads(true);
            sentryOptions.setPrintUncaughtStackTrace(true);
            sentryOptions.setEnableUncaughtExceptionHandler(true);
            sentryOptions.setSampleRate(Double.valueOf(ExternalSwitch.parseDouble("sentry.samplerate", 0.2)));
            sentryOptions.setProfilesSampleRate(Double.valueOf(ExternalSwitch.parseDouble("sentry.profilessamplerate", 0.2)));
            sentryOptions.setTracesSampleRate(Double.valueOf(ExternalSwitch.parseDouble("sentry.tracesamplerate", 0.2)));
            sentryOptions.setProfileSessionSampleRate(Double.valueOf(ExternalSwitch.parseDouble("sentry.profilesessionsamplerate", 0.2)));
            sentryOptions.setEnableUserInteractionTracing(false);
            sentryOptions.setRelease(meta.getVersion());
            sentryOptions.setTag("os", System.getProperty("os.name"));
            sentryOptions.setTag("osarch", System.getProperty("os.arch"));
            sentryOptions.setTag("osversion", System.getProperty("os.version"));
            sentryOptions.setTag("publisher", meta.getCompileUser() + "(" + meta.getCompileEmail() + ")");
            sentryOptions.setTag("abbrev", meta.getAbbrev());
            sentryOptions.addIgnoredExceptionForType(AddressNotFoundException.class);
            sentryOptions.addIgnoredExceptionForType(JavalinBindException.class);
            sentryOptions.addIgnoredExceptionForType(OutOfMemoryError.class);
            sentryOptions.addIgnoredExceptionForType(TransmissionIOException.class);
            sentryOptions.addIgnoredExceptionForType(DelugeException.class);
            sentryOptions.addIgnoredExceptionForType(SSLHandshakeException.class);
            sentryOptions.addIgnoredExceptionForType(BadPaddingException.class);
            sentryOptions.addIgnoredExceptionForType(TimeoutException.class);
            sentryOptions.addIgnoredExceptionForType(SocketTimeoutException.class);
            sentryOptions.addIgnoredExceptionForType(IOException.class);
            sentryOptions.addIgnoredExceptionForType(SocketException.class);
            sentryOptions.addIgnoredExceptionForType(ConnectException.class);
            sentryOptions.addIgnoredExceptionForType(UnknownHostException.class);
            sentryOptions.addIgnoredExceptionForType(NoRouteToHostException.class);
        });
    }

    private static void loadPlatform() {
        String os = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        platform = os.startsWith("win") ? new WindowsPlatform() : null;
        Sentry.setTag((String)"platform", (String)(platform != null ? platform.getClass().getName() : "null"));
    }

    private static void loadFlagsProperties() {
        block8: {
            try {
                File flags = new File(dataDirectory, "flags.properties");
                if (!flags.exists()) break block8;
                try (InputStream is = Files.newInputStream(flags.toPath(), new OpenOption[0]);){
                    Properties properties = new Properties();
                    properties.load(is);
                    System.getProperties().putAll((Map<?, ?>)properties);
                    log.info("Loaded {} property from data/flags.properties.", (Object)properties.size());
                }
            }
            catch (IOException e) {
                log.error("Unable to load flags.properties", (Throwable)e);
            }
        }
    }

    private static void setupReloading() {
        reloadManager.register(Main.class.getDeclaredMethod("reloadModule", new Class[0]));
    }

    public static void setupLogback() {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        RollingFileAppender appender = (RollingFileAppender)loggerContext.getLogger("ROOT").getAppender("FILE");
        if (appender != null) {
            appender.stop();
            appender.setFile(new File(logsDirectory, "latest.log").getAbsolutePath());
            SizeAndTimeBasedRollingPolicy policy = (SizeAndTimeBasedRollingPolicy)appender.getRollingPolicy();
            policy.setFileNamePattern(logsDirectory.getAbsolutePath() + "/%d{yyyy-MM-dd}-%i.log.gz");
            policy.start();
            appender.start();
        }
        try {
            String targetLevel = ExternalSwitch.parse("pbh.log.level");
            if (targetLevel != null) {
                Logger rootLogger = loggerContext.getLogger("ROOT");
                rootLogger.setLevel(Level.toLevel((String)targetLevel));
            }
        }
        catch (Throwable e) {
            log.warn("Failed to set log level", e);
        }
    }

    public static ReloadResult reloadModule() {
        Main.setupConfiguration();
        Main.loadFlagsProperties();
        return ReloadResult.builder().status(ReloadStatus.SUCCESS).reason("OK!").build();
    }

    private static void setupConfDirectory(String[] args) {
        String osName = System.getProperty("os.name");
        String root = "data";
        if (ExternalSwitch.parseBoolean("pbh.usePlatformConfigLocation")) {
            if (osName.contains("Windows")) {
                root = new File(System.getenv("LOCALAPPDATA"), "PeerBanHelper").getAbsolutePath();
            } else {
                Path dataDirectory = new File(System.getProperty("user.home")).toPath();
                dataDirectory = osName.contains("mac") ? dataDirectory.resolve("/Library/Application Support") : dataDirectory.resolve(".config");
                root = dataDirectory.resolve("PeerBanHelper").toAbsolutePath().toString();
            }
        }
        if (ExternalSwitch.parse("pbh.datadir") != null) {
            root = ExternalSwitch.parse("pbh.datadir");
        }
        dataDirectory = new File(root);
        cacheDirectory = new File(cacheDirectory, "cache");
        logsDirectory = new File(dataDirectory, "logs");
        configDirectory = new File(dataDirectory, "config");
        pluginDirectory = new File(dataDirectory, "plugins");
        debugDirectory = new File(dataDirectory, "debug");
        if (ExternalSwitch.parse("pbh.configdir") != null) {
            configDirectory = new File(ExternalSwitch.parse("pbh.configdir"));
        }
        if (ExternalSwitch.parse("pbh.logsdir") != null) {
            logsDirectory = new File(ExternalSwitch.parse("pbh.logsdir"));
        }
    }

    private static YamlConfiguration loadConfiguration(File file) {
        YamlConfiguration configuration = new YamlConfiguration();
        configuration.getOptions().setParseComments(true).setWidth(1000);
        try {
            configuration.load(file);
        }
        catch (IOException | InvalidConfigurationException e) {
            log.error("Unable to load configuration: invalid YAML configuration // \u65e0\u6cd5\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\uff1a\u65e0\u6548\u7684 YAML \u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u6709\u8bed\u6cd5\u9519\u8bef", e);
            if (!Desktop.isDesktopSupported() || ExternalSwitch.parse("pbh.nogui") != null || Arrays.stream(startupArgs).anyMatch(arg -> "nogui".equalsIgnoreCase((String)arg))) {
                try {
                    log.error("Bad configuration:  {}", (Object)Files.readString(file.toPath()));
                }
                catch (IOException ex) {
                    log.error("Unable to output the bad configuration content", (Throwable)ex);
                }
                log.error("Unable to load configuration: invalid YAML configuration // \u65e0\u6cd5\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\uff1a\u65e0\u6548\u7684 YAML \u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u6709\u8bed\u6cd5\u9519\u8bef", e);
            } else {
                JOptionPane.showMessageDialog(null, "Invalid/Corrupted YAML configuration | \u65e0\u6548\u6216\u635f\u574f\u7684 YAML \u914d\u7f6e\u6587\u4ef6", String.format("Failed to read configuration: %s", file), 0);
            }
            System.exit(1);
        }
        return configuration;
    }

    public static void setupConfiguration() {
        log.info("Loading configuration...");
        try {
            Main.initConfiguration();
            mainConfigFile = new File(configDirectory, "config.yml");
            mainConfig = Main.loadConfiguration(mainConfigFile);
            new PBHConfigUpdater(mainConfigFile, mainConfig, Main.class.getResourceAsStream("/config.yml")).update(new MainConfigUpdateScript(mainConfig));
            profileConfigFile = new File(configDirectory, "profile.yml");
            profileConfig = Main.loadConfiguration(profileConfigFile);
            new PBHConfigUpdater(profileConfigFile, profileConfig, Main.class.getResourceAsStream("/profile.yml")).update(new ProfileUpdateScript(profileConfig));
        }
        catch (IOException e) {
            log.error("Unable to load configuration, something went wrong!", (Throwable)e);
            System.exit(0);
        }
    }

    private static BuildMeta buildMeta() {
        BuildMeta meta = new BuildMeta();
        try (InputStream stream = Main.class.getResourceAsStream("/git.properties");){
            if (stream == null) {
                log.error("Error: Unable to load build metadata from JAR/git.properties: Bundled resources not exists");
            } else {
                Properties properties = new Properties();
                properties.load(stream);
                meta.loadBuildMeta(properties);
            }
        }
        catch (IOException e) {
            log.error("Error: Unable to load build metadata from <JAR>/git.properties", (Throwable)e);
        }
        return meta;
    }

    private static void setupShutdownHook() {
        Thread shutdownThread = new Thread(() -> {
            try {
                log.info("Shutting down...");
                eventBus.post((Object)new PBHShutdownEvent());
                server.shutdown();
                guiManager.close();
            }
            catch (Throwable th) {
                log.debug("Unable to shutdown gracefully, exiting with error", th);
            }
        });
        shutdownThread.setDaemon(false);
        shutdownThread.setName("ShutdownThread");
        Runtime.getRuntime().addShutdownHook(shutdownThread);
    }

    private static void initGUI(String[] args) {
        String guiType = mainConfig.getString("gui", "auto");
        if ("auto".equals(guiType)) {
            guiType = "swing";
        }
        if (Arrays.stream(args).anyMatch(arg -> "swing".equalsIgnoreCase((String)arg))) {
            guiType = "swing";
        } else if (Arrays.stream(args).anyMatch(arg -> "swt".equalsIgnoreCase((String)arg))) {
            guiType = "swt";
        } else if (Arrays.stream(args).anyMatch(arg -> "qt".equalsIgnoreCase((String)arg))) {
            guiType = "qt";
        }
        if (!Desktop.isDesktopSupported() || ExternalSwitch.parse("pbh.nogui") != null || Arrays.stream(args).anyMatch(arg -> "nogui".equalsIgnoreCase((String)arg))) {
            guiType = "console";
        }
        switch (guiType) {
            case "console": {
                guiManager = new PBHGuiManager(new ConsoleGuiImpl(args));
                break;
            }
            default: {
                guiManager = new PBHGuiManager(new SwingGuiImpl(args));
            }
        }
        guiManager.setup();
    }

    public static String getUserAgent() {
        if (userAgent != null) {
            return userAgent;
        }
        String userAgentTemplate = "PeerBanHelper/%s (%s; %s,%s,%s) BTN-Protocol/%s BTN-Protocol-Version/%s";
        OperatingSystemMXBean osMXBean = ManagementFactory.getOperatingSystemMXBean();
        String release = ExternalSwitch.parse("pbh.release");
        if (release == null) {
            release = "unknown";
        }
        String os = osMXBean.getName();
        String osVersion = osMXBean.getVersion();
        String buildNumber = "unknown";
        String codeName = "";
        try {
            SystemInfo info = new SystemInfo();
            OperatingSystem.OSVersionInfo verInfo = info.getOperatingSystem().getVersionInfo();
            buildNumber = verInfo.getBuildNumber();
            codeName = verInfo.getCodeName();
        }
        catch (Throwable e) {
            Sentry.captureException((Throwable)e);
            log.debug("Unable to get OS build number and code name", e);
        }
        userAgent = String.format(userAgentTemplate, meta.getVersion(), release, os, osVersion, codeName + buildNumber, PBH_BTN_PROTOCOL_READABLE_VERSION, 20);
        return userAgent;
    }

    private static void handleCommand(String input) {
    }

    private static boolean initConfiguration() throws IOException {
        log.info("PeerBanHelper data directory: {}", (Object)dataDirectory.getAbsolutePath());
        if (!dataDirectory.exists()) {
            dataDirectory.mkdirs();
        }
        if (!configDirectory.exists()) {
            configDirectory.mkdirs();
        }
        if (!configDirectory.isDirectory()) {
            configDirectory.delete();
            configDirectory.mkdirs();
            if (!configDirectory.isDirectory()) {
                throw new IllegalStateException("The path " + configDirectory.getAbsolutePath() + " should be a directory but found a file, auto fix failed.");
            }
        }
        if (!pluginDirectory.exists()) {
            pluginDirectory.mkdirs();
        }
        if (!debugDirectory.exists()) {
            debugDirectory.mkdirs();
        }
        boolean exists = true;
        File config = new File(configDirectory, "config.yml");
        File profile = new File(configDirectory, "profile.yml");
        if (!config.exists()) {
            exists = false;
            Files.copy(Main.class.getResourceAsStream("/config.yml"), config.toPath(), new CopyOption[0]);
        }
        if (!profile.exists()) {
            exists = false;
            Files.copy(Main.class.getResourceAsStream("/profile.yml"), profile.toPath(), new CopyOption[0]);
        }
        return exists;
    }

    public static String decapitalize(String name) {
        if (name == null || name.isEmpty()) {
            return name;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    private static void setupScriptEngine() {
        AviatorEvaluator.getInstance().setCachedExpressionByDefault(true);
        AviatorEvaluator.getInstance().setOption(Options.EVAL_MODE, (Object)EvalMode.ASM);
        AviatorEvaluator.getInstance().setOption(Options.OPTIMIZE_LEVEL, (Object)1);
        AviatorEvaluator.getInstance().setOption(Options.MATH_CONTEXT, (Object)MathContext.DECIMAL32);
        AviatorEvaluator.getInstance().setOption(Options.ENABLE_PROPERTY_SYNTAX_SUGAR, (Object)true);
        AviatorEvaluator.getInstance().setFunctionMissing((FunctionMissing)JavaMethodReflectionFunctionMissing.getInstance());
        Main.registerFunctions(IPAddressUtil.class);
        Main.registerFunctions(HTTPUtil.class);
        Main.registerFunctions(JsonUtil.class);
        Main.registerFunctions(Lang.class);
        Main.registerFunctions(StrUtil.class);
        Main.registerFunctions(PeerBanHelper.class);
        Main.registerFunctions(InfoHashUtil.class);
        Main.registerFunctions(CommonUtil.class);
        Main.registerFunctions(ByteUtil.class);
        Main.registerFunctions(MiscUtil.class);
        Main.registerFunctions(MsgUtil.class);
        Main.registerFunctions(SharedObject.class);
        Main.registerFunctions(UrlEncoderDecoder.class);
        Main.registerFunctions(URLUtil.class);
        Main.registerFunctions(WebUtil.class);
        Main.registerFunctions(RSAUtils.class);
        Main.registerFunctions(Pageable.class);
        Main.registerFunctions(TextManager.class);
        Main.registerFunctions(ExchangeMap.class);
        Main.registerFunctions(Main.class);
    }

    private static void registerFunctions(Class<?> clazz) {
        try {
            AviatorEvaluator.addInstanceFunctions((String)StrUtil.uncapitalize(clazz.getSimpleName()), clazz);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            log.error("Internal error: failed on register instance functions: {}", (Object)clazz.getName(), (Object)e);
            Sentry.captureException((Throwable)e);
        }
        try {
            AviatorEvaluator.addStaticFunctions((String)StrUtil.capitalize(clazz.getSimpleName()), clazz);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            log.error("Internal error: failed on register static functions: {}", (Object)clazz.getName(), (Object)e);
            Sentry.captureException((Throwable)e);
        }
    }

    public static void restartApplication() {
        try {
            String javaBin = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
            if (System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("win")) {
                javaBin = javaBin + ".exe";
            }
            String classpath = System.getProperty("java.class.path");
            String[] jvmArgs = ManagementFactory.getRuntimeMXBean().getInputArguments().toArray(new String[0]);
            ArrayList<String> command = new ArrayList<String>();
            command.add(javaBin);
            for (String arg : jvmArgs) {
                if (arg.startsWith("-agentlib:jdwp") || arg.startsWith("-Xrunjdwp")) continue;
                command.add(arg);
            }
            command.add("-cp");
            command.add(classpath);
            command.add(Main.class.getName());
            if (startupArgs != null) {
                command.addAll(Arrays.asList(startupArgs));
            }
            log.info("Restarting application with command: {}", (Object)String.join((CharSequence)" ", command));
            ProcessBuilder processBuilder = new ProcessBuilder(command);
            processBuilder.inheritIO();
            processBuilder.directory(new File(System.getProperty("user.dir")));
            processBuilder.start();
            System.exit(0);
        }
        catch (Exception e) {
            log.error("Failed to restart application", (Throwable)e);
            throw new RuntimeException("Failed to restart application", e);
        }
    }

    @Generated
    public static UUID getRuntimeInstanceId() {
        return runtimeInstanceId;
    }

    @Generated
    public static EventBus getEventBus() {
        return eventBus;
    }

    @Generated
    public static ReloadManager getReloadManager() {
        return reloadManager;
    }

    @Generated
    public static File getDataDirectory() {
        return dataDirectory;
    }

    @Generated
    public static File getCacheDirectory() {
        return cacheDirectory;
    }

    @Generated
    public static File getLogsDirectory() {
        return logsDirectory;
    }

    @Generated
    public static File getConfigDirectory() {
        return configDirectory;
    }

    @Generated
    public static File getPluginDirectory() {
        return pluginDirectory;
    }

    @Generated
    public static File getDebugDirectory() {
        return debugDirectory;
    }

    @Generated
    public static PeerBanHelper getServer() {
        return server;
    }

    @Generated
    public static PBHGuiManager getGuiManager() {
        return guiManager;
    }

    @Generated
    public static File getMainConfigFile() {
        return mainConfigFile;
    }

    @Generated
    public static File getProfileConfigFile() {
        return profileConfigFile;
    }

    @Generated
    public static AnnotationConfigApplicationContext getApplicationContext() {
        return applicationContext;
    }

    @Generated
    public static String getPbhServerAddress() {
        return pbhServerAddress;
    }

    @Generated
    public static YamlConfiguration getMainConfig() {
        return mainConfig;
    }

    @Generated
    public static YamlConfiguration getProfileConfig() {
        return profileConfig;
    }

    @Generated
    public static BuildMeta getMeta() {
        return meta;
    }

    @Generated
    public static String[] getStartupArgs() {
        return startupArgs;
    }

    @Generated
    public static long getStartupAt() {
        return startupAt;
    }

    @Nullable
    @Generated
    public static Platform getPlatform() {
        return platform;
    }

    @Generated
    public static JavalinWebContainer getWebContainer() {
        return webContainer;
    }

    static {
        startupAt = System.currentTimeMillis();
    }
}

