/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.btn.ability.impl;

import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.btn.BtnNetwork;
import com.ghostchu.peerbanhelper.btn.BtnRuleset;
import com.ghostchu.peerbanhelper.btn.BtnRulesetParsed;
import com.ghostchu.peerbanhelper.btn.ability.AbstractBtnAbility;
import com.ghostchu.peerbanhelper.databasent.service.MetadataService;
import com.ghostchu.peerbanhelper.event.btn.BtnRuleUpdateEvent;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.util.URLUtil;
import com.ghostchu.peerbanhelper.util.backgroundtask.FunctionalBackgroundTask;
import com.ghostchu.peerbanhelper.util.json.JsonUtil;
import com.ghostchu.peerbanhelper.util.rule.matcher.IPMatcher;
import com.ghostchu.peerbanhelper.util.scriptengine.ScriptEngineManager;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BtnAbilityRules
extends AbstractBtnAbility {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BtnAbilityRules.class);
    private final BtnNetwork btnNetwork;
    private final long interval;
    private final String endpoint;
    private final long randomInitialDelay;
    private final ScriptEngineManager scriptEngineManager;
    private final boolean scriptExecute;
    private final boolean powCaptcha;
    private final MetadataService metadataDao;
    private BtnRulesetParsed btnRule;

    public BtnAbilityRules(BtnNetwork btnNetwork, MetadataService metadataDao, ScriptEngineManager scriptEngineManager, JsonObject ability, boolean scriptExecute) {
        this.btnNetwork = btnNetwork;
        this.metadataDao = metadataDao;
        this.scriptEngineManager = scriptEngineManager;
        this.interval = ability.get("interval").getAsLong();
        this.endpoint = ability.get("endpoint").getAsString();
        this.randomInitialDelay = ability.get("random_initial_delay").getAsLong();
        this.powCaptcha = ability.has("pow_captcha") && ability.get("pow_captcha").getAsBoolean();
        this.scriptExecute = scriptExecute;
        this.setLastStatus(true, new TranslationComponent(Lang.BTN_STAND_BY));
    }

    private void loadCacheFile() {
        try {
            String cache = this.metadataDao.get("btn.ability.rules.cache");
            if (cache != null) {
                BtnRuleset btnRuleset = (BtnRuleset)JsonUtil.getGson().fromJson(cache, BtnRuleset.class);
                this.btnRule = new BtnRulesetParsed(this.scriptEngineManager, btnRuleset, this.scriptExecute);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public String getName() {
        return "BtnAbilityRuleset (Legacy)";
    }

    @Override
    public TranslationComponent getDisplayName() {
        return new TranslationComponent(Lang.BTN_ABILITY_RULES);
    }

    @Override
    public TranslationComponent getDescription() {
        if (this.btnRule == null) {
            return new TranslationComponent(Lang.BTN_ABILITY_RULES_DESCRIPTION, "N/A", 0, 0, 0, 0, 0);
        }
        return new TranslationComponent(Lang.BTN_ABILITY_RULES_DESCRIPTION, this.btnRule.getVersion(), this.btnRule.size(), this.btnRule.getIpRules().values().stream().mapToLong(IPMatcher::size).sum(), this.btnRule.getPeerIdRules().values().stream().mapToLong(List::size).sum(), this.btnRule.getClientNameRules().values().stream().mapToLong(List::size).sum(), this.btnRule.getPortRules().values().stream().mapToLong(List::size).sum(), this.btnRule.getScriptRules().size());
    }

    @Override
    public void load() {
        try {
            this.loadCacheFile();
            this.setLastStatus(true, new TranslationComponent(Lang.BTN_RULES_LOADED_FROM_CACHE));
        }
        catch (Exception e) {
            log.error(TextManager.tlUI(Lang.BTN_RULES_LOAD_FROM_CACHE_FAILED, new Object[0]));
            this.setLastStatus(false, new TranslationComponent(e.getClass().getName() + ": " + e.getMessage()));
        }
        this.btnNetwork.getScheduler().scheduleWithFixedDelay(this::updateRule, ThreadLocalRandom.current().nextLong(this.randomInitialDelay), this.interval, TimeUnit.MILLISECONDS);
    }

    private void updateRule() {
        this.btnNetwork.getBackgroundTaskManager().addTaskAsync(new FunctionalBackgroundTask(new TranslationComponent(Lang.BTN_ABILITY_RULEES_SYNC_SERVER), (task, callback) -> {
            String version = this.btnRule == null || this.btnRule.getVersion() == null ? "initial" : this.btnRule.getVersion();
            String url = URLUtil.appendUrl(this.endpoint, Map.of("rev", version));
            Request.Builder request = new Request.Builder().url(url).get();
            if (this.powCaptcha) {
                this.btnNetwork.gatherAndSolveCaptchaBlocking(request, "rule_peer_identity");
            }
            try (Response response = this.btnNetwork.getHttpClient().newCall(request.build()).execute();){
                if (response.code() == 204) {
                    this.setLastStatus(true, new TranslationComponent(Lang.BTN_RULES_LOADED_FROM_REMOTE, this.btnRule.getVersion()));
                    return;
                }
                if (!response.isSuccessful()) {
                    String responseBody = response.body().string();
                    log.error(TextManager.tlUI(Lang.BTN_REQUEST_FAILS, response.code() + " - " + responseBody));
                    this.setLastStatus(false, new TranslationComponent(Lang.BTN_HTTP_ERROR, response.code(), responseBody));
                } else {
                    try {
                        String responseBody = response.body().string();
                        BtnRuleset btr = (BtnRuleset)JsonUtil.getGson().fromJson(responseBody, BtnRuleset.class);
                        this.btnRule = new BtnRulesetParsed(this.scriptEngineManager, btr, this.scriptExecute);
                        Main.getEventBus().post((Object)new BtnRuleUpdateEvent());
                        this.metadataDao.set("btn.ability.rules.cache", JsonUtil.getGson().toJson((Object)btr));
                        log.info(TextManager.tlUI(Lang.BTN_UPDATE_RULES_SUCCESSES, this.btnRule.getVersion()));
                        this.setLastStatus(true, new TranslationComponent(Lang.BTN_RULES_LOADED_FROM_REMOTE, this.btnRule.getVersion()));
                        this.btnNetwork.getModuleMatchCache().invalidateAll();
                    }
                    catch (JsonSyntaxException e) {
                        String responseBody = response.body().string();
                        this.setLastStatus(false, new TranslationComponent("JsonSyntaxException: " + response.code() + " - " + responseBody));
                        log.error("Unable to parse BtnRule as a valid Json object: {}-{}", new Object[]{response.code(), responseBody, e});
                    }
                }
            }
            catch (Exception e) {
                log.error(TextManager.tlUI(Lang.BTN_REQUEST_FAILS, new Object[0]), (Throwable)e);
                this.setLastStatus(false, new TranslationComponent(Lang.BTN_UNKNOWN_ERROR, e.getClass().getName() + ": " + e.getMessage()));
            }
        })).join();
    }

    @Override
    public void unload() {
    }

    @Generated
    public BtnRulesetParsed getBtnRule() {
        return this.btnRule;
    }
}

