/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.btn.ability.impl.legacy;

import com.ghostchu.peerbanhelper.btn.BtnNetwork;
import com.ghostchu.peerbanhelper.btn.ability.AbstractBtnAbility;
import com.ghostchu.peerbanhelper.btn.ping.legacy.LegacyBtnPeer;
import com.ghostchu.peerbanhelper.btn.ping.legacy.LegacyBtnPeerPing;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.util.json.JsonUtil;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.BufferedSink;
import okio.GzipSink;
import okio.Okio;
import okio.Sink;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LegacyBtnAbilitySubmitPeers
extends AbstractBtnAbility {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LegacyBtnAbilitySubmitPeers.class);
    private final BtnNetwork btnNetwork;
    private final long interval;
    private final String endpoint;
    private final long randomInitialDelay;

    public LegacyBtnAbilitySubmitPeers(BtnNetwork btnNetwork, JsonObject ability) {
        this.btnNetwork = btnNetwork;
        this.interval = ability.get("interval").getAsLong();
        this.endpoint = ability.get("endpoint").getAsString();
        this.randomInitialDelay = ability.get("random_initial_delay").getAsLong();
    }

    @Override
    public String getName() {
        return "BtnAbilitySubmitPeers (Legacy)";
    }

    @Override
    public TranslationComponent getDisplayName() {
        return new TranslationComponent(Lang.BTN_ABILITY_SUBMIT_SNAPSHOT);
    }

    @Override
    public TranslationComponent getDescription() {
        return new TranslationComponent(Lang.BTN_ABILITY_SUBMIT_SNAPSHOT_DESCRIPTION);
    }

    @Override
    public void load() {
        this.setLastStatus(true, new TranslationComponent(Lang.BTN_NO_CONTENT_REPORTED_YET));
        this.btnNetwork.getScheduler().scheduleWithFixedDelay(this::submit, this.interval + ThreadLocalRandom.current().nextLong(this.randomInitialDelay), this.interval, TimeUnit.MILLISECONDS);
    }

    private void submit() {
        try {
            log.info(TextManager.tlUI(Lang.BTN_SUBMITTING_PEERS, new Object[0]));
            List<LegacyBtnPeer> btnPeers = this.generatePing();
            if (btnPeers.isEmpty()) {
                this.setLastStatus(true, new TranslationComponent(Lang.BTN_LAST_REPORT_EMPTY));
                return;
            }
            LegacyBtnPeerPing ping = new LegacyBtnPeerPing(System.currentTimeMillis(), btnPeers);
            byte[] jsonBytes = JsonUtil.getGson().toJson((Object)ping).getBytes(StandardCharsets.UTF_8);
            RequestBody body = this.createGzipRequestBody(jsonBytes);
            Request request = new Request.Builder().url(this.endpoint).post(body).header("Content-Encoding", "gzip").build();
            try (Response response = this.btnNetwork.getHttpClient().newCall(request).execute();){
                if (!response.isSuccessful()) {
                    String responseBody = response.body().string();
                    log.error(TextManager.tlUI(Lang.BTN_REQUEST_FAILS, response.code() + " - " + responseBody));
                    this.setLastStatus(false, new TranslationComponent(Lang.BTN_HTTP_ERROR, response.code(), responseBody));
                } else {
                    log.info(TextManager.tlUI(Lang.BTN_SUBMITTED_PEERS, btnPeers.size()));
                    this.setLastStatus(true, new TranslationComponent(Lang.BTN_REPORTED_DATA, btnPeers.size()));
                }
            }
            catch (Exception e) {
                log.warn(TextManager.tlUI(Lang.BTN_REQUEST_FAILS, new Object[0]), (Throwable)e);
                this.setLastStatus(false, new TranslationComponent(e.getClass().getName() + ": " + e.getMessage()));
            }
        }
        catch (Throwable e) {
            log.error(TextManager.tlUI(Lang.BTN_SUBMIT_PEERS_FAILED, new Object[0]), e);
            this.setLastStatus(false, new TranslationComponent(Lang.BTN_UNKNOWN_ERROR, e.getClass().getName() + ": " + e.getMessage()));
        }
    }

    private List<LegacyBtnPeer> generatePing() {
        ArrayList<LegacyBtnPeer> btnPeers = new ArrayList<LegacyBtnPeer>();
        this.btnNetwork.getServer().getLivePeersSnapshot().forEach((pa, pm) -> pm.forEach(meta -> btnPeers.add(LegacyBtnPeer.from(meta.getTorrent(), meta.getPeer()))));
        return btnPeers;
    }

    private RequestBody createGzipRequestBody(final byte[] data) {
        return new RequestBody(this){
            {
                Objects.requireNonNull(this$0);
            }

            public MediaType contentType() {
                return MediaType.get((String)"application/json");
            }

            public void writeTo(@NotNull BufferedSink sink) throws IOException {
                BufferedSink gzipSink = Okio.buffer((Sink)new GzipSink((Sink)sink));
                gzipSink.write(data);
                gzipSink.close();
            }
        };
    }

    @Override
    public void unload() {
    }
}

