/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.configuration;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.extension.parser.JsqlParserGlobal;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.OptimisticLockerInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import com.ghostchu.peerbanhelper.ExternalSwitch;
import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.configuration.SentryMyBatisInterceptor;
import com.ghostchu.peerbanhelper.databasent.DatabaseDriver;
import com.ghostchu.peerbanhelper.databasent.DatabaseType;
import com.ghostchu.peerbanhelper.databasent.driver.AbstractDatabaseDriver;
import com.ghostchu.peerbanhelper.databasent.driver.common.BasicIPAddressTypeHandler;
import com.ghostchu.peerbanhelper.databasent.driver.common.BasicInetTypeHandler;
import com.ghostchu.peerbanhelper.databasent.driver.common.OffsetDateTimeTypeHandlerForwarder;
import com.ghostchu.peerbanhelper.databasent.driver.h2.H2DatabaseDriver;
import com.ghostchu.peerbanhelper.databasent.driver.mysql.MySQLDatabaseDriver;
import com.ghostchu.peerbanhelper.databasent.driver.postgres.PostgresDatabaseDriver;
import com.ghostchu.peerbanhelper.databasent.driver.sqlite.SQLiteDatabaseDriver;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import lombok.Generated;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.type.TypeHandler;
import org.bspfsystems.yamlconfiguration.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@Configuration
@MapperScan(value={"com.ghostchu.peerbanhelper.databasent.mapper.java"})
public class DatabaseDriverConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DatabaseDriverConfig.class);
    public static DatabaseDriver databaseDriver;

    @PostConstruct
    public void setupJsqlParserThreadPool() {
        int parallelism = ExternalSwitch.parseInt("pbh.database.jsqlparser.thread-pool.parallelism", Math.min(4, Runtime.getRuntime().availableProcessors()));
        ExecutorService executorService = Executors.newWorkStealingPool(parallelism);
        JsqlParserGlobal.setExecutorService((ExecutorService)executorService, (Thread)Thread.ofVirtual().unstarted(() -> {
            if (!executorService.isShutdown()) {
                executorService.shutdown();
            }
        }));
    }

    @Bean
    public DatabaseDriver loadDriver() throws Exception {
        String databaseTypeId;
        log.info(TextManager.tlUI(Lang.DBNT_LOADING_DRIVER, new Object[0]));
        ConfigurationSection section = Main.getMainConfig().getConfigurationSection("database");
        if (section == null) {
            throw new IllegalStateException("Database configuration section is missing!");
        }
        AbstractDatabaseDriver driver = switch (databaseTypeId = section.getString("type", "sqlite").toLowerCase()) {
            case "h2" -> new H2DatabaseDriver(section);
            case "mysql" -> new MySQLDatabaseDriver(section);
            case "postgresql" -> new PostgresDatabaseDriver(section);
            default -> new SQLiteDatabaseDriver(section);
        };
        log.info(TextManager.tlUI(Lang.DBNT_LOADING_DRIVER_LOADED, driver.getType().name()));
        databaseDriver = driver;
        return driver;
    }

    @Bean
    public PlatformTransactionManager transactionManager(@NotNull DatabaseDriver driver) {
        return new DataSourceTransactionManager(driver.getDataSource());
    }

    @Bean
    public MybatisPlusInterceptor mybatisPlusInterceptor(@NotNull DatabaseDriver databaseDriver) {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        DbType dbType = switch (databaseDriver.getType()) {
            default -> throw new MatchException(null, null);
            case DatabaseType.H2 -> DbType.MYSQL;
            case DatabaseType.POSTGRES -> DbType.POSTGRE_SQL;
            case DatabaseType.MYSQL -> DbType.MYSQL;
            case DatabaseType.SQLITE -> DbType.SQLITE;
        };
        PaginationInnerInterceptor pagination = new PaginationInnerInterceptor(dbType);
        pagination.setMaxLimit(Long.valueOf(1000L));
        interceptor.addInnerInterceptor((InnerInterceptor)new OptimisticLockerInnerInterceptor());
        interceptor.addInnerInterceptor((InnerInterceptor)pagination);
        return interceptor;
    }

    @Bean
    public SqlSessionFactory sqlSessionFactory(MybatisPlusInterceptor mpInterceptor, SentryMyBatisInterceptor sentryMyBatisInterceptor, DatabaseDriver driver) throws Exception {
        MybatisSqlSessionFactoryBean factoryBean = new MybatisSqlSessionFactoryBean();
        factoryBean.setDataSource(driver.getDataSource());
        ArrayList<Object> interceptorList = new ArrayList<Object>();
        interceptorList.add(mpInterceptor);
        interceptorList.add(sentryMyBatisInterceptor);
        factoryBean.setPlugins(interceptorList.toArray(new Interceptor[0]));
        factoryBean.setTypeHandlers(new TypeHandler[]{new BasicInetTypeHandler(), new BasicIPAddressTypeHandler(), new OffsetDateTimeTypeHandlerForwarder()});
        String xmlPath = "classpath*:" + driver.getMapperXmlPath();
        log.info(TextManager.tlUI(Lang.DBNT_LOADING_MAPPER, xmlPath));
        factoryBean.setMapperLocations(new PathMatchingResourcePatternResolver().getResources(xmlPath));
        return factoryBean.getObject();
    }

    @Bean
    public TransactionTemplate transactionTemplate(PlatformTransactionManager platformTransactionManager) {
        return new TransactionTemplate(platformTransactionManager);
    }
}

