/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.configuration;

import com.ghostchu.peerbanhelper.ExternalSwitch;
import com.ghostchu.peerbanhelper.databasent.DatabaseDriver;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import jakarta.annotation.PostConstruct;
import java.sql.Connection;
import java.util.Arrays;
import java.util.Comparator;
import lombok.Generated;
import org.flywaydb.core.Flyway;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.init.ScriptUtils;

@Configuration
public class DatabaseSchemaInitializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DatabaseSchemaInitializer.class);
    private final DatabaseDriver databaseDriver;

    @PostConstruct
    public void init() {
        log.info(TextManager.tlUI(Lang.DBNT_FLYWAY_VALIDATING_SCHEMA, this.databaseDriver.getType().name()));
        try {
            String migrationType = this.databaseDriver.getType().getMigrationType();
            String repeatType = this.databaseDriver.getType().getRepeatType();
            Flyway flyway = Flyway.configure().dataSource(this.databaseDriver.getDataSource()).locations(new String[]{"classpath:db/migration/" + migrationType}).baselineOnMigrate(true).validateOnMigrate(ExternalSwitch.parseBoolean("dbnt.flyway.validateOnMigrate", true)).load();
            flyway.migrate();
            log.debug("Running repeat scripts for {}", (Object)migrationType);
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
            Resource[] resources = resolver.getResources("classpath:db/repeat/" + repeatType + "/*.sql");
            Arrays.sort(resources, Comparator.comparing(Resource::getFilename));
            try (Connection conn = this.databaseDriver.getDataSource().getConnection();){
                for (Resource resource : resources) {
                    log.debug("Executing repeat script: {}", (Object)resource.getFilename());
                    ScriptUtils.executeSqlScript((Connection)conn, (Resource)resource);
                }
            }
        }
        catch (Exception e) {
            log.error(TextManager.tlUI(Lang.DBNT_FLYWAY_ERROR, new Object[0]), (Throwable)e);
            throw new RuntimeException(TextManager.tlUI(Lang.DBNT_FLYWAY_ERROR, new Object[0]), e);
        }
    }

    @Generated
    public DatabaseSchemaInitializer(DatabaseDriver databaseDriver) {
        this.databaseDriver = databaseDriver;
    }
}

