/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.databasent.driver.common;

import com.baomidou.mybatisplus.extension.handlers.JacksonTypeHandler;
import com.ghostchu.peerbanhelper.configuration.DatabaseDriverConfig;
import com.ghostchu.peerbanhelper.databasent.DatabaseType;
import com.ghostchu.peerbanhelper.databasent.driver.common.BasicJsonTypeHandler;
import com.ghostchu.peerbanhelper.databasent.driver.postgres.PGJsonbTypeHandler;
import java.lang.reflect.Field;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import lombok.Generated;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MappedTypes(value={Object.class})
public class JsonTypeHandlerForwarder
extends JacksonTypeHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JsonTypeHandlerForwarder.class);
    private JacksonTypeHandler typeHandler;

    public JsonTypeHandlerForwarder(Class<?> type) {
        super(type);
    }

    public JsonTypeHandlerForwarder(Class<?> type, Field field) {
        super(type, field);
    }

    public void prepareTypeHandler() {
        if (this.typeHandler == null) {
            this.typeHandler = DatabaseDriverConfig.databaseDriver.getType() == DatabaseType.POSTGRES ? new PGJsonbTypeHandler(this.type) : new BasicJsonTypeHandler(this.type);
        }
    }

    public Object parse(String json) {
        this.prepareTypeHandler();
        return this.typeHandler.parse(json);
    }

    public String toJson(Object obj) {
        this.prepareTypeHandler();
        return this.typeHandler.toJson(obj);
    }

    public void setNonNullParameter(PreparedStatement ps, int i, Object parameter, JdbcType jdbcType) throws SQLException {
        this.prepareTypeHandler();
        this.typeHandler.setNonNullParameter(ps, i, parameter, jdbcType);
    }
}

