/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.databasent.mapper.java;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ghostchu.peerbanhelper.databasent.dto.ClientAnalyseResult;
import com.ghostchu.peerbanhelper.databasent.dto.IPAddressTimeSeen;
import com.ghostchu.peerbanhelper.databasent.dto.IPAddressTotalTraffic;
import com.ghostchu.peerbanhelper.databasent.dto.TorrentCount;
import com.ghostchu.peerbanhelper.databasent.table.PeerRecordEntity;
import java.net.InetAddress;
import java.time.OffsetDateTime;
import java.util.List;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PeerRecordMapper
extends BaseMapper<PeerRecordEntity> {
    @Select(value={"SELECT COUNT(DISTINCT address) FROM peer_records WHERE downloader = #{downloader} AND lastTimeSeen >= #{startAt} AND firstTimeSeen <= #{endAt}"})
    public long sessionBetween(@NotNull String var1, @NotNull OffsetDateTime var2, @NotNull OffsetDateTime var3);

    public IPAddressTotalTraffic queryAddressTotalTraffic(InetAddress var1);

    public IPAddressTimeSeen queryAddressTimeSeen(InetAddress var1);

    @NotNull
    public Page<PeerRecordEntity> queryAccessHistoryByIp(@NotNull Page<PeerRecordEntity> var1, @NotNull InetAddress var2, @NotNull String var3);

    @NotNull
    public Page<ClientAnalyseResult> queryClientAnalyse(@NotNull Page<ClientAnalyseResult> var1, @NotNull OffsetDateTime var2, @NotNull OffsetDateTime var3, @Nullable String var4, @NotNull String var5);

    public List<TorrentCount> countByTorrentIds(@Param(value="torrentIds") List<Long> var1);

    public List<String> getDistinctIps(@Param(value="start") OffsetDateTime var1, @Param(value="end") OffsetDateTime var2, @Param(value="downloader") String var3);

    public int upsert(@Param(value="e") PeerRecordEntity var1);
}

