/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.databasent.migration.migrators;

import com.ghostchu.peerbanhelper.databasent.migration.MigrationContext;
import com.ghostchu.peerbanhelper.databasent.migration.TableMigrator;
import com.ghostchu.peerbanhelper.databasent.service.PCBAddressService;
import com.ghostchu.peerbanhelper.databasent.table.PCBAddressEntity;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PCBAddressMigrator
implements TableMigrator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PCBAddressMigrator.class);
    private final PCBAddressService pcbAddressService;

    public PCBAddressMigrator(PCBAddressService pcbAddressService) {
        this.pcbAddressService = pcbAddressService;
    }

    @Override
    public String getTableName() {
        return "pcb_address";
    }

    @Override
    public int getMigrationOrder() {
        return 90;
    }

    @Override
    public boolean isTableAvailable(Connection sqliteConnection) throws Exception {
        String query = "SELECT name FROM sqlite_master WHERE type='table' AND name='pcb_address'";
        try (Statement stmt = sqliteConnection.createStatement();){
            boolean bl;
            block12: {
                ResultSet rs = stmt.executeQuery(query);
                try {
                    bl = rs.next();
                    if (rs == null) break block12;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return bl;
        }
    }

    @Override
    public long migrate(Connection sqliteConnection, MigrationContext context) throws Exception {
        log.info("Starting migration of pcb_address table...");
        String selectQuery = "SELECT ip, port, torrentId, lastReportProgress, lastReportUploaded,\n       trackingUploadedIncreaseTotal, rewindCounter, progressDifferenceCounter,\n       firstTimeSeen, lastTimeSeen, downloader, banDelayWindowEndAt,\n       fastPcbTestExecuteAt, lastTorrentCompletedSize\nFROM pcb_address\n";
        long count = 0L;
        long totalCount = this.getTotalCount(sqliteConnection);
        long lastLogged = 0L;
        try (PreparedStatement ps = sqliteConnection.prepareStatement(selectQuery);
             ResultSet rs = ps.executeQuery();){
            ArrayList<PCBAddressEntity> batch = new ArrayList<PCBAddressEntity>();
            while (rs.next()) {
                try {
                    PCBAddressEntity entity = new PCBAddressEntity();
                    String ipStr = rs.getString("ip");
                    entity.setIp(InetAddress.getByName(ipStr));
                    entity.setPort(rs.getInt("port"));
                    entity.setTorrentId(rs.getString("torrentId"));
                    entity.setLastReportProgress(rs.getDouble("lastReportProgress"));
                    entity.setLastReportUploaded(rs.getLong("lastReportUploaded"));
                    entity.setTrackingUploadedIncreaseTotal(rs.getLong("trackingUploadedIncreaseTotal"));
                    entity.setRewindCounter(rs.getInt("rewindCounter"));
                    entity.setProgressDifferenceCounter(rs.getInt("progressDifferenceCounter"));
                    Timestamp firstTimeSeen = rs.getTimestamp("firstTimeSeen");
                    Timestamp lastTimeSeen = rs.getTimestamp("lastTimeSeen");
                    Timestamp banDelayWindowEndAt = rs.getTimestamp("banDelayWindowEndAt");
                    entity.setFirstTimeSeen(firstTimeSeen != null ? OffsetDateTime.ofInstant(firstTimeSeen.toInstant(), ZoneId.systemDefault()) : null);
                    entity.setLastTimeSeen(lastTimeSeen != null ? OffsetDateTime.ofInstant(lastTimeSeen.toInstant(), ZoneId.systemDefault()) : null);
                    entity.setBanDelayWindowEndAt(banDelayWindowEndAt != null ? OffsetDateTime.ofInstant(banDelayWindowEndAt.toInstant(), ZoneId.systemDefault()) : null);
                    entity.setDownloader(rs.getString("downloader"));
                    long fastPcbTestExecuteAtMillis = rs.getLong("fastPcbTestExecuteAt");
                    entity.setFastPcbTestExecuteAt(OffsetDateTime.ofInstant(Instant.ofEpochMilli(fastPcbTestExecuteAtMillis), ZoneId.systemDefault()));
                    entity.setLastTorrentCompletedSize(rs.getLong("lastTorrentCompletedSize"));
                    batch.add(entity);
                    if (batch.size() < context.getBatchSize()) continue;
                    this.pcbAddressService.getBaseMapper().insertOrUpdate(batch);
                    batch.clear();
                    if (!MigrationContext.shouldLogProgress(count += (long)batch.size(), totalCount, lastLogged)) continue;
                    log.info(TextManager.tlUI(Lang.DBNT_MIGRATOR_MIGRATING_PROGRESS, count, totalCount, "pcb_address", MigrationContext.formatProgress(count, totalCount)));
                    lastLogged = count;
                }
                catch (Exception e) {
                    log.error("Failed to migrate pcb_address record: {}", (Object)e.getMessage());
                }
            }
            if (!batch.isEmpty()) {
                this.pcbAddressService.getBaseMapper().insertOrUpdate(batch);
                count += (long)batch.size();
            }
        }
        log.info(TextManager.tlUI(Lang.DBNT_MIGRATOR_MIGRATING_COMPLETED, count, "pcb_address"));
        context.incrementTotalRecords(count);
        return count;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getTotalCount(Connection sqliteConnection) {
        try (Statement stmt = sqliteConnection.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT COUNT(*) FROM pcb_address");){
            if (!rs.next()) return 0L;
            long l = rs.getLong(1);
            return l;
        }
        catch (Exception e) {
            log.warn("Failed to get total count for pcb_address table", (Throwable)e);
        }
        return 0L;
    }
}

