/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.databasent.migration.migrators;

import com.ghostchu.peerbanhelper.databasent.migration.MigrationContext;
import com.ghostchu.peerbanhelper.databasent.migration.TableMigrator;
import com.ghostchu.peerbanhelper.databasent.service.PeerConnectionMetricsTrackService;
import com.ghostchu.peerbanhelper.databasent.table.PeerConnectionMetricsTrackEntity;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerConnectionMetricsTrackMigrator
implements TableMigrator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PeerConnectionMetricsTrackMigrator.class);
    private final PeerConnectionMetricsTrackService service;

    public PeerConnectionMetricsTrackMigrator(PeerConnectionMetricsTrackService service) {
        this.service = service;
    }

    @Override
    public String getTableName() {
        return "peer_connection_metrics_track";
    }

    @Override
    public int getMigrationOrder() {
        return 101;
    }

    @Override
    public boolean isTableAvailable(Connection sqliteConnection) throws Exception {
        String query = "SELECT name FROM sqlite_master WHERE type='table' AND name='peer_connection_metrics_track'";
        try (Statement stmt = sqliteConnection.createStatement();){
            boolean bl;
            block12: {
                ResultSet rs = stmt.executeQuery(query);
                try {
                    bl = rs.next();
                    if (rs == null) break block12;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return bl;
        }
    }

    @Override
    public long migrate(Connection sqliteConnection, MigrationContext context) throws Exception {
        String selectQuery = "SELECT timeframeAt, downloader, torrent_id, address, port,\n       peerId, clientName, lastFlags\nFROM peer_connection_metrics_track\n";
        long count = 0L;
        long totalCount = this.getTotalCount(sqliteConnection);
        long lastLogged = 0L;
        try (PreparedStatement ps = sqliteConnection.prepareStatement(selectQuery);
             ResultSet rs = ps.executeQuery();){
            ArrayList<PeerConnectionMetricsTrackEntity> batch = new ArrayList<PeerConnectionMetricsTrackEntity>();
            while (rs.next()) {
                try {
                    PeerConnectionMetricsTrackEntity entity = new PeerConnectionMetricsTrackEntity();
                    Timestamp timeframeAt = rs.getTimestamp("timeframeAt");
                    entity.setTimeframeAt(timeframeAt != null ? OffsetDateTime.ofInstant(timeframeAt.toInstant(), ZoneId.systemDefault()) : null);
                    entity.setDownloader(rs.getString("downloader"));
                    entity.setTorrentId(rs.getLong("torrent_id"));
                    String addressStr = rs.getString("address");
                    entity.setAddress(InetAddress.getByName(addressStr));
                    entity.setPort(rs.getInt("port"));
                    entity.setPeerId(rs.getString("peerId"));
                    entity.setClientName(rs.getString("clientName"));
                    entity.setLastFlags(rs.getString("lastFlags"));
                    batch.add(entity);
                    if (batch.size() < context.getBatchSize()) continue;
                    this.service.getBaseMapper().insertOrUpdate(batch);
                    batch.clear();
                    if (!MigrationContext.shouldLogProgress(count += (long)batch.size(), totalCount, lastLogged)) continue;
                    log.info(TextManager.tlUI(Lang.DBNT_MIGRATOR_MIGRATING_PROGRESS, count, totalCount, "peer_connection_metrics_track", MigrationContext.formatProgress(count, totalCount)));
                    lastLogged = count;
                }
                catch (Exception e) {
                    log.error("Failed to migrate peer_connection_metrics_track record: {}", (Object)e.getMessage());
                }
            }
            if (!batch.isEmpty()) {
                this.service.getBaseMapper().insertOrUpdate(batch);
                count += (long)batch.size();
            }
        }
        log.info(TextManager.tlUI(Lang.DBNT_MIGRATOR_MIGRATING_COMPLETED, count, "peer_connection_metrics_track"));
        context.incrementTotalRecords(count);
        return count;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getTotalCount(Connection sqliteConnection) {
        try (Statement stmt = sqliteConnection.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT COUNT(*) FROM peer_connection_metrics_track");){
            if (!rs.next()) return 0L;
            long l = rs.getLong(1);
            return l;
        }
        catch (Exception e) {
            log.warn("Failed to get total count for peer_connection_metrics_track table", (Throwable)e);
        }
        return 0L;
    }
}

