/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.databasent.migration.migrators;

import com.ghostchu.peerbanhelper.databasent.migration.MigrationContext;
import com.ghostchu.peerbanhelper.databasent.migration.TableMigrator;
import com.ghostchu.peerbanhelper.databasent.service.TorrentService;
import com.ghostchu.peerbanhelper.databasent.table.TorrentEntity;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TorrentMigrator
implements TableMigrator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TorrentMigrator.class);
    private final TorrentService torrentService;

    public TorrentMigrator(TorrentService torrentService) {
        this.torrentService = torrentService;
    }

    @Override
    public String getTableName() {
        return "torrents";
    }

    @Override
    public int getMigrationOrder() {
        return 10;
    }

    @Override
    public boolean isTableAvailable(Connection sqliteConnection) throws Exception {
        String query = "SELECT name FROM sqlite_master WHERE type='table' AND name='torrents'";
        try (Statement stmt = sqliteConnection.createStatement();){
            boolean bl;
            block12: {
                ResultSet rs = stmt.executeQuery(query);
                try {
                    bl = rs.next();
                    if (rs == null) break block12;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return bl;
        }
    }

    @Override
    public long migrate(Connection sqliteConnection, MigrationContext context) throws Exception {
        String selectQuery = "SELECT id, infoHash, name, size, privateTorrent FROM torrents";
        long count = 0L;
        long totalCount = this.getTotalCount(sqliteConnection);
        long lastLogged = 0L;
        try (PreparedStatement ps = sqliteConnection.prepareStatement(selectQuery);
             ResultSet rs = ps.executeQuery();){
            ArrayList<TorrentEntity> batch = new ArrayList<TorrentEntity>();
            while (rs.next()) {
                long oldId = rs.getLong("id");
                String infoHash = rs.getString("infoHash");
                String name = rs.getString("name");
                long size = rs.getLong("size");
                Boolean privateTorrent = rs.getObject("privateTorrent") != null ? Boolean.valueOf(rs.getBoolean("privateTorrent")) : null;
                TorrentEntity entity = new TorrentEntity();
                entity.setId(oldId);
                entity.setInfoHash(infoHash);
                entity.setName(name);
                entity.setSize(size);
                entity.setPrivateTorrent(privateTorrent);
                batch.add(entity);
                if (batch.size() < context.getBatchSize()) continue;
                this.saveBatch(batch, context, oldId);
                batch.clear();
                if (!MigrationContext.shouldLogProgress(count += (long)batch.size(), totalCount, lastLogged)) continue;
                log.info(TextManager.tlUI(Lang.DBNT_MIGRATOR_MIGRATING_PROGRESS, count, totalCount, "torrent", MigrationContext.formatProgress(count, totalCount)));
                lastLogged = count;
            }
            if (!batch.isEmpty()) {
                this.saveBatch(batch, context, 0L);
                count += (long)batch.size();
            }
        }
        log.info(TextManager.tlUI(Lang.DBNT_MIGRATOR_MIGRATING_COMPLETED, count, "torrent"));
        context.incrementTotalRecords(count);
        return count;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getTotalCount(Connection sqliteConnection) {
        try (Statement stmt = sqliteConnection.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT COUNT(*) FROM torrents");){
            if (!rs.next()) return 0L;
            long l = rs.getLong(1);
            return l;
        }
        catch (Exception e) {
            log.warn("Failed to get total count for torrents table", (Throwable)e);
        }
        return 0L;
    }

    private void saveBatch(List<TorrentEntity> batch, MigrationContext context, long lastOldId) {
        this.torrentService.getBaseMapper().insertOrUpdate(batch);
    }
}

