/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.databasent.migration.migrators;

import com.ghostchu.peerbanhelper.databasent.migration.MigrationContext;
import com.ghostchu.peerbanhelper.databasent.migration.TableMigrator;
import com.ghostchu.peerbanhelper.databasent.service.TrafficJournalService;
import com.ghostchu.peerbanhelper.databasent.table.TrafficJournalEntity;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrafficJournalMigrator
implements TableMigrator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TrafficJournalMigrator.class);
    private final TrafficJournalService trafficJournalService;

    public TrafficJournalMigrator(TrafficJournalService trafficJournalService) {
        this.trafficJournalService = trafficJournalService;
    }

    @Override
    public String getTableName() {
        return "traffic_journal_v3";
    }

    @Override
    public int getMigrationOrder() {
        return 70;
    }

    @Override
    public boolean isTableAvailable(Connection sqliteConnection) throws Exception {
        String query = "SELECT name FROM sqlite_master WHERE type='table' AND name='traffic_journal_v3'";
        try (Statement stmt = sqliteConnection.createStatement();){
            boolean bl;
            block12: {
                ResultSet rs = stmt.executeQuery(query);
                try {
                    bl = rs.next();
                    if (rs == null) break block12;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return bl;
        }
    }

    @Override
    public long migrate(Connection sqliteConnection, MigrationContext context) throws Exception {
        String selectQuery = "SELECT timestamp, downloader, dataOverallUploadedAtStart, dataOverallUploaded,\n       dataOverallDownloadedAtStart, dataOverallDownloaded, protocolOverallUploadedAtStart,\n       protocolOverallUploaded, protocolOverallDownloadedAtStart, protocolOverallDownloaded\nFROM traffic_journal_v3\nORDER BY id\n";
        long count = 0L;
        long totalCount = this.getTotalCount(sqliteConnection);
        long lastLogged = 0L;
        try (PreparedStatement ps = sqliteConnection.prepareStatement(selectQuery);
             ResultSet rs = ps.executeQuery();){
            ArrayList<TrafficJournalEntity> batch = new ArrayList<TrafficJournalEntity>();
            while (rs.next()) {
                try {
                    TrafficJournalEntity entity = new TrafficJournalEntity();
                    long timestampMillis = rs.getLong("timestamp");
                    entity.setTimestamp(OffsetDateTime.ofInstant(Instant.ofEpochMilli(timestampMillis), ZoneId.systemDefault()));
                    entity.setDownloader(rs.getString("downloader"));
                    entity.setDataOverallUploadedAtStart(rs.getLong("dataOverallUploadedAtStart"));
                    entity.setDataOverallUploaded(rs.getLong("dataOverallUploaded"));
                    entity.setDataOverallDownloadedAtStart(rs.getLong("dataOverallDownloadedAtStart"));
                    entity.setDataOverallDownloaded(rs.getLong("dataOverallDownloaded"));
                    entity.setProtocolOverallUploadedAtStart(rs.getLong("protocolOverallUploadedAtStart"));
                    entity.setProtocolOverallUploaded(rs.getLong("protocolOverallUploaded"));
                    entity.setProtocolOverallDownloadedAtStart(rs.getLong("protocolOverallDownloadedAtStart"));
                    entity.setProtocolOverallDownloaded(rs.getLong("protocolOverallDownloaded"));
                    batch.add(entity);
                    if (batch.size() < context.getBatchSize()) continue;
                    this.trafficJournalService.getBaseMapper().insertOrUpdate(batch);
                    batch.clear();
                    if (!MigrationContext.shouldLogProgress(count += (long)batch.size(), totalCount, lastLogged)) continue;
                    log.info(TextManager.tlUI(Lang.DBNT_MIGRATOR_MIGRATING_PROGRESS, count, totalCount, "traffic_journal_v3", MigrationContext.formatProgress(count, totalCount)));
                    lastLogged = count;
                }
                catch (Exception e) {
                    log.error("Failed to migrate traffic_journal record: {}", (Object)e.getMessage());
                }
            }
            if (!batch.isEmpty()) {
                this.trafficJournalService.getBaseMapper().insertOrUpdate(batch);
                count += (long)batch.size();
            }
        }
        log.info(TextManager.tlUI(Lang.DBNT_MIGRATOR_MIGRATING_COMPLETED, count, "traffic_journal_v3"));
        context.incrementTotalRecords(count);
        return count;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getTotalCount(Connection sqliteConnection) {
        try (Statement stmt = sqliteConnection.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT COUNT(*) FROM traffic_journal_v3");){
            if (!rs.next()) return 0L;
            long l = rs.getLong(1);
            return l;
        }
        catch (Exception e) {
            log.warn("Failed to get total count for traffic_journal_v3 table", (Throwable)e);
        }
        return 0L;
    }
}

