/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.databasent.service.impl.common;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.ghostchu.peerbanhelper.databasent.mapper.java.AlertMapper;
import com.ghostchu.peerbanhelper.databasent.service.AlertService;
import com.ghostchu.peerbanhelper.databasent.service.impl.common.AbstractCommonService;
import com.ghostchu.peerbanhelper.databasent.table.AlertEntity;
import java.time.OffsetDateTime;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class AlertServiceImpl
extends AbstractCommonService<AlertMapper, AlertEntity>
implements AlertService {
    @Autowired
    private TransactionTemplate transactionTemplate;

    @Override
    @NotNull
    public List<AlertEntity> getUnreadAlerts() {
        return ((AlertMapper)this.baseMapper).selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().isNull(AlertEntity::getReadAt)).orderByDesc(AlertEntity::getCreateAt));
    }

    @Override
    public boolean identifierAlertExists(@NotNull String identifier) {
        return ((AlertMapper)this.baseMapper).exists((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(AlertEntity::getIdentifier, (Object)identifier)).isNull(AlertEntity::getReadAt));
    }

    @Override
    public boolean identifierAlertExistsIncludeRead(@NotNull String identifier) {
        return ((AlertMapper)this.baseMapper).exists((Wrapper)new LambdaQueryWrapper().eq(AlertEntity::getIdentifier, (Object)identifier));
    }

    @Override
    public long deleteOldAlerts(@NotNull OffsetDateTime before) {
        return this.splitBatchDelete((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{AlertEntity::getId}).le(AlertEntity::getCreateAt, (Object)before));
    }

    @Override
    public void markAllAsRead() {
        ((AlertMapper)this.baseMapper).markAllAsRead(OffsetDateTime.now());
    }

    @Override
    public void markAsRead(@NotNull String identifier) {
        ((AlertMapper)this.baseMapper).markAsRead(identifier, OffsetDateTime.now());
    }
}

