/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.databasent.service.impl.common;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ghostchu.peerbanhelper.databasent.dto.PeerBanCount;
import com.ghostchu.peerbanhelper.databasent.dto.TorrentCount;
import com.ghostchu.peerbanhelper.databasent.dto.UniversalFieldNumResult;
import com.ghostchu.peerbanhelper.databasent.mapper.java.HistoryMapper;
import com.ghostchu.peerbanhelper.databasent.service.HistoryService;
import com.ghostchu.peerbanhelper.databasent.service.impl.common.AbstractCommonService;
import com.ghostchu.peerbanhelper.databasent.table.HistoryEntity;
import com.ghostchu.peerbanhelper.util.query.Orderable;
import java.net.InetAddress;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class HistoryServiceImpl
extends AbstractCommonService<HistoryMapper, HistoryEntity>
implements HistoryService {
    @Autowired
    private TransactionTemplate transactionTemplate;

    @Override
    public IPage<PeerBanCount> getBannedIps(@NotNull Page<PeerBanCount> page, @Nullable String filter) {
        if (filter != null && !filter.isEmpty()) {
            return ((HistoryMapper)this.baseMapper).getBannedIpsWithFilter((IPage<PeerBanCount>)page, filter);
        }
        return ((HistoryMapper)this.baseMapper).getBannedIpsWithoutFilter((IPage<PeerBanCount>)page);
    }

    @Override
    public long countHistoriesByTorrentId(@NotNull Long id) {
        return ((HistoryMapper)this.baseMapper).selectCount((Wrapper)new LambdaQueryWrapper().eq(HistoryEntity::getTorrentId, (Object)id));
    }

    @Override
    public long countHistoriesByIp(@NotNull InetAddress inetAddress) {
        return ((HistoryMapper)this.baseMapper).selectCount((Wrapper)new LambdaQueryWrapper().eq(HistoryEntity::getIp, (Object)inetAddress));
    }

    @Override
    public IPage<HistoryEntity> queryBanHistoryByIp(@NotNull Page<HistoryEntity> pageable, @NotNull InetAddress ip, @NotNull Orderable orderBy) {
        return ((HistoryMapper)this.baseMapper).selectPage((IPage)pageable, (Wrapper)orderBy.apply((QueryWrapper)new QueryWrapper().eq((Object)"ip", (Object)ip)));
    }

    @Override
    public IPage<HistoryEntity> queryBanHistoryByTorrentId(@NotNull Page<HistoryEntity> pageable, @NotNull Long torrentId, @NotNull Orderable orderBy) {
        return ((HistoryMapper)this.baseMapper).selectPage((IPage)pageable, (Wrapper)orderBy.apply((QueryWrapper)new QueryWrapper().eq((Object)"torrent_id", (Object)torrentId)));
    }

    @Override
    public long deleteExpiredLogs(int keepDays) {
        OffsetDateTime thresholdDate = OffsetDateTime.now().minusDays(keepDays);
        return this.splitBatchDelete((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{HistoryEntity::getId}).le(HistoryEntity::getBanAt, (Object)thresholdDate));
    }

    @Override
    public List<UniversalFieldNumResult> countField(@NotNull String field, double percentFilter, @Nullable String downloader, @Nullable Integer substringLength) {
        String mappedField = this.mapField(field);
        return ((HistoryMapper)this.baseMapper).countField(mappedField, percentFilter, downloader, substringLength);
    }

    @Override
    public List<UniversalFieldNumResult> sumField(@NotNull String field, double percentFilter, @Nullable String downloader, @Nullable Integer substringLength) {
        String mappedField = this.mapField(field);
        return ((HistoryMapper)this.baseMapper).sumField(mappedField, percentFilter, downloader, substringLength);
    }

    private String mapField(String field) {
        return switch (field = field.replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase()) {
            case "torrent_name" -> "t.name";
            case "module" -> "module_name";
            case "module_name" -> "h.module_name";
            case "client_name", "peer_client_name" -> "h.peer_client_name";
            case "peer_ip", "ip" -> "h.ip";
            case "port" -> "h.port";
            case "peer_id" -> "h.peer_id";
            case "peer_uploaded" -> "h.peer_uploaded";
            case "peer_downloaded" -> "h.peer_downloaded";
            case "peer_progress" -> "h.peer_progress";
            case "time" -> "h.ban_at";
            default -> field;
        };
    }

    @Override
    public IPage<HistoryEntity> getBanLogs(Page<HistoryEntity> pageRequest, Orderable orderable) {
        return ((HistoryMapper)this.baseMapper).selectPage((IPage)pageRequest, (Wrapper)orderable.apply(new QueryWrapper()));
    }

    @Override
    public Map<Long, Long> countByTorrentIds(@NotNull List<Long> torrentIds) {
        if (torrentIds.isEmpty()) {
            return Collections.emptyMap();
        }
        List<TorrentCount> counts = ((HistoryMapper)this.baseMapper).countByTorrentIds(torrentIds);
        return counts.stream().collect(Collectors.toMap(TorrentCount::getTorrentId, TorrentCount::getCount));
    }

    @Override
    public List<String> getDistinctIps(@NotNull OffsetDateTime start, @NotNull OffsetDateTime end, @Nullable String downloader) {
        return ((HistoryMapper)this.baseMapper).getDistinctIps(start, end, downloader);
    }
}

