/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.databasent.service.impl.common;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ghostchu.peerbanhelper.bittorrent.peer.PeerFlag;
import com.ghostchu.peerbanhelper.databasent.mapper.java.PeerConnectionMetricsMapper;
import com.ghostchu.peerbanhelper.databasent.service.PeerConnectionMetricsService;
import com.ghostchu.peerbanhelper.databasent.service.impl.common.AbstractCommonService;
import com.ghostchu.peerbanhelper.databasent.table.PeerConnectionMetricsEntity;
import com.ghostchu.peerbanhelper.databasent.table.PeerConnectionMetricsTrackEntity;
import com.ghostchu.peerbanhelper.module.impl.webapi.dto.PeerConnectionMetricsDTO;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import io.sentry.Sentry;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class PeerConnectionMetricsServiceImpl
extends AbstractCommonService<PeerConnectionMetricsMapper, PeerConnectionMetricsEntity>
implements PeerConnectionMetricsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PeerConnectionMetricsServiceImpl.class);
    @Autowired
    private TransactionTemplate transactionTemplate;

    @Override
    public long getGlobalTotalConnectionsCount(@NotNull OffsetDateTime startAt, @NotNull OffsetDateTime endAt) {
        long total = 0L;
        try {
            List entities = ((PeerConnectionMetricsMapper)this.baseMapper).selectList((Wrapper)new LambdaQueryWrapper().between(PeerConnectionMetricsEntity::getTimeframeAt, (Object)startAt, (Object)endAt));
            for (PeerConnectionMetricsEntity entity : entities) {
                total += entity.getTotalConnections();
            }
        }
        catch (Exception e) {
            log.error("Failed to query global total connections count between {} and {}", new Object[]{startAt, endAt, e});
            Sentry.captureException((Throwable)e);
        }
        return total;
    }

    @Override
    public List<PeerConnectionMetricsDTO> getMetricsSince(@NotNull OffsetDateTime sinceAt, @NotNull OffsetDateTime untilAt, @Nullable String downloader) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().between(PeerConnectionMetricsEntity::getTimeframeAt, (Object)sinceAt, (Object)untilAt);
        if (downloader != null && !downloader.isBlank()) {
            wrapper.eq(PeerConnectionMetricsEntity::getDownloader, (Object)downloader);
        }
        List entities = ((PeerConnectionMetricsMapper)this.baseMapper).selectList((Wrapper)wrapper);
        HashMap<Timestamp, PeerConnectionMetricsDTO> mergedMap = new HashMap<Timestamp, PeerConnectionMetricsDTO>();
        for (PeerConnectionMetricsEntity entity : entities) {
            Timestamp timeframe = Timestamp.from(entity.getTimeframeAt().toInstant());
            PeerConnectionMetricsDTO dto = PeerConnectionMetricsDTO.from(entity);
            if (mergedMap.containsKey(timeframe)) {
                PeerConnectionMetricsDTO existing = (PeerConnectionMetricsDTO)mergedMap.get(timeframe);
                this.mergeMetricsDTO(existing, dto);
                continue;
            }
            mergedMap.put(timeframe, dto);
        }
        ArrayList<PeerConnectionMetricsDTO> result = new ArrayList<PeerConnectionMetricsDTO>(mergedMap.values());
        result.sort((a, b) -> Long.compare(b.getKey(), a.getKey()));
        return result;
    }

    @Override
    public void saveAggregating(@NotNull List<PeerConnectionMetricsEntity> buffer, boolean overwrite) {
        for (PeerConnectionMetricsEntity peerConnectionMetricsEntity : buffer) {
            PeerConnectionMetricsEntity entityInDb = (PeerConnectionMetricsEntity)((PeerConnectionMetricsMapper)this.baseMapper).selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PeerConnectionMetricsEntity::getTimeframeAt, (Object)peerConnectionMetricsEntity.getTimeframeAt())).eq(PeerConnectionMetricsEntity::getDownloader, (Object)peerConnectionMetricsEntity.getDownloader()));
            if (entityInDb != null) {
                if (overwrite) {
                    peerConnectionMetricsEntity.setId(entityInDb.getId());
                } else {
                    entityInDb.merge(peerConnectionMetricsEntity);
                }
            } else {
                entityInDb = peerConnectionMetricsEntity;
            }
            ((PeerConnectionMetricsMapper)this.baseMapper).insertOrUpdate(entityInDb);
        }
    }

    @Override
    public List<PeerConnectionMetricsEntity> aggregating(@NotNull List<PeerConnectionMetricsTrackEntity> fullPeerSessions) {
        ArrayList<PeerConnectionMetricsEntity> buffer = new ArrayList<PeerConnectionMetricsEntity>();
        for (PeerConnectionMetricsTrackEntity peerSessionEntity : fullPeerSessions) {
            PeerConnectionMetricsEntity entity = this.findOrCreateBuffer(buffer, peerSessionEntity.getTimeframeAt(), peerSessionEntity.getDownloader());
            entity.setTotalConnections(entity.getTotalConnections() + 1L);
            String flags = peerSessionEntity.getLastFlags();
            if (flags == null) continue;
            PeerFlag f = new PeerFlag(flags);
            if (!f.isLocalConnection()) {
                entity.setIncomingConnections(entity.getIncomingConnections() + 1L);
            }
            if (f.isInteresting() && f.isRemoteChoked()) {
                entity.setRemoteRefuseTransferToClient(entity.getRemoteRefuseTransferToClient() + 1L);
            }
            if (f.isInteresting() && !f.isRemoteChoked()) {
                entity.setRemoteAcceptTransferToClient(entity.getRemoteAcceptTransferToClient() + 1L);
            }
            if (f.isRemoteInterested() && f.isChoked()) {
                entity.setLocalRefuseTransferToPeer(entity.getLocalRefuseTransferToPeer() + 1L);
            }
            if (f.isRemoteInterested() && !f.isChoked()) {
                entity.setLocalAcceptTransferToPeer(entity.getLocalAcceptTransferToPeer() + 1L);
            }
            if (!f.isRemoteChoked() && !f.isInteresting()) {
                entity.setLocalNotInterested(entity.getLocalNotInterested() + 1L);
            }
            if (!f.isChoked() && !f.isRemoteInterested()) {
                entity.setQuestionStatus(entity.getQuestionStatus() + 1L);
            }
            if (f.isOptimisticUnchoke()) {
                entity.setOptimisticUnchoke(entity.getOptimisticUnchoke() + 1L);
            }
            if (f.isFromDHT()) {
                entity.setFromDHT(entity.getFromDHT() + 1L);
            } else if (f.isFromPEX()) {
                entity.setFromPEX(entity.getFromPEX() + 1L);
            } else if (f.isFromLSD()) {
                entity.setFromLSD(entity.getFromLSD() + 1L);
            } else {
                entity.setFromTrackerOrOther(entity.getFromTrackerOrOther() + 1L);
            }
            if (f.isRc4Encrypted()) {
                entity.setRc4Encrypted(entity.getRc4Encrypted() + 1L);
            }
            if (f.isPlainTextEncrypted()) {
                entity.setPlainTextEncrypted(entity.getPlainTextEncrypted() + 1L);
            }
            if (f.isUtpSocket()) {
                entity.setUtpSocket(entity.getUtpSocket() + 1L);
                continue;
            }
            entity.setTcpSocket(entity.getTcpSocket() + 1L);
        }
        return buffer;
    }

    @Override
    public void removeOutdatedData(OffsetDateTime beforeAt) {
        Integer changes;
        log.info(TextManager.tlUI(Lang.CONNECTION_METRICS_SERVICE_CLEANING_UP, new Object[0]));
        long deleted = 0L;
        while ((changes = (Integer)this.transactionTemplate.execute(status -> ((PeerConnectionMetricsMapper)this.baseMapper).delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().le(PeerConnectionMetricsEntity::getTimeframeAt, (Object)beforeAt)).last("LIMIT 300")))) != null && changes > 0) {
            deleted += (long)changes.intValue();
        }
        log.info(TextManager.tlUI(Lang.CONNECTION_METRICS_SERVICE_CLEANED_UP, deleted));
    }

    private void mergeMetricsDTO(PeerConnectionMetricsDTO target, PeerConnectionMetricsDTO source) {
        target.setTotalConnections(target.getTotalConnections() + source.getTotalConnections());
        target.setIncomingConnections(target.getIncomingConnections() + source.getIncomingConnections());
        target.setRemoteRefuseTransferToClient(target.getRemoteRefuseTransferToClient() + source.getRemoteRefuseTransferToClient());
        target.setRemoteAcceptTransferToClient(target.getRemoteAcceptTransferToClient() + source.getRemoteAcceptTransferToClient());
        target.setLocalRefuseTransferToPeer(target.getLocalRefuseTransferToPeer() + source.getLocalRefuseTransferToPeer());
        target.setLocalAcceptTransferToPeer(target.getLocalAcceptTransferToPeer() + source.getLocalAcceptTransferToPeer());
        target.setLocalNotInterested(target.getLocalNotInterested() + source.getLocalNotInterested());
        target.setQuestionStatus(target.getQuestionStatus() + source.getQuestionStatus());
        target.setOptimisticUnchoke(target.getOptimisticUnchoke() + source.getOptimisticUnchoke());
        target.setFromDHT(target.getFromDHT() + source.getFromDHT());
        target.setFromPEX(target.getFromPEX() + source.getFromPEX());
        target.setFromLSD(target.getFromLSD() + source.getFromLSD());
        target.setFromTrackerOrOther(target.getFromTrackerOrOther() + source.getFromTrackerOrOther());
        target.setRc4Encrypted(target.getRc4Encrypted() + source.getRc4Encrypted());
        target.setPlainTextEncrypted(target.getPlainTextEncrypted() + source.getPlainTextEncrypted());
        target.setUtpSocket(target.getUtpSocket() + source.getUtpSocket());
        target.setTcpSocket(target.getTcpSocket() + source.getTcpSocket());
    }

    @NotNull
    private PeerConnectionMetricsEntity findOrCreateBuffer(List<PeerConnectionMetricsEntity> buffer, OffsetDateTime timestamp, String downloader) {
        for (PeerConnectionMetricsEntity peerConnectionMetricsEntity : buffer) {
            if (!peerConnectionMetricsEntity.getTimeframeAt().equals(timestamp) || !peerConnectionMetricsEntity.getDownloader().equals(downloader)) continue;
            return peerConnectionMetricsEntity;
        }
        PeerConnectionMetricsEntity entity = new PeerConnectionMetricsEntity();
        entity.setTimeframeAt(OffsetDateTime.ofInstant(timestamp.toInstant(), ZoneId.systemDefault()));
        entity.setDownloader(downloader);
        buffer.add(entity);
        return entity;
    }
}

