/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.databasent.service.impl.common;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ghostchu.peerbanhelper.databasent.mapper.java.TorrentMapper;
import com.ghostchu.peerbanhelper.databasent.service.TorrentService;
import com.ghostchu.peerbanhelper.databasent.service.impl.common.AbstractCommonService;
import com.ghostchu.peerbanhelper.databasent.table.TorrentEntity;
import com.ghostchu.peerbanhelper.util.query.Orderable;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TorrentServiceImpl
extends AbstractCommonService<TorrentMapper, TorrentEntity>
implements TorrentService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TorrentServiceImpl.class);
    private final Cache<@NotNull String, @NotNull TorrentEntity> instanceCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).maximumSize(1000L).softValues().build();

    @Override
    @NotNull
    public TorrentEntity createIfNotExists(@NotNull TorrentEntity torrent) {
        TorrentEntity existing = this.queryByInfoHash(torrent.getInfoHash());
        if (existing != null) {
            boolean incomingIsPoor;
            boolean existingIsComplete = existing.getSize() != null && existing.getSize() > 0L && existing.getPrivateTorrent() != null;
            boolean bl = incomingIsPoor = (torrent.getSize() == null || torrent.getSize() <= 0L) && torrent.getPrivateTorrent() == null;
            if (existingIsComplete || incomingIsPoor) {
                return existing;
            }
        }
        ((TorrentMapper)this.baseMapper).upsert(torrent);
        this.instanceCache.invalidate((Object)torrent.getInfoHash());
        TorrentEntity torrentEntity = this.queryByInfoHash(torrent.getInfoHash());
        if (torrentEntity == null) {
            throw new IllegalStateException("Failed to retrieve torrent after upsert: " + torrent.getInfoHash());
        }
        return torrentEntity;
    }

    @Override
    @Nullable
    public TorrentEntity queryByInfoHash(@NotNull String infoHash) {
        TorrentEntity cached = (TorrentEntity)this.instanceCache.getIfPresent((Object)infoHash);
        if (cached != null && cached.getId() != null) {
            return cached;
        }
        TorrentEntity entity = (TorrentEntity)((TorrentMapper)this.baseMapper).selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TorrentEntity::getInfoHash, (Object)infoHash)).last("limit 1"));
        if (entity != null) {
            this.instanceCache.put((Object)infoHash, (Object)entity);
        }
        return entity;
    }

    @Override
    public IPage<TorrentEntity> search(Page<TorrentEntity> page, String keyword, Orderable normalSort, String statsSortField, boolean statsSortAsc) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (keyword != null) {
            queryWrapper.and(q -> ((QueryWrapper)((QueryWrapper)q.like((Object)"name", (Object)keyword)).or()).like((Object)"info_hash", (Object)keyword));
        }
        if (statsSortField != null) {
            String subQueryTable = "peerBanCount".equals(statsSortField) ? "history" : "peer_records";
            String sortDirection = statsSortAsc ? "ASC" : "DESC";
            queryWrapper.last("ORDER BY (SELECT COUNT(*) FROM " + subQueryTable + " WHERE " + subQueryTable + ".torrent_id = torrents.id) " + sortDirection + ", id DESC");
        } else if (normalSort != null) {
            normalSort.apply(queryWrapper);
        }
        return ((TorrentMapper)this.baseMapper).selectPage((IPage)page, (Wrapper)queryWrapper);
    }
}

