/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.downloader.impl.qbittorrent.impl.enhanced;

import com.ghostchu.peerbanhelper.alert.AlertManager;
import com.ghostchu.peerbanhelper.bittorrent.peer.Peer;
import com.ghostchu.peerbanhelper.bittorrent.torrent.Torrent;
import com.ghostchu.peerbanhelper.downloader.DownloaderLoginResult;
import com.ghostchu.peerbanhelper.downloader.impl.qbittorrent.AbstractQbittorrent;
import com.ghostchu.peerbanhelper.downloader.impl.qbittorrent.impl.QBittorrentPreferences;
import com.ghostchu.peerbanhelper.downloader.impl.qbittorrent.impl.enhanced.QBittorrentEEConfigImpl;
import com.ghostchu.peerbanhelper.downloader.impl.qbittorrent.impl.enhanced.QBittorrentEEPeer;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.util.HTTPUtil;
import com.ghostchu.peerbanhelper.util.json.JsonUtil;
import com.ghostchu.peerbanhelper.util.traversal.NatAddressProvider;
import com.ghostchu.peerbanhelper.wrapper.BanMetadata;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import inet.ipaddr.Address;
import inet.ipaddr.IPAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import lombok.Generated;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.bspfsystems.yamlconfiguration.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QBittorrentEE
extends AbstractQbittorrent {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QBittorrentEE.class);
    private final BanHandler banHandler;

    public QBittorrentEE(String id, QBittorrentEEConfigImpl config, AlertManager alertManager, HTTPUtil httpUtil, NatAddressProvider natAddressProvider) {
        super(id, config, alertManager, httpUtil, natAddressProvider);
        this.banHandler = config.isUseShadowBan() ? new BanHandlerShadowBan(this.httpClient, config.getName(), this.apiEndpoint) : new BanHandlerNormal(this);
    }

    @Override
    public boolean isPaused() {
        return this.config.isPaused();
    }

    @Override
    public synchronized void setPaused(boolean paused) {
        super.setPaused(paused);
        if (this.config != null) {
            this.config.setPaused(paused);
        }
    }

    public static QBittorrentEE loadFromConfig(String id, JsonObject section, AlertManager alertManager, HTTPUtil httpUtil, NatAddressProvider natAddressProvider) {
        QBittorrentEEConfigImpl config = (QBittorrentEEConfigImpl)JsonUtil.getGson().fromJson(section.toString(), QBittorrentEEConfigImpl.class);
        return new QBittorrentEE(id, config, alertManager, httpUtil, natAddressProvider);
    }

    public static QBittorrentEE loadFromConfig(String id, ConfigurationSection section, AlertManager alertManager, HTTPUtil httpUtil, NatAddressProvider natAddressProvider) {
        QBittorrentEEConfigImpl config = QBittorrentEEConfigImpl.readFromYaml(section, id);
        return new QBittorrentEE(id, config, alertManager, httpUtil, natAddressProvider);
    }

    @Override
    public DownloaderLoginResult login0() {
        DownloaderLoginResult result = super.login0();
        if (result.success()) {
            try {
                if (this.config.isUseShadowBan() && !this.banHandler.test()) {
                    return new DownloaderLoginResult(DownloaderLoginResult.Status.REQUIRE_TAKE_ACTIONS, new TranslationComponent(Lang.DOWNLOADER_QBITTORRENTEE_SHADOWBANAPI_TEST_FAILURE));
                }
            }
            catch (Exception e) {
                return new DownloaderLoginResult(DownloaderLoginResult.Status.EXCEPTION, new TranslationComponent(Lang.DOWNLOADER_LOGIN_IO_EXCEPTION, e.getClass().getName() + ": " + e.getMessage()));
            }
        }
        return result;
    }

    @Override
    @NotNull
    public String getType() {
        return "qBittorrentEE";
    }

    @Override
    public void setBanList(@NotNull Collection<IPAddress> fullList, @Nullable Collection<BanMetadata> added, @Nullable Collection<BanMetadata> removed, boolean applyFullList) {
        if (removed != null && removed.isEmpty() && added != null && this.config.isIncrementBan() && !applyFullList) {
            this.banHandler.setBanListIncrement(added);
        } else {
            this.banHandler.setBanListFull(fullList);
        }
    }

    @Override
    @NotNull
    public List<Peer> getPeers(@NotNull Torrent torrent) {
        ArrayList<QBittorrentEEPeer> arrayList;
        block12: {
            Request request = new Request.Builder().url(this.apiEndpoint + "/sync/torrentPeers?hash=" + torrent.getId()).get().build();
            Response response = this.httpClient.newCall(request).execute();
            try {
                if (!response.isSuccessful()) {
                    throw new IllegalStateException(TextManager.tlUI(Lang.DOWNLOADER_QB_FAILED_REQUEST_PEERS_LIST_IN_TORRENT, response.code(), response.body() != null ? response.body().string() : "null"));
                }
                String responseBody = response.body().string();
                JsonObject object = JsonParser.parseString((String)responseBody).getAsJsonObject();
                JsonObject peers = object.getAsJsonObject("peers");
                ArrayList<QBittorrentEEPeer> peersList = new ArrayList<QBittorrentEEPeer>();
                for (String s : peers.keySet()) {
                    JsonObject singlePeerObject = peers.getAsJsonObject(s);
                    QBittorrentEEPeer qbPeer = (QBittorrentEEPeer)JsonUtil.getGson().fromJson(singlePeerObject.toString(), QBittorrentEEPeer.class);
                    if (qbPeer.getPeerAddress().getIp() == null || qbPeer.getPeerAddress().getIp().isBlank() || "HTTP".equalsIgnoreCase(qbPeer.getConnection()) || "HTTPS".equalsIgnoreCase(qbPeer.getConnection()) || "Web".equalsIgnoreCase(qbPeer.getConnection()) || s.contains(".onion") || s.contains(".i2p") || qbPeer.getShadowBanned() != null && qbPeer.getShadowBanned().booleanValue()) continue;
                    if (qbPeer.getPeerId() == null || "Unknown".equals(qbPeer.getPeerId()) || "\u672a\u77e5".equals(qbPeer.getPeerId())) {
                        qbPeer.setPeerIdClient("");
                    }
                    if (qbPeer.getClientName() != null && qbPeer.getClientName().startsWith("Unknown [") && qbPeer.getClientName().endsWith("]")) {
                        String mid = qbPeer.getClientName().substring("Unknown [".length(), qbPeer.getClientName().length() - 1);
                        qbPeer.setClient(mid);
                    }
                    qbPeer.getPeerAddress().setRawIp(s);
                    qbPeer.setPeerAddress(this.natTranslate(qbPeer.getPeerAddress()));
                    peersList.add(qbPeer);
                }
                arrayList = peersList;
                if (response == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            response.close();
        }
        return arrayList;
    }

    public static class BanHandlerShadowBan
    implements BanHandler {
        private final OkHttpClient httpClient;
        private final String name;
        private final String apiEndpoint;
        private Boolean shadowBanEnabled = false;

        public BanHandlerShadowBan(OkHttpClient httpClient, String name, String apiEndpoint) {
            this.httpClient = httpClient;
            this.name = name;
            this.apiEndpoint = apiEndpoint;
        }

        @Override
        public boolean test() {
            boolean bl;
            block10: {
                if (this.shadowBanEnabled.booleanValue()) {
                    return true;
                }
                Request request = new Request.Builder().url(this.apiEndpoint + "/app/preferences").get().build();
                Response response = this.httpClient.newCall(request).execute();
                try {
                    if (!response.isSuccessful()) {
                        throw new IllegalStateException("Failed to get preferences: " + response.code());
                    }
                    String responseBody = response.body().string();
                    QBittorrentPreferences preferences = (QBittorrentPreferences)JsonUtil.getGson().fromJson(responseBody, QBittorrentPreferences.class);
                    this.shadowBanEnabled = preferences.getShadowBanEnabled() != null && preferences.getShadowBanEnabled() != false;
                    bl = this.shadowBanEnabled;
                    if (response == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (response != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e);
                    }
                }
                response.close();
            }
            return bl;
        }

        @Override
        public void setBanListIncrement(Collection<BanMetadata> added) {
            HashMap<String, StringJoiner> banTasks = new HashMap<String, StringJoiner>();
            added.forEach(p -> {
                StringJoiner joiner = banTasks.getOrDefault(p.getTorrent().getHash(), new StringJoiner("|"));
                joiner.add(p.getPeer().getRawIp());
                banTasks.put(p.getTorrent().getHash(), joiner);
            });
            banTasks.forEach((hash, peers) -> {
                FormBody formBody = new FormBody.Builder().add("hash", hash).add("peers", peers.toString()).build();
                try {
                    Request request = new Request.Builder().url(this.apiEndpoint + "/transfer/shadowbanPeers").post((RequestBody)formBody).header("Content-Type", "application/x-www-form-urlencoded").build();
                    try (Response response = this.httpClient.newCall(request).execute();){
                        if (!response.isSuccessful()) {
                            log.error(TextManager.tlUI(Lang.DOWNLOADER_QB_INCREAMENT_BAN_FAILED, this.name, this.apiEndpoint, response.code(), "HTTP ERROR", response.body() != null ? response.body().string() : "null"));
                            throw new IllegalStateException("Save qBittorrent shadow banlist error: statusCode=" + response.code());
                        }
                    }
                }
                catch (Exception e) {
                    log.error(TextManager.tlUI(Lang.DOWNLOADER_QB_INCREAMENT_BAN_FAILED, this.name, this.apiEndpoint, "N/A", e.getClass().getName(), e.getMessage()), (Throwable)e);
                    throw new IllegalStateException(e);
                }
            });
        }

        @Override
        public void setBanListFull(Collection<IPAddress> peerAddresses) {
            StringJoiner joiner = new StringJoiner("\n");
            peerAddresses.stream().map(Address::toNormalizedString).distinct().forEach(joiner::add);
            FormBody formBody = new FormBody.Builder().add("json", JsonUtil.getGson().toJson(Map.of("shadow_banned_IPs", joiner.toString()))).build();
            try {
                Request request = new Request.Builder().url(this.apiEndpoint + "/app/setPreferences").post((RequestBody)formBody).header("Content-Type", "application/x-www-form-urlencoded").build();
                try (Response response = this.httpClient.newCall(request).execute();){
                    if (!response.isSuccessful()) {
                        log.error(TextManager.tlUI(Lang.DOWNLOADER_QB_FAILED_SAVE_BANLIST, this.name, this.apiEndpoint, response.code(), "HTTP ERROR", response.body() != null ? response.body().string() : "null"));
                        throw new IllegalStateException("Save qBittorrent shadow banlist error: statusCode=" + response.code());
                    }
                }
            }
            catch (Exception e) {
                log.error(TextManager.tlUI(Lang.DOWNLOADER_QB_FAILED_SAVE_BANLIST, this.name, this.apiEndpoint, "N/A", e.getClass().getName(), e.getMessage()), (Throwable)e);
                throw new IllegalStateException(e);
            }
        }
    }

    static interface BanHandler {
        public boolean test();

        public void setBanListIncrement(Collection<BanMetadata> var1);

        public void setBanListFull(Collection<IPAddress> var1);
    }

    public static class BanHandlerNormal
    implements BanHandler {
        private final QBittorrentEE downloader;

        public BanHandlerNormal(QBittorrentEE downloader) {
            this.downloader = downloader;
        }

        @Override
        public boolean test() {
            return true;
        }

        @Override
        public void setBanListIncrement(Collection<BanMetadata> added) {
            this.downloader.setBanListIncrement(added);
        }

        @Override
        public void setBanListFull(Collection<IPAddress> peerAddresses) {
            this.downloader.setBanListFull(peerAddresses);
        }
    }
}

