/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.downloader.impl.transmission;

import com.ghostchu.peerbanhelper.alert.AlertLevel;
import com.ghostchu.peerbanhelper.alert.AlertManager;
import com.ghostchu.peerbanhelper.bittorrent.peer.Peer;
import com.ghostchu.peerbanhelper.bittorrent.torrent.Torrent;
import com.ghostchu.peerbanhelper.bittorrent.tracker.Tracker;
import com.ghostchu.peerbanhelper.downloader.AbstractDownloader;
import com.ghostchu.peerbanhelper.downloader.DownloaderFeatureFlag;
import com.ghostchu.peerbanhelper.downloader.DownloaderLoginResult;
import com.ghostchu.peerbanhelper.downloader.DownloaderSpeedLimiter;
import com.ghostchu.peerbanhelper.downloader.DownloaderStatistics;
import com.ghostchu.peerbanhelper.downloader.impl.transmission.TRTorrent;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.util.HTTPUtil;
import com.ghostchu.peerbanhelper.util.json.JsonUtil;
import com.ghostchu.peerbanhelper.util.traversal.NatAddressProvider;
import com.ghostchu.peerbanhelper.wrapper.BanMetadata;
import com.google.gson.JsonObject;
import com.vdurmont.semver4j.Semver;
import cordelia.client.TrClient;
import cordelia.client.TypedResponse;
import cordelia.rpc.RqBlockList;
import cordelia.rpc.RqSessionGet;
import cordelia.rpc.RqSessionSet;
import cordelia.rpc.RqSessionStats;
import cordelia.rpc.RqTorrentGet;
import cordelia.rpc.RqTorrentSet;
import cordelia.rpc.RsBlockList;
import cordelia.rpc.RsSessionGet;
import cordelia.rpc.RsSessionStats;
import cordelia.rpc.RsTorrentGet;
import cordelia.rpc.types.Torrents;
import inet.ipaddr.IPAddress;
import java.util.Collection;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bspfsystems.yamlconfiguration.configuration.ConfigurationSection;
import org.bspfsystems.yamlconfiguration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Transmission
extends AbstractDownloader {
    private static final Logger log = LoggerFactory.getLogger(Transmission.class);
    private final TrClient client;
    private final String blocklistUrl;
    private final Config config;

    public Transmission(String id, String blocklistUrl, Config config, AlertManager alertManager, HTTPUtil httpUtil, NatAddressProvider natAddressProvider) {
        super(id, alertManager, natAddressProvider);
        this.config = config;
        this.client = new TrClient(httpUtil, config.getEndpoint() + config.getRpcUrl(), config.getUsername(), config.getPassword(), config.isVerifySsl());
        this.blocklistUrl = blocklistUrl;
    }

    @Override
    @NotNull
    public String getName() {
        return this.config.getName();
    }

    private static String generateBlocklistUrl(String pbhServerAddress) {
        return pbhServerAddress + "/blocklist/p2p-plain-format";
    }

    public static Transmission loadFromConfig(String id, String pbhServerAddress, ConfigurationSection section, AlertManager alertManager, HTTPUtil httpUtil, NatAddressProvider natAddressProvider) {
        Config config = Config.readFromYaml(section, id);
        return new Transmission(id, Transmission.generateBlocklistUrl(pbhServerAddress), config, alertManager, httpUtil, natAddressProvider);
    }

    public static Transmission loadFromConfig(String id, String pbhServerAddress, JsonObject section, AlertManager alertManager, HTTPUtil httpUtil, NatAddressProvider natAddressProvider) {
        Config config = (Config)JsonUtil.getGson().fromJson(section.toString(), Config.class);
        return new Transmission(id, Transmission.generateBlocklistUrl(pbhServerAddress), config, alertManager, httpUtil, natAddressProvider);
    }

    @Override
    @NotNull
    public JsonObject saveDownloaderJson() {
        return JsonUtil.getGson().toJsonTree((Object)this.config).getAsJsonObject();
    }

    @Override
    @NotNull
    public YamlConfiguration saveDownloader() {
        return this.config.saveToYaml();
    }

    @Override
    @NotNull
    public String getEndpoint() {
        return this.config.getEndpoint();
    }

    @Override
    @NotNull
    public String getType() {
        return "Transmission";
    }

    @Override
    public boolean isPaused() {
        return this.config.isPaused();
    }

    @Override
    @NotNull
    public List<DownloaderFeatureFlag> getFeatureFlags() {
        return List.of(DownloaderFeatureFlag.UNBAN_IP, DownloaderFeatureFlag.TRAFFIC_STATS, DownloaderFeatureFlag.LIVE_UPDATE_BT_PROTOCOL_PORT);
    }

    @Override
    public void setPaused(boolean paused) {
        super.setPaused(paused);
        this.config.setPaused(paused);
    }

    @Override
    public DownloaderLoginResult login0() {
        Semver semver;
        RqSessionGet get = new RqSessionGet();
        TypedResponse resp = this.client.execute(get);
        String version = ((RsSessionGet)resp.getArgs()).getVersion();
        if (version.length() > 5) {
            version = version.substring(0, 5);
        }
        if ((semver = new Semver(version, Semver.SemverType.LOOSE)).getMajor() < 4) {
            return new DownloaderLoginResult(DownloaderLoginResult.Status.EXCEPTION, new TranslationComponent(Lang.DOWNLOADER_TR_KNOWN_INCOMPATIBILITY, "Transmission version must be 4.1.0 or higher"));
        }
        if (semver.getMajor() == 4 && semver.getMinor() < 1) {
            return new DownloaderLoginResult(DownloaderLoginResult.Status.EXCEPTION, new TranslationComponent(Lang.DOWNLOADER_TR_KNOWN_INCOMPATIBILITY, "Transmission version must higher then (or equals to) 4.1.0"));
        }
        if (!((RsSessionGet)resp.getArgs()).getBlocklistEnabled().booleanValue() || !((RsSessionGet)resp.getArgs()).getBlocklistUrl().startsWith(this.blocklistUrl)) {
            if (!this.setBlockListUrl(this.blocklistUrl)) {
                return new DownloaderLoginResult(DownloaderLoginResult.Status.EXCEPTION, new TranslationComponent(Lang.DOWNLOADER_TR_INCORRECT_BANLIST_API_RESP, "Unable to set Transmission blocklist"));
            }
            if (!this.updateBlockList()) {
                return new DownloaderLoginResult(DownloaderLoginResult.Status.REQUIRE_TAKE_ACTIONS, new TranslationComponent(Lang.DOWNLOADER_TRANSMISSION_BLOCKLIST_UPDATE_FAILED, this.getName()));
            }
        }
        return new DownloaderLoginResult(DownloaderLoginResult.Status.SUCCESS, new TranslationComponent(Lang.STATUS_TEXT_OK));
    }

    private boolean setBlockListUrl(String blocklistUrl) {
        RqSessionSet set = RqSessionSet.builder().blocklistUrl(blocklistUrl + "?t=" + System.currentTimeMillis()).blocklistEnabled(true).build();
        TypedResponse sessionSetResp = this.client.execute(set);
        return sessionSetResp.isSuccess();
    }

    private boolean updateBlockList() {
        RqBlockList updateBlockList = new RqBlockList();
        TypedResponse updateBlockListResp = this.client.execute(updateBlockList);
        if (!updateBlockListResp.isSuccess()) {
            this.setBlockListUrl("http://peerbanhelper-blocklist-update-failed.com/check-peerbanhelper-webui-prefix-settings");
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public List<Torrent> getTorrents() {
        return this.fetchTorrents(true, !this.config.isIgnorePrivate());
    }

    @Override
    @NotNull
    public List<Torrent> getAllTorrents() {
        return this.fetchTorrents(false, true);
    }

    public List<Torrent> fetchTorrents(boolean onlyActiveTorrent, boolean includePrivate) {
        RqTorrentGet torrent = new RqTorrentGet("id", "hashString", "name", "peersConnected", "status", "totalSize", "peers", "rateDownload", "rateUpload", "peer-limit", "percentDone", "sizeWhenDone", "trackerList", "trackerStats", "isPrivate");
        TypedResponse rsp = this.client.execute(torrent);
        return ((RsTorrentGet)rsp.getArgs()).getTorrents().stream().filter(t -> {
            if (onlyActiveTorrent) {
                return t.getRateDownload() > 0L || t.getRateUpload() > 0L || t.getPeersConnected() > 0;
            }
            return true;
        }).filter(t -> includePrivate || t.getIsPrivate() == false).map(backend -> new TRTorrent((Torrents)backend, this::natTranslate)).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public List<Peer> getPeers(@NotNull Torrent torrent) {
        TRTorrent trTorrent = (TRTorrent)torrent;
        return trTorrent.getPeers();
    }

    @Override
    @NotNull
    public List<Tracker> getTrackers(@NotNull Torrent torrent) {
        TRTorrent trTorrent = (TRTorrent)torrent;
        return trTorrent.getTrackers();
    }

    @Override
    public void setTrackers(@NotNull Torrent torrent, @NotNull List<Tracker> trackers) {
        StringJoiner trackersJoiner = new StringJoiner("\n\n");
        trackers.forEach(t -> trackersJoiner.add(t.toString()));
        RqTorrentSet set = RqTorrentSet.builder().ids(List.of(torrent.getId())).trackerList(trackersJoiner.toString()).build();
        this.client.execute(set);
    }

    @Override
    public void setBanList(@NotNull Collection<IPAddress> fullList, @Nullable Collection<BanMetadata> added, @Nullable Collection<BanMetadata> removed, boolean applyFullList) {
        RqBlockList updateBlockList = new RqBlockList();
        TypedResponse updateBlockListResp = this.client.execute(updateBlockList);
        if (!updateBlockListResp.isSuccess()) {
            log.error(TextManager.tlUI(Lang.DOWNLOADER_TR_INCORRECT_SET_BANLIST_API_RESP, new Object[0]));
            this.alertManager.publishAlert(true, AlertLevel.WARN, "downloader-" + this.getEndpoint() + "-transmission-blocklist-update-error", new TranslationComponent(Lang.ALERT_DOWNLOADER_TRANSMISSION_BLOCKLIST_UPDATE_FAILED_TITLE, this.getName()), new TranslationComponent(Lang.ALERT_DOWNLOADER_TRANSMISSION_BLOCKLIST_UPDATE_FAILED_DESCRIPTION, this.getName(), this.blocklistUrl));
        } else {
            log.info(TextManager.tlUI(Lang.DOWNLOADER_TR_UPDATED_BLOCKLIST, new Object[0]), (Object)((RsBlockList)updateBlockListResp.getArgs()).getBlockListSize());
        }
    }

    @Override
    @NotNull
    public DownloaderStatistics getStatistics() {
        RqSessionStats sessionStats = new RqSessionStats();
        TypedResponse sessionStatsResp = this.client.execute(sessionStats);
        RsSessionStats stats = (RsSessionStats)sessionStatsResp.getArgs();
        return new DownloaderStatistics(stats.getCumulativeStats().getUploadedBytes(), stats.getCumulativeStats().getDownloadedBytes());
    }

    @Override
    @Nullable
    public DownloaderSpeedLimiter getSpeedLimiter() {
        RqSessionGet sessionGet = new RqSessionGet(List.of("downloadLimit", "downloadLimited", "uploadLimit", "uploadLimited"));
        TypedResponse sessionGetResp = this.client.execute(sessionGet);
        if (sessionGetResp.isSuccess()) {
            RsSessionGet args = (RsSessionGet)sessionGetResp.getArgs();
            long downloadLimit = args.getSpeedLimitDown() * 1024;
            long uploadLimit = args.getSpeedLimitUp() * 1024;
            if (!args.getSpeedLimitDownEnabled().booleanValue()) {
                downloadLimit = 0L;
            }
            if (!args.getSpeedLimitUpEnabled().booleanValue()) {
                uploadLimit = 0L;
            }
            return new DownloaderSpeedLimiter(uploadLimit, downloadLimit);
        }
        log.error(TextManager.tlUI(Lang.DOWNLOADER_FAILED_RETRIEVE_SPEED_LIMITER, this.getName(), sessionGetResp.getResult()));
        return null;
    }

    @Override
    public void setSpeedLimiter(@NotNull DownloaderSpeedLimiter speedLimiter) {
        RqSessionSet set = RqSessionSet.builder().altSpeedEnabled(false).altSpeedTimeEnabled(false).speedLimitDown(speedLimiter.isDownloadUnlimited() ? (int)(Math.max(1024L, speedLimiter.download()) / 1024L) : (int)(speedLimiter.download() / 1024L)).speedLimitUp(speedLimiter.isUploadUnlimited() ? (int)(Math.max(1024L, speedLimiter.upload()) / 1024L) : (int)(speedLimiter.upload() / 1024L)).speedLimitUpEnabled(!speedLimiter.isUploadUnlimited()).speedLimitDownEnabled(!speedLimiter.isDownloadUnlimited()).build();
        TypedResponse sessionSetResp = this.client.execute(set);
        if (!sessionSetResp.isSuccess()) {
            log.error(TextManager.tlUI(Lang.DOWNLOADER_FAILED_SET_SPEED_LIMITER, this.getName(), sessionSetResp.getResult()));
        }
    }

    @Override
    public int getBTProtocolPort() {
        RqSessionGet sessionGet = new RqSessionGet(List.of("peer-port"));
        TypedResponse sessionGetResp = this.client.execute(sessionGet);
        if (sessionGetResp.isSuccess()) {
            RsSessionGet args = (RsSessionGet)sessionGetResp.getArgs();
            return args.getPeerPort();
        }
        log.error(TextManager.tlUI(Lang.DOWNLOADER_FAILED_RETRIEVE_BT_PROTOCOL_PORT, this.getName(), sessionGetResp.getResult()));
        return -1;
    }

    @Override
    public void setBTProtocolPort(int port) {
        RqSessionSet set = RqSessionSet.builder().peerPortRandomOnStart(false).peerPort(port).build();
        TypedResponse sessionSetResp = this.client.execute(set);
        if (!sessionSetResp.isSuccess()) {
            log.error(TextManager.tlUI(Lang.DOWNLOADER_FAILED_SAVE_BT_PROTOCOL_PORT, this.getName(), sessionSetResp.getResult()));
        }
    }

    @Override
    public void runScheduleTasks() {
    }

    @Override
    public void close() {
        this.client.shutdown();
    }

    public static class Config {
        private String name;
        private String type;
        private String endpoint;
        private String username;
        private String password;
        private boolean verifySsl;
        private String rpcUrl;
        private boolean ignorePrivate;
        private boolean paused;

        public static Config readFromYaml(ConfigurationSection section, String alternativeName) {
            Config config = new Config();
            config.setType("transmission");
            config.setName(section.getString("name", alternativeName));
            config.setEndpoint(section.getString("endpoint"));
            if (config.getEndpoint().endsWith("/")) {
                config.setEndpoint(config.getEndpoint().substring(0, config.getEndpoint().length() - 1));
            }
            config.setUsername(section.getString("username", ""));
            config.setPassword(section.getString("password", ""));
            config.setRpcUrl(section.getString("rpc-url", "/transmission/rpc"));
            config.setVerifySsl(section.getBoolean("verify-ssl", true));
            config.setIgnorePrivate(section.getBoolean("ignore-private", false));
            config.setPaused(section.getBoolean("paused", false));
            return config;
        }

        public YamlConfiguration saveToYaml() {
            YamlConfiguration section = new YamlConfiguration();
            section.set("type", (Object)"transmission");
            section.set("name", (Object)this.name);
            section.set("endpoint", (Object)this.endpoint);
            section.set("username", (Object)this.username);
            section.set("password", (Object)this.password);
            section.set("rpc-url", (Object)this.rpcUrl);
            section.set("verify-ssl", (Object)this.verifySsl);
            section.set("ignore-private", (Object)this.ignorePrivate);
            section.set("paused", (Object)this.paused);
            return section;
        }

        @Generated
        public Config() {
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public String getEndpoint() {
            return this.endpoint;
        }

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public String getPassword() {
            return this.password;
        }

        @Generated
        public boolean isVerifySsl() {
            return this.verifySsl;
        }

        @Generated
        public String getRpcUrl() {
            return this.rpcUrl;
        }

        @Generated
        public boolean isIgnorePrivate() {
            return this.ignorePrivate;
        }

        @Generated
        public boolean isPaused() {
            return this.paused;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Generated
        public void setUsername(String username) {
            this.username = username;
        }

        @Generated
        public void setPassword(String password) {
            this.password = password;
        }

        @Generated
        public void setVerifySsl(boolean verifySsl) {
            this.verifySsl = verifySsl;
        }

        @Generated
        public void setRpcUrl(String rpcUrl) {
            this.rpcUrl = rpcUrl;
        }

        @Generated
        public void setIgnorePrivate(boolean ignorePrivate) {
            this.ignorePrivate = ignorePrivate;
        }

        @Generated
        public void setPaused(boolean paused) {
            this.paused = paused;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isVerifySsl() != other.isVerifySsl()) {
                return false;
            }
            if (this.isIgnorePrivate() != other.isIgnorePrivate()) {
                return false;
            }
            if (this.isPaused() != other.isPaused()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$endpoint = this.getEndpoint();
            String other$endpoint = other.getEndpoint();
            if (this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
                return false;
            }
            String this$rpcUrl = this.getRpcUrl();
            String other$rpcUrl = other.getRpcUrl();
            return !(this$rpcUrl == null ? other$rpcUrl != null : !this$rpcUrl.equals(other$rpcUrl));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Config;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isVerifySsl() ? 79 : 97);
            result = result * 59 + (this.isIgnorePrivate() ? 79 : 97);
            result = result * 59 + (this.isPaused() ? 79 : 97);
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $endpoint = this.getEndpoint();
            result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            String $rpcUrl = this.getRpcUrl();
            result = result * 59 + ($rpcUrl == null ? 43 : $rpcUrl.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Transmission.Config(name=" + this.getName() + ", type=" + this.getType() + ", endpoint=" + this.getEndpoint() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", verifySsl=" + this.isVerifySsl() + ", rpcUrl=" + this.getRpcUrl() + ", ignorePrivate=" + this.isIgnorePrivate() + ", paused=" + this.isPaused() + ")";
        }
    }
}

