/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.gui;

import com.ghostchu.peerbanhelper.alert.AlertManager;
import com.ghostchu.peerbanhelper.databasent.table.AlertEntity;
import com.ghostchu.peerbanhelper.web.JavalinWebContainer;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class PBHGuiBridge {
    private final JavalinWebContainer javalinWebContainer;
    private final AlertManager alertManager;

    public PBHGuiBridge(JavalinWebContainer javalinWebContainer, AlertManager alertManager) {
        this.javalinWebContainer = javalinWebContainer;
        this.alertManager = alertManager;
    }

    public Optional<String> getWebUiToken() {
        return Optional.ofNullable(this.javalinWebContainer.getToken());
    }

    public Optional<URI> getWebUiUrl() {
        if (this.javalinWebContainer.isStarted()) {
            return Optional.of(URI.create("http://127.0.0.1:" + this.javalinWebContainer.javalin().port() + "?token=" + URLEncoder.encode(this.javalinWebContainer.getToken(), StandardCharsets.UTF_8)));
        }
        return Optional.empty();
    }

    public List<AlertEntity> getAlerts() {
        return this.alertManager.getUnreadAlerts();
    }
}

