/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.gui.impl.swing;

import java.awt.Dimension;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.TrayIcon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import lombok.Generated;

public final class SwingTray {
    private final JDialog jDialog;
    private final JPopupMenu jPopupMenu;
    private final TrayIcon trayIcon;

    public SwingTray(TrayIcon trayIcon, final Consumer<MouseEvent> clickCallback, final Consumer<MouseEvent> rightClickCallback) {
        this.trayIcon = trayIcon;
        this.jDialog = new JDialog();
        this.jDialog.setUndecorated(true);
        this.jDialog.setSize(1, 1);
        this.jPopupMenu = new JPopupMenu(this){
            final /* synthetic */ SwingTray this$0;
            {
                SwingTray swingTray = this$0;
                Objects.requireNonNull(swingTray);
                this.this$0 = swingTray;
            }

            @Override
            public void firePopupMenuWillBecomeInvisible() {
                this.this$0.jDialog.setVisible(false);
            }
        };
        trayIcon.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ SwingTray this$0;
            {
                SwingTray swingTray = this$0;
                Objects.requireNonNull(swingTray);
                this.this$0 = swingTray;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 1) {
                    clickCallback.accept(e);
                    return;
                }
                if (e.getButton() == 3 && e.isPopupTrigger()) {
                    rightClickCallback.accept(e);
                    Point point = MouseInfo.getPointerInfo().getLocation();
                    this.this$0.jDialog.setLocation(point.x, point.y);
                    this.this$0.jDialog.setVisible(true);
                    Dimension dimension = this.this$0.jPopupMenu.getPreferredSize();
                    this.this$0.jPopupMenu.setSize((int)dimension.getWidth() + 1, (int)dimension.getHeight() + 1);
                    this.this$0.jPopupMenu.show(this.this$0.jDialog, 0, 0);
                }
            }
        });
    }

    public void set(List<JMenuItem> items) {
        this.jPopupMenu.removeAll();
        items.forEach(ele -> {
            if (ele == null) {
                this.jPopupMenu.addSeparator();
            } else {
                this.jPopupMenu.add((JMenuItem)ele);
            }
        });
    }

    public JDialog getjDialog() {
        return this.jDialog;
    }

    public JPopupMenu getjPopupMenu() {
        return this.jPopupMenu;
    }

    @Generated
    public TrayIcon getTrayIcon() {
        return this.trayIcon;
    }
}

