/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.gui.impl.swing.mainwindow;

import com.formdev.flatlaf.util.SystemInfo;
import com.ghostchu.peerbanhelper.ExternalSwitch;
import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.event.program.webserver.WebServerStartedEvent;
import com.ghostchu.peerbanhelper.gui.PBHGuiBridge;
import com.ghostchu.peerbanhelper.gui.impl.swing.SwingGuiImpl;
import com.ghostchu.peerbanhelper.gui.impl.swing.mainwindow.component.LogsTab;
import com.ghostchu.peerbanhelper.gui.impl.swing.mainwindow.component.TrayMenu;
import com.ghostchu.peerbanhelper.gui.impl.swing.mainwindow.component.WebUITab;
import com.ghostchu.peerbanhelper.gui.impl.swing.mainwindow.component.WindowMenuBar;
import com.ghostchu.peerbanhelper.gui.impl.swing.mainwindow.component.WindowTab;
import com.ghostchu.peerbanhelper.gui.impl.swing.mainwindow.component.WindowTitle;
import com.ghostchu.peerbanhelper.util.MiscUtil;
import com.google.common.eventbus.Subscribe;
import io.sentry.Sentry;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SwingMainWindow
extends JFrame {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SwingMainWindow.class);
    private final SwingGuiImpl swingGUI;
    private final WindowMenuBar windowMenuBar;
    private final TrayMenu trayMenu;
    private JPanel mainPanel;
    private JTabbedPane tabbedPane;
    private PBHGuiBridge bridge;
    private final List<WindowTab> tabs = Collections.synchronizedList(new ArrayList());

    public SwingMainWindow(SwingGuiImpl swingGUI) {
        this.$$$setupUI$$$();
        this.swingGUI = swingGUI;
        if (SystemInfo.isMacFullWindowContentSupported) {
            this.getRootPane().putClientProperty("apple.awt.transparentTitleBar", true);
        }
        new WindowTitle(this);
        int maxAllowedWidth = Math.min(1280, Toolkit.getDefaultToolkit().getScreenSize().width);
        int maxAllowedHeight = Math.min(720, Toolkit.getDefaultToolkit().getScreenSize().height);
        this.setSize(maxAllowedWidth, maxAllowedHeight);
        this.setContentPane(this.mainPanel);
        this.windowMenuBar = new WindowMenuBar(this);
        this.trayMenu = new TrayMenu(this);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ SwingMainWindow this$0;
            {
                SwingMainWindow swingMainWindow = this$0;
                Objects.requireNonNull(swingMainWindow);
                this.this$0 = swingMainWindow;
            }

            @Override
            public void windowClosing(WindowEvent e) {
                this.this$0.trayMenu.minimizeToTray();
            }
        });
        ImageIcon imageIcon = new ImageIcon(Main.class.getResource("/assets/icon.png"));
        this.setIconImage(imageIcon.getImage());
        this.setVisible(!swingGUI.isSilentStart());
        if (SwingUtilities.isEventDispatchThread()) {
            this.registerTabs();
        } else {
            try {
                SwingUtilities.invokeAndWait(this::registerTabs);
            }
            catch (InterruptedException | InvocationTargetException e) {
                log.debug("Unable to register Tabs", (Throwable)e);
                Sentry.captureException((Throwable)e);
            }
        }
        Main.getEventBus().register((Object)this);
    }

    private void registerTabs() {
        block6: {
            this.tabs.add(new LogsTab(this));
            if (MiscUtil.isClassAvailable("org.eclipse.swt.SWT") && ExternalSwitch.parseBoolean("pbh.swingui.webuiTab", true)) {
                try {
                    boolean isWindows = System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("windows");
                    if (isWindows) {
                        String buildNumber = new oshi.SystemInfo().getOperatingSystem().getVersionInfo().getBuildNumber();
                        if (Long.parseLong(buildNumber) > 14393L) {
                            this.tabs.add(new WebUITab(this));
                        }
                        break block6;
                    }
                    this.tabs.add(new WebUITab(this));
                }
                catch (Exception e) {
                    log.error("Unable to create WebUITab or PerfProfilerTab", (Throwable)e);
                    Sentry.captureException((Throwable)e);
                }
            } else {
                log.debug("SWT is not available, WebUITab and PerfProfilerTab will not be created.");
            }
        }
        this.tabs.forEach(WindowTab::onWindowShow);
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            this.tabs.forEach(WindowTab::onWindowShow);
        } else {
            this.tabs.forEach(WindowTab::onWindowHide);
        }
    }

    @Subscribe
    public void onWebServerStarted(WebServerStartedEvent event) {
        this.bridge = (PBHGuiBridge)Main.getApplicationContext().getBean(PBHGuiBridge.class);
        this.tabs.forEach(tab -> tab.onStarted(this.bridge));
    }

    public static void setTabTitle(JPanel tab, String title) {
        JTabbedPane tabbedPane = (JTabbedPane)SwingUtilities.getAncestorOfClass(JTabbedPane.class, tab);
        for (int tabIndex = 0; tabIndex < tabbedPane.getTabCount(); ++tabIndex) {
            if (!SwingUtilities.isDescendingFrom(tab, tabbedPane.getComponentAt(tabIndex))) continue;
            tabbedPane.setTitleAt(tabIndex, title);
            break;
        }
    }

    public static void copyText(String content) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (Main.getServer() != null && Main.getServer().getWebContainer() != null) {
            StringSelection ts = new StringSelection(content);
            clipboard.setContents(ts, null);
        }
    }

    public void sync() {
    }

    public void openWebUI() {
        this.bridge.getWebUiUrl().ifPresent(this.swingGUI::openWebpage);
    }

    @Override
    public void dispose() {
        Main.getEventBus().unregister((Object)this);
        super.dispose();
    }

    private void $$$setupUI$$$() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout(0, 0));
        this.tabbedPane = new JTabbedPane();
        this.mainPanel.add((Component)this.tabbedPane, "Center");
    }

    public JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    public Font getFont(String fontName, int style, int size, Font currentFont) {
        Font testFont;
        if (currentFont == null) {
            return null;
        }
        String resultName = fontName == null ? currentFont.getName() : ((testFont = new Font(fontName, 0, 10)).canDisplay('a') && testFont.canDisplay('1') && testFont.canDisplay('\u4e2d') ? fontName : currentFont.getName());
        Font font = new Font(resultName, style >= 0 ? style : currentFont.getStyle(), size >= 0 ? size : currentFont.getSize());
        boolean isMac = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font fontWithFallback = isMac ? new Font(font.getFamily(), font.getStyle(), font.getSize()) : new StyleContext().getFont(font.getFamily(), font.getStyle(), font.getSize());
        return fontWithFallback instanceof FontUIResource ? fontWithFallback : new FontUIResource(fontWithFallback);
    }

    public <T extends WindowTab> T getTab(Class<T> tabClass) {
        for (WindowTab tab : this.tabs) {
            if (!tab.getClass().equals(tabClass)) continue;
            return (T)tab;
        }
        throw new IllegalStateException("Tab not found: " + tabClass.getName());
    }

    private void createUIComponents() {
    }

    @Generated
    public SwingGuiImpl getSwingGUI() {
        return this.swingGUI;
    }

    @Generated
    public WindowMenuBar getWindowMenuBar() {
        return this.windowMenuBar;
    }

    @Generated
    public TrayMenu getTrayMenu() {
        return this.trayMenu;
    }

    @Generated
    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }
}

