/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.gui.impl.swing.mainwindow.component;

import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.event.gui.PBHLookAndFeelNeedReloadEvent;
import com.ghostchu.peerbanhelper.gui.PBHGuiBridge;
import com.ghostchu.peerbanhelper.gui.impl.swing.mainwindow.SwingMainWindow;
import com.ghostchu.peerbanhelper.gui.impl.swing.mainwindow.component.WindowTab;
import com.ghostchu.peerbanhelper.gui.impl.swing.mainwindow.component.swtembed.SwtBrowserCanvas;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.util.SharedObject;
import com.google.common.eventbus.Subscribe;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class WebUITab
implements WindowTab {
    private final JPanel webuiPanel = new JPanel(new BorderLayout());
    private SwtBrowserCanvas webBrowser;
    private PBHGuiBridge bridge;

    public WebUITab(SwingMainWindow parent) {
        parent.getTabbedPane().addTab(TextManager.tlUI(Lang.GUI_TABBED_WEBUI, new Object[0]), this.webuiPanel);
        Main.getEventBus().register((Object)this);
    }

    @Subscribe
    public void onLAFReload(PBHLookAndFeelNeedReloadEvent event) {
        this.unregisterBrowser();
        this.ensureBrowser();
    }

    @Override
    public void onWindowShow() {
        this.ensureBrowser();
    }

    @Override
    public void onWindowHide() {
        this.unregisterBrowser();
    }

    public void ensureBrowser() {
        if (this.webBrowser == null || !this.webBrowser.isValid()) {
            this.unregisterBrowser();
            if (SwingUtilities.isEventDispatchThread()) {
                this.createBrowser();
            } else {
                SwingUtilities.invokeAndWait(this::createBrowser);
            }
        }
    }

    private void createBrowser() {
        this.webBrowser = new SwtBrowserCanvas();
        this.webuiPanel.add((Component)this.webBrowser, "Center");
        this.webBrowser.initBrowser();
        if (this.bridge != null) {
            this.navigateToIndex();
        }
    }

    private void unregisterBrowser() {
        if (this.webBrowser != null) {
            this.webuiPanel.removeAll();
            this.webBrowser = null;
        }
    }

    @Override
    public void onWindowResize() {
    }

    @Override
    public void onStarted(PBHGuiBridge bridge) {
        this.bridge = bridge;
        this.navigateToIndex();
    }

    private void navigateToIndex() {
        if (this.webBrowser != null) {
            this.bridge.getWebUiUrl().ifPresent(uri -> this.webBrowser.setUrl(String.valueOf(uri) + "&silentLogin=" + SharedObject.SILENT_LOGIN_TOKEN_FOR_GUI));
        }
    }
}

