/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.module.impl.monitor;

import com.ghostchu.peerbanhelper.ExternalSwitch;
import com.ghostchu.peerbanhelper.bittorrent.peer.Peer;
import com.ghostchu.peerbanhelper.bittorrent.torrent.Torrent;
import com.ghostchu.peerbanhelper.databasent.service.PeerRecordService;
import com.ghostchu.peerbanhelper.databasent.service.impl.common.PeerRecordServiceImpl;
import com.ghostchu.peerbanhelper.downloader.Downloader;
import com.ghostchu.peerbanhelper.module.AbstractFeatureModule;
import com.ghostchu.peerbanhelper.module.MonitorFeatureModule;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.util.CommonUtil;
import com.ghostchu.peerbanhelper.util.MiscUtil;
import com.ghostchu.peerbanhelper.util.backgroundtask.BackgroundTaskManager;
import com.ghostchu.peerbanhelper.util.backgroundtask.FunctionalBackgroundTask;
import com.ghostchu.peerbanhelper.wrapper.PeerWrapper;
import com.ghostchu.peerbanhelper.wrapper.TorrentWrapper;
import com.ghostchu.simplereloadlib.ReloadResult;
import com.ghostchu.simplereloadlib.Reloadable;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.sentry.Sentry;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionTemplate;

@Component
public class PeerRecordingServiceModule
extends AbstractFeatureModule
implements Reloadable,
MonitorFeatureModule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PeerRecordingServiceModule.class);
    private final AtomicBoolean databaseBackFlushFlag = new AtomicBoolean(true);
    @Autowired
    private PeerRecordService peerRecordDao;
    @Autowired
    private TransactionTemplate transactionTemplate;
    private final Cache<@NotNull PeerRecordServiceImpl.BatchHandleTasks, @NotNull Object> diskWriteCache = CacheBuilder.newBuilder().expireAfterWrite(ExternalSwitch.parseLong("pbh.module.peerRecordingServiceModule.diskWriteCache.timeout", 180000L), TimeUnit.MILLISECONDS).maximumSize((long)ExternalSwitch.parseInt("pbh.module.peerRecordingServiceModule.diskWriteCache.size", 3500)).removalListener(notification -> {
        if (notification.getValue() == null) {
            return;
        }
        if (!this.databaseBackFlushFlag.get()) {
            return;
        }
        this.backFlushDatabase((PeerRecordServiceImpl.BatchHandleTasks)notification.getKey());
    }).build();
    private long dataRetentionTime;
    @Autowired
    private BackgroundTaskManager backgroundTaskManager;

    public void flush() {
        this.transactionTemplate.execute(transactionStatus -> {
            for (Map.Entry entry : this.diskWriteCache.asMap().entrySet()) {
                this.backFlushDatabase((PeerRecordServiceImpl.BatchHandleTasks)entry.getKey());
            }
            return null;
        });
    }

    private void backFlushDatabase(PeerRecordServiceImpl.BatchHandleTasks key) {
        this.peerRecordDao.flushToDatabase(key);
    }

    @Override
    public boolean isConfigurable() {
        return true;
    }

    @Override
    public void onTorrentPeersRetrieved(@NotNull Downloader downloader, @NotNull Torrent torrent, @NotNull List<Peer> peers) {
        peers.stream().filter(peer -> {
            String clientName = peer.getClientName();
            String peerId = peer.getPeerId();
            if (clientName != null && !clientName.isBlank()) {
                return true;
            }
            if (peerId != null && !peerId.isBlank()) {
                return true;
            }
            return !peer.isHandshaking();
        }).forEach(peer -> this.diskWriteCache.put((Object)new PeerRecordServiceImpl.BatchHandleTasks(OffsetDateTime.now(), downloader.getId(), new TorrentWrapper(torrent), new PeerWrapper((Peer)peer)), MiscUtil.EMPTY_OBJECT));
    }

    @Override
    @NotNull
    public String getName() {
        return "Peer Recording Service";
    }

    @Override
    @NotNull
    public String getConfigName() {
        return "peer-analyse-service.peer-recording";
    }

    @Override
    public void onEnable() {
        this.reloadConfig();
        long dataCleanupInterval = this.getConfig().getLong("data-cleanup-interval", -1L);
        long dataFlushInterval = this.getConfig().getLong("data-flush-interval", 20000L);
        CommonUtil.getBgCleanupScheduler().scheduleWithFixedDelay(this::cleanup, 0L, dataCleanupInterval, TimeUnit.MILLISECONDS);
        this.registerScheduledTask(this::flush, 0L, dataFlushInterval, TimeUnit.MILLISECONDS);
    }

    public ReloadResult reloadModule() throws Exception {
        this.reloadConfig();
        return super.reloadModule();
    }

    private void reloadConfig() {
        this.dataRetentionTime = this.getConfig().getLong("data-retention-time", -1L);
    }

    private void cleanup() {
        try {
            if (this.dataRetentionTime <= 0L) {
                return;
            }
            this.backgroundTaskManager.addTaskAsync(new FunctionalBackgroundTask(new TranslationComponent(Lang.MODULE_PEER_RECORDING_DELETING_EXPIRED_DATA), (backgroundTask, consumer) -> {
                log.info(TextManager.tlUI(Lang.PEER_RECORDING_SERVICE_CLEANING_UP, new Object[0]));
                OffsetDateTime beforeAt = OffsetDateTime.now().minus(this.dataRetentionTime, ChronoUnit.MILLIS);
                long deleted = this.peerRecordDao.cleanup(beforeAt);
                log.info(TextManager.tlUI(Lang.PEER_RECORDING_SERVICE_CLEANED_UP, deleted));
            })).join();
        }
        catch (Throwable throwable) {
            log.error("Unable to complete scheduled tasks", throwable);
            Sentry.captureException((Throwable)throwable);
        }
    }

    @Override
    public void onDisable() {
        this.flush();
        this.databaseBackFlushFlag.set(false);
        this.diskWriteCache.invalidateAll();
        this.databaseBackFlushFlag.set(true);
    }
}

