/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.module.impl.rule;

import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.bittorrent.peer.Peer;
import com.ghostchu.peerbanhelper.bittorrent.torrent.Torrent;
import com.ghostchu.peerbanhelper.downloader.Downloader;
import com.ghostchu.peerbanhelper.module.AbstractRuleFeatureModule;
import com.ghostchu.peerbanhelper.module.CheckResult;
import com.ghostchu.peerbanhelper.module.PeerAction;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.util.IPAddressUtil;
import com.ghostchu.peerbanhelper.web.JavalinWebContainer;
import com.ghostchu.peerbanhelper.web.Role;
import com.ghostchu.peerbanhelper.web.wrapper.StdResp;
import com.ghostchu.peerbanhelper.wrapper.StructuredData;
import com.ghostchu.simplereloadlib.ReloadResult;
import com.ghostchu.simplereloadlib.Reloadable;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import inet.ipaddr.IPAddress;
import io.javalin.Javalin;
import io.javalin.http.Context;
import io.javalin.security.RouteRole;
import io.sentry.Sentry;
import java.io.Serializable;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class MultiDialingBlocker
extends AbstractRuleFeatureModule
implements Reloadable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MultiDialingBlocker.class);
    private static final int TORRENT_PEER_MAX_NUM = 1024;
    private static final int PEER_MAX_NUM_PER_SUBNET = 16;
    private int subnetMaskLength;
    private int subnetMaskV6Length;
    private long cacheLifespan;
    private boolean keepHunting;
    private long keepHuntingTime;
    @Autowired
    private JavalinWebContainer webContainer;
    private long banDuration;
    private int tolerateNumV4;
    private int tolerateNumV6;
    private static volatile boolean cacheRecovered = false;
    private static Cache<String, Long> cache;
    private static Cache<String, Cache<String, Long>> subnetCounter;
    private static Cache<String, Long> huntingList;

    @Override
    public void onEnable() {
        this.reloadConfig();
        ((Javalin)this.webContainer.javalin().get("/api/modules/" + this.getConfigName(), this::handleConfig, new RouteRole[]{Role.USER_READ})).get("/api/modules/" + this.getConfigName() + "/status", this::handleStatus, new RouteRole[]{Role.USER_READ});
        Main.getReloadManager().register((Reloadable)this);
    }

    @Override
    public void onDisable() {
        Main.getReloadManager().unregister((Reloadable)this);
    }

    public ReloadResult reloadModule() throws Exception {
        this.reloadConfig();
        return super.reloadModule();
    }

    private void handleStatus(Context ctx) {
        HashMap status = new HashMap();
        status.put("huntingList", huntingList.asMap());
        status.put("cache", cache.asMap());
        HashMap mapSubnetCounter = new HashMap();
        subnetCounter.asMap().forEach((k, v) -> mapSubnetCounter.put(k, v.asMap()));
        status.put("subnetCounter", mapSubnetCounter);
        ctx.json((Object)new StdResp(true, null, status));
    }

    private void handleConfig(Context ctx) {
        HashMap<String, Serializable> config = new HashMap<String, Serializable>();
        config.put("subnetMaskLength", Integer.valueOf(this.subnetMaskLength));
        config.put("subnetMaskV6Length", Integer.valueOf(this.subnetMaskV6Length));
        config.put("tolerateNumV4", Integer.valueOf(this.tolerateNumV4));
        config.put("tolerateNumV5", Integer.valueOf(this.tolerateNumV6));
        config.put("cacheLifespan", Long.valueOf(this.cacheLifespan));
        config.put("keepHunting", Boolean.valueOf(this.keepHunting));
        config.put("keepHuntingTime", Long.valueOf(this.keepHuntingTime));
        ctx.json((Object)new StdResp(true, null, config));
    }

    @Override
    @NotNull
    public String getName() {
        return "Multi Dialing Blocker";
    }

    @Override
    @NotNull
    public String getConfigName() {
        return "multi-dialing-blocker";
    }

    @Override
    public boolean isConfigurable() {
        return true;
    }

    private void reloadConfig() {
        this.banDuration = this.getConfig().getLong("ban-duration", 0L);
        this.subnetMaskLength = this.getConfig().getInt("subnet-mask-length");
        this.subnetMaskV6Length = this.getConfig().getInt("subnet-mask-v6-length");
        this.tolerateNumV4 = this.getConfig().getInt("tolerate-num-ipv4");
        this.tolerateNumV6 = this.getConfig().getInt("tolerate-num-ipv6");
        this.cacheLifespan = (long)this.getConfig().getInt("cache-lifespan") * 1000L;
        this.keepHunting = this.getConfig().getBoolean("keep-hunting");
        this.keepHuntingTime = (long)this.getConfig().getInt("keep-hunting-time") * 1000L;
        cache = CacheBuilder.newBuilder().expireAfterWrite(this.cacheLifespan, TimeUnit.MILLISECONDS).maximumSize(1024L).softValues().build();
        subnetCounter = CacheBuilder.newBuilder().expireAfterAccess(this.cacheLifespan, TimeUnit.MILLISECONDS).maximumSize(1024L).softValues().build();
        huntingList = CacheBuilder.newBuilder().expireAfterWrite(this.keepHuntingTime, TimeUnit.MILLISECONDS).maximumSize(1024L).softValues().build();
        this.getCache().invalidateAll();
    }

    @Override
    @NotNull
    public CheckResult shouldBanPeer(@NotNull Torrent torrent, @NotNull Peer peer, @NotNull Downloader downloader) {
        block10: {
            if (this.isHandShaking(peer)) {
                return this.handshaking();
            }
            String torrentName = torrent.getName();
            String torrentId = torrent.getId();
            IPAddress peerAddress = peer.getPeerAddress().getAddress();
            String peerIpStr = peerAddress.toString();
            IPAddress peerSubnet = peerAddress.isIPv4() ? IPAddressUtil.toPrefixBlockAndZeroHost(peerAddress, this.subnetMaskLength) : IPAddressUtil.toPrefixBlockAndZeroHost(peerAddress, this.subnetMaskV6Length);
            try {
                long currentTimestamp = System.currentTimeMillis();
                String torrentIpStr = torrentId + "@" + peerIpStr;
                cache.put((Object)torrentIpStr, (Object)currentTimestamp);
                String torrentSubnetStr = torrentId + "@" + String.valueOf(peerSubnet);
                Cache subnetPeers = (Cache)subnetCounter.get((Object)torrentSubnetStr, this::genPeerGroup);
                subnetPeers.put((Object)peerIpStr, (Object)currentTimestamp);
                int tolerateNum = Integer.MAX_VALUE;
                if (peerSubnet.isIPv4()) {
                    tolerateNum = this.tolerateNumV4;
                }
                if (peerSubnet.isIPv6()) {
                    tolerateNum = this.tolerateNumV6;
                }
                if (subnetPeers.size() > (long)tolerateNum) {
                    huntingList.put((Object)torrentSubnetStr, (Object)currentTimestamp);
                    return new CheckResult(this.getClass(), PeerAction.BAN, this.banDuration, new TranslationComponent(Lang.MDB_MULTI_DIALING_DETECTED), new TranslationComponent(Lang.MODULE_MDB_MULTI_DIALING_DETECTED, peerSubnet.toString(), peerIpStr), StructuredData.create().add("subnetPeersSize", subnetPeers.size()).add("subnet", torrentSubnetStr));
                }
                if (!this.keepHunting) break block10;
                this.recoverHuntingList();
                try {
                    long huntingTimestamp = (Long)huntingList.get((Object)torrentSubnetStr, () -> 0L);
                    if (huntingTimestamp > 0L) {
                        if (currentTimestamp - huntingTimestamp < this.keepHuntingTime) {
                            huntingList.put((Object)torrentSubnetStr, (Object)currentTimestamp);
                            return new CheckResult(this.getClass(), PeerAction.BAN, this.banDuration, new TranslationComponent(Lang.MDB_MULTI_HUNTING), new TranslationComponent(Lang.MODULE_MDB_MULTI_DIALING_HUNTING_TRIGGERED, peerSubnet.toString(), peerIpStr), StructuredData.create().add("subnetPeersSize", subnetPeers.size()).add("subnet", torrentSubnetStr));
                        }
                        huntingList.invalidate((Object)torrentSubnetStr);
                    }
                }
                catch (ExecutionException e) {
                    Sentry.captureException((Throwable)e);
                }
            }
            catch (Exception e) {
                log.error("shouldBanPeer exception", (Throwable)e);
                Sentry.captureException((Throwable)e);
            }
        }
        return this.pass();
    }

    private Cache<String, Long> genPeerGroup() {
        return CacheBuilder.newBuilder().expireAfterAccess(this.cacheLifespan, TimeUnit.MILLISECONDS).maximumSize(16L).softValues().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recoverHuntingList() {
        if (cacheRecovered) {
            return;
        }
        Class<MultiDialingBlocker> clazz = MultiDialingBlocker.class;
        synchronized (MultiDialingBlocker.class) {
            if (cacheRecovered) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            cacheRecovered = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public record HuntingTarget(String hashSubnet, long createTime) {
    }
}

