/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.module.impl.rule;

import com.ghostchu.peerbanhelper.BanList;
import com.ghostchu.peerbanhelper.ExternalSwitch;
import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.bittorrent.peer.Peer;
import com.ghostchu.peerbanhelper.bittorrent.torrent.Torrent;
import com.ghostchu.peerbanhelper.databasent.service.PCBAddressService;
import com.ghostchu.peerbanhelper.databasent.service.PCBRangeService;
import com.ghostchu.peerbanhelper.databasent.table.PCBAddressEntity;
import com.ghostchu.peerbanhelper.databasent.table.PCBRangeEntity;
import com.ghostchu.peerbanhelper.downloader.Downloader;
import com.ghostchu.peerbanhelper.downloader.DownloaderFeatureFlag;
import com.ghostchu.peerbanhelper.event.banwave.PeerUnbanEvent;
import com.ghostchu.peerbanhelper.module.AbstractRuleFeatureModule;
import com.ghostchu.peerbanhelper.module.CheckResult;
import com.ghostchu.peerbanhelper.module.PeerAction;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.util.CommonUtil;
import com.ghostchu.peerbanhelper.util.IPAddressUtil;
import com.ghostchu.peerbanhelper.util.MsgUtil;
import com.ghostchu.peerbanhelper.util.Pair;
import com.ghostchu.peerbanhelper.util.TimeUtil;
import com.ghostchu.peerbanhelper.util.backgroundtask.BackgroundTaskManager;
import com.ghostchu.peerbanhelper.util.backgroundtask.FunctionalBackgroundTask;
import com.ghostchu.peerbanhelper.web.JavalinWebContainer;
import com.ghostchu.peerbanhelper.web.Role;
import com.ghostchu.peerbanhelper.web.wrapper.StdResp;
import com.ghostchu.peerbanhelper.wrapper.StructuredData;
import com.ghostchu.simplereloadlib.ReloadResult;
import com.ghostchu.simplereloadlib.Reloadable;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.eventbus.Subscribe;
import inet.ipaddr.IPAddress;
import io.javalin.http.Context;
import io.javalin.security.RouteRole;
import io.sentry.Sentry;
import java.lang.constant.Constable;
import java.net.InetAddress;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionTemplate;

@Component
public final class ProgressCheatBlocker
extends AbstractRuleFeatureModule
implements Reloadable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProgressCheatBlocker.class);
    private final AtomicBoolean cacheBackFlushFlag = new AtomicBoolean(true);
    private final Cache<@NotNull CacheKey, @NotNull Pair<PCBRangeEntity, PCBAddressEntity>> cache = CacheBuilder.newBuilder().maximumSize(1024L).expireAfterAccess(10L, TimeUnit.SECONDS).softValues().recordStats().removalListener(notification -> {
        Pair pair = (Pair)notification.getValue();
        if (pair == null) {
            return;
        }
        if (!this.cacheBackFlushFlag.get()) {
            return;
        }
        this.flushBackDatabase((PCBRangeEntity)pair.getLeft(), (PCBAddressEntity)pair.getRight());
    }).build();
    private long torrentMinimumSize;
    private boolean blockExcessiveClients;
    private double excessiveThreshold;
    private double maximumDifference;
    private double rewindMaximumDifference;
    private int ipv4PrefixLength;
    private int ipv6PrefixLength;
    @Autowired
    private JavalinWebContainer webContainer;
    private long banDuration;
    @Autowired
    private PCBRangeService pcbRangeDao;
    @Autowired
    private PCBAddressService pcbAddressDao;
    private long persistDuration;
    private long maxWaitDuration;
    private long fastPcbTestBlockingDuration;
    private double fastPcbTestPercentage;
    private final Object cacheDBLoadingLock = new Object();
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private BackgroundTaskManager backgroundTaskManager;
    @Autowired
    private BanList banList;

    @Override
    @NotNull
    public String getName() {
        return "Progress Cheat Blocker";
    }

    @Override
    @NotNull
    public String getConfigName() {
        return "progress-cheat-blocker";
    }

    @Override
    public void onEnable() {
        this.reloadConfig();
        this.webContainer.javalin().get("/api/modules/" + this.getConfigName(), this::handleConfig, new RouteRole[]{Role.USER_READ});
        CommonUtil.getBgCleanupScheduler().scheduleWithFixedDelay(this::cleanDatabase, 0L, 8L, TimeUnit.HOURS);
        Main.getReloadManager().register((Reloadable)this);
        Main.getEventBus().register((Object)this);
    }

    @Subscribe
    public void onPeerUnBan(PeerUnbanEvent event) {
        this.transactionTemplate.execute(transactionStatus -> {
            event.getUnbannedPeers().forEach((addr, meta) -> this.pcbAddressDao.deleteEntry(meta.getTorrent().getId(), addr.toInetAddress()));
            return null;
        });
        log.debug("Deleted unbanned peers");
    }

    private void cleanDatabase() {
        this.backgroundTaskManager.addTaskAsync(new FunctionalBackgroundTask(new TranslationComponent(Lang.MODULE_PCB_BGTASK_DELETING_EXPIRED_DATA), (task, callback) -> {
            try {
                log.info(TextManager.tlUI(Lang.MODULE_PCB_DELETING_EXPIRED_DATA, new Object[0]));
                OffsetDateTime ofd = OffsetDateTime.now().minus(this.persistDuration, ChronoUnit.MILLIS);
                long deleted = 0L;
                deleted += this.pcbRangeDao.cleanupDatabase(ofd);
                log.info(TextManager.tlUI(Lang.MODULE_PCB_DELETED_EXPIRED_DATA, deleted += this.pcbAddressDao.cleanupDatabase(ofd)));
            }
            catch (Throwable e) {
                log.error("Unable to remove expired data from database", e);
                Sentry.captureException((Throwable)e);
                throw e;
            }
        })).join();
    }

    public void handleConfig(Context ctx) {
        LinkedHashMap<String, Constable> config = new LinkedHashMap<String, Constable>();
        config.put("torrentMinimumSize", Long.valueOf(this.torrentMinimumSize));
        config.put("blockExcessiveClients", Boolean.valueOf(this.blockExcessiveClients));
        config.put("excessiveThreshold", Double.valueOf(this.excessiveThreshold));
        config.put("maximumDifference", Double.valueOf(this.maximumDifference));
        config.put("rewindMaximumDifference", Double.valueOf(this.rewindMaximumDifference));
        ctx.json((Object)new StdResp(true, null, config));
    }

    @Override
    public boolean isThreadSafe() {
        return true;
    }

    @Override
    public boolean isConfigurable() {
        return true;
    }

    public ReloadResult reloadModule() throws Exception {
        this.reloadConfig();
        return super.reloadModule();
    }

    @Override
    public void onDisable() {
        Main.getEventBus().unregister((Object)this);
        Main.getReloadManager().unregister((Reloadable)this);
        this.flushBackDatabaseAll();
        this.cacheBackFlushFlag.set(false);
        this.cache.invalidateAll();
        this.cacheBackFlushFlag.set(true);
    }

    private void flushBackDatabaseAll() {
        this.transactionTemplate.execute(transactionStatus -> {
            for (Map.Entry entry : this.cache.asMap().entrySet()) {
                this.flushBackDatabase((PCBRangeEntity)((Pair)entry.getValue()).getKey(), (PCBAddressEntity)((Pair)entry.getValue()).getRight());
            }
            return null;
        });
    }

    private void reloadConfig() {
        this.banDuration = this.getConfig().getLong("ban-duration", 0L);
        this.torrentMinimumSize = this.getConfig().getLong("minimum-size");
        this.blockExcessiveClients = this.getConfig().getBoolean("block-excessive-clients");
        this.excessiveThreshold = this.getConfig().getDouble("excessive-threshold");
        this.maximumDifference = this.getConfig().getDouble("maximum-difference");
        this.rewindMaximumDifference = this.getConfig().getDouble("rewind-maximum-difference");
        this.ipv4PrefixLength = this.getConfig().getInt("ipv4-prefix-length");
        this.ipv6PrefixLength = this.getConfig().getInt("ipv6-prefix-length");
        this.persistDuration = this.getConfig().getLong("persist-duration");
        this.maxWaitDuration = this.getConfig().getLong("max-wait-duration");
        this.fastPcbTestPercentage = this.getConfig().getDouble("fast-pcb-test-percentage");
        this.fastPcbTestBlockingDuration = this.getConfig().getLong("fast-pcb-test-block-duration");
        this.getCache().invalidateAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public CheckResult shouldBanPeer(@NotNull Torrent torrent, @NotNull Peer peer, @NotNull Downloader downloader) {
        if (this.isHandShaking(peer)) {
            return this.handshaking();
        }
        IPAddress peerIp = peer.getPeerAddress().getAddress();
        IPAddress peerPrefix = peerIp.isIPv4() ? IPAddressUtil.toPrefixBlockAndZeroHost(peerIp, this.ipv4PrefixLength) : IPAddressUtil.toPrefixBlockAndZeroHost(peerIp, this.ipv6PrefixLength);
        String peerPrefixString = peerPrefix.toString();
        Pair<PCBRangeEntity, PCBAddressEntity> pair = this.loadFromDatabase(downloader.getId(), torrent.getId(), peerPrefixString, peerIp.toInetAddress(), peer.getPeerAddress().getPort());
        PCBRangeEntity rangeEntity = pair.getLeft();
        PCBAddressEntity addressEntity = pair.getRight();
        long computedUploadedIncremental = peer.getUploaded() < addressEntity.getLastReportUploaded() ? peer.getUploaded() : peer.getUploaded() - addressEntity.getLastReportUploaded();
        addressEntity.setTrackingUploadedIncreaseTotal(addressEntity.getTrackingUploadedIncreaseTotal() + computedUploadedIncremental);
        rangeEntity.setTrackingUploadedIncreaseTotal(rangeEntity.getTrackingUploadedIncreaseTotal() + computedUploadedIncremental);
        long computedUploaded = Math.max(peer.getUploaded(), Math.max(addressEntity.getTrackingUploadedIncreaseTotal(), rangeEntity.getTrackingUploadedIncreaseTotal()));
        try {
            long torrentSize = torrent.getSize();
            long completedSize = torrent.getCompletedSize();
            long computedCompletedSize = Math.max(completedSize, Math.max(rangeEntity.getLastTorrentCompletedSize(), addressEntity.getLastTorrentCompletedSize()));
            if (torrentSize <= 0L) {
                CheckResult checkResult = this.pass();
                return checkResult;
            }
            if (!this.isUploadingToPeer(peer)) {
                CheckResult checkResult = this.pass();
                return checkResult;
            }
            StructuredData<String, Object> structuredData = StructuredData.create().add("torrentSize", torrentSize).add("completedSize", completedSize).add("computedCompletedSize", computedCompletedSize).add("peerReportUploaded", peer.getUploaded()).add("peerLastReportUploaded", addressEntity.getLastReportUploaded()).add("prefixLastReportUploaded", rangeEntity.getLastReportUploaded()).add("peerTrackingUploadedIncreaseTotal", addressEntity.getTrackingUploadedIncreaseTotal()).add("prefixTrackingUploadedIncreaseTotal", rangeEntity.getTrackingUploadedIncreaseTotal()).add("actualUploaded", computedUploaded).add("uploadedIncremental", computedUploadedIncremental).add("fileTooSmall", this.fileTooSmall(torrentSize)).add("fastPcbTestPercentage", this.fastPcbTestPercentage);
            CheckResult result = this.fastPcbTest(addressEntity, rangeEntity, computedUploaded, torrentSize, structuredData, downloader);
            if (result != null) {
                CheckResult checkResult = result;
                return checkResult;
            }
            double computedProgress = (double)computedUploaded / (double)torrentSize;
            double clientReportedProgress = peer.getProgress();
            structuredData.add("computedProgress", computedProgress);
            structuredData.add("clientReportedProgress", clientReportedProgress);
            CheckResult result2 = this.excessiveClient(computedUploaded, torrentSize, structuredData, rangeEntity, addressEntity, completedSize, computedCompletedSize);
            if (result2 != null) {
                CheckResult checkResult = result2;
                return checkResult;
            }
            if (computedProgress <= clientReportedProgress) {
                result2 = this.pass();
                return result2;
            }
            result2 = this.differenceTest(rangeEntity, addressEntity, clientReportedProgress, computedProgress, structuredData, torrentSize, peer);
            if (result2 != null) {
                CheckResult checkResult = result2;
                return checkResult;
            }
            result2 = this.progressRewind(peer, structuredData, rangeEntity, addressEntity, clientReportedProgress, computedProgress, torrentSize);
            if (result2 != null) {
                CheckResult checkResult = result2;
                return checkResult;
            }
            CheckResult checkResult = this.pass();
            return checkResult;
        }
        finally {
            addressEntity.setLastReportUploaded(peer.getUploaded());
            if (peer.getProgress() != 0.0) {
                addressEntity.setLastReportProgress(peer.getProgress());
                rangeEntity.setLastReportProgress(peer.getProgress());
            }
            addressEntity.setLastTorrentCompletedSize(Math.max(torrent.getCompletedSize(), addressEntity.getLastTorrentCompletedSize()));
            addressEntity.setLastTimeSeen(OffsetDateTime.now());
            rangeEntity.setLastReportUploaded(peer.getUploaded());
            rangeEntity.setLastTorrentCompletedSize(Math.max(torrent.getCompletedSize(), rangeEntity.getLastTorrentCompletedSize()));
            rangeEntity.setLastTimeSeen(OffsetDateTime.now());
        }
    }

    @Nullable
    private CheckResult differenceTest(PCBRangeEntity rangeEntity, PCBAddressEntity addressEntity, double clientReportedProgress, double computedProgress, StructuredData<String, Object> structuredData, long torrentSize, Peer peer) {
        double difference = Math.abs(computedProgress - clientReportedProgress);
        structuredData.add("difference", difference);
        if (difference > this.maximumDifference && !this.fileTooSmall(torrentSize) && this.isUploadingToPeer(peer)) {
            if (!this.isBanDelayWindowScheduled(rangeEntity, addressEntity)) {
                this.scheduleBanDelayWindow(rangeEntity, addressEntity);
                return null;
            }
            if (this.isBanDelayWindowExpired(rangeEntity, addressEntity)) {
                rangeEntity.setProgressDifferenceCounter(rangeEntity.getProgressDifferenceCounter() + 1);
                addressEntity.setProgressDifferenceCounter(addressEntity.getProgressDifferenceCounter() + 1);
                this.resetBanDelayWindow(rangeEntity, addressEntity);
                return new CheckResult(this.getClass(), PeerAction.BAN, this.banDuration, new TranslationComponent(Lang.PCB_RULE_REACHED_MAX_DIFFERENCE), new TranslationComponent(Lang.MODULE_PCB_PEER_BAN_INCORRECT_PROGRESS, this.percent(clientReportedProgress), this.percent(computedProgress), this.percent(difference)), structuredData.add("type", "deSyncDifference"));
            }
        }
        return null;
    }

    @Nullable
    private CheckResult progressRewind(@NotNull Peer peer, @NotNull StructuredData<String, Object> structuredData, @NotNull PCBRangeEntity rangeEntity, @NotNull PCBAddressEntity addressEntity, double clientReportedProgress, double computedProgress, long torrentSize) {
        if (this.rewindMaximumDifference > 0.0 && !this.fileTooSmall(torrentSize)) {
            double lastReportProgress = Math.max(addressEntity.getLastReportProgress(), rangeEntity.getLastReportProgress());
            double rewind = lastReportProgress - peer.getProgress();
            structuredData.add("peerLastReportProgress", addressEntity.getLastReportProgress());
            structuredData.add("rangeLastRecordProgress", rangeEntity.getLastReportProgress());
            structuredData.add("lastReportProgress", lastReportProgress);
            structuredData.add("rewind", rewind);
            structuredData.add("rewindMaximumDifference", this.rewindMaximumDifference);
            log.debug("Debug: Peer {} rewind check: lastReportProgress={}, currentProgress={}, rewind={}, rewindMaximumDifference={}", new Object[]{peer.getPeerAddress(), this.percent(lastReportProgress), this.percent(peer.getProgress()), this.percent(rewind), this.percent(this.rewindMaximumDifference)});
            if (rewind > this.rewindMaximumDifference && this.isUploadingToPeer(peer) && peer.getProgress() > 0.0) {
                addressEntity.setRewindCounter(addressEntity.getRewindCounter() + 1);
                rangeEntity.setRewindCounter(rangeEntity.getRewindCounter() + 1);
                this.resetBanDelayWindow(rangeEntity, addressEntity);
                return new CheckResult(this.getClass(), PeerAction.BAN, this.banDuration, new TranslationComponent(Lang.PCB_RULE_PROGRESS_REWIND), new TranslationComponent(Lang.MODULE_PCB_PEER_BAN_REWIND, this.percent(clientReportedProgress), this.percent(computedProgress), this.percent(lastReportProgress), this.percent(rewind), this.percent(this.rewindMaximumDifference)), structuredData.add("type", "rewindProgress"));
            }
        }
        return null;
    }

    @Nullable
    private CheckResult excessiveClient(long computedUploaded, long torrentSize, StructuredData<String, Object> structuredData, PCBRangeEntity rangeEntity, PCBAddressEntity addressEntity, long completedSize, long computedCompletedSize) {
        if (computedUploaded != -1L && this.blockExcessiveClients) {
            if (computedUploaded > torrentSize) {
                long maxAllowedExcessiveThreshold = (long)((double)Math.max(torrentSize, this.torrentMinimumSize) * this.excessiveThreshold);
                structuredData.add("maxAllowedExcessiveThreshold", maxAllowedExcessiveThreshold);
                if (computedUploaded > maxAllowedExcessiveThreshold) {
                    this.resetBanDelayWindow(rangeEntity, addressEntity);
                    return new CheckResult(this.getClass(), PeerAction.BAN, this.banDuration, new TranslationComponent(Lang.PCB_RULE_REACHED_MAX_ALLOWED_EXCESSIVE_THRESHOLD), new TranslationComponent(Lang.MODULE_PCB_EXCESSIVE_DOWNLOAD, torrentSize, computedUploaded, maxAllowedExcessiveThreshold), structuredData.add("type", "excessiveMaxDownloadThreshold"));
                }
            } else if (ExternalSwitch.parse("pbh.pcb.disable-completed-excessive") == null && completedSize > 0L && computedUploaded > completedSize) {
                long maxAllowedExcessiveThreshold = (long)((double)Math.max(computedCompletedSize, this.torrentMinimumSize) * this.excessiveThreshold);
                structuredData.add("maxAllowedExcessiveThreshold", maxAllowedExcessiveThreshold);
                if (computedUploaded > maxAllowedExcessiveThreshold) {
                    this.resetBanDelayWindow(rangeEntity, addressEntity);
                    return new CheckResult(this.getClass(), PeerAction.BAN, this.banDuration, new TranslationComponent(Lang.PCB_RULE_REACHED_MAX_ALLOWED_EXCESSIVE_THRESHOLD), new TranslationComponent(Lang.MODULE_PCB_EXCESSIVE_DOWNLOAD_INCOMPLETE, torrentSize, completedSize, computedUploaded, maxAllowedExcessiveThreshold), structuredData.add("type", "excessiveMaxDownloadThresholdForIncompleteTask"));
                }
            }
        }
        return null;
    }

    @Nullable
    private CheckResult fastPcbTest(PCBAddressEntity addressEntity, PCBRangeEntity rangeEntity, long computedUploaded, long torrentSize, StructuredData<String, Object> structuredData, Downloader downloader) {
        if (this.fastPcbTestPercentage > 0.0 && !this.fileTooSmall(torrentSize) && downloader.getFeatureFlags().contains((Object)DownloaderFeatureFlag.UNBAN_IP) && (addressEntity.getFastPcbTestExecuteAt().isEqual(TimeUtil.zeroOffsetDateTime) || rangeEntity.getFastPcbTestExecuteAt().isEqual(TimeUtil.zeroOffsetDateTime)) && (double)computedUploaded >= this.fastPcbTestPercentage * (double)torrentSize) {
            addressEntity.setFastPcbTestExecuteAt(OffsetDateTime.now());
            rangeEntity.setFastPcbTestExecuteAt(OffsetDateTime.now());
            return new CheckResult(this.getClass(), PeerAction.BAN_FOR_DISCONNECT, this.fastPcbTestBlockingDuration, new TranslationComponent(Lang.PCB_RULE_PEER_PROGRESS_CHEAT_TESTING), new TranslationComponent(Lang.PCB_DESCRIPTION_PEER_PROGRESS_CHEAT_TESTING), structuredData.add("type", "fastPcbTest"));
        }
        return null;
    }

    private void scheduleBanDelayWindow(@Nullable PCBRangeEntity rangeEntity, @Nullable PCBAddressEntity addressEntity) {
        if (rangeEntity != null && rangeEntity.getBanDelayWindowEndAt().toInstant().toEpochMilli() <= 0L) {
            rangeEntity.setBanDelayWindowEndAt(OffsetDateTime.now().plus(this.maxWaitDuration, ChronoUnit.MILLIS));
        }
        if (addressEntity != null && addressEntity.getBanDelayWindowEndAt().toInstant().toEpochMilli() <= 0L) {
            addressEntity.setBanDelayWindowEndAt(OffsetDateTime.now().plus(this.maxWaitDuration, ChronoUnit.MILLIS));
        }
    }

    private boolean isBanDelayWindowScheduled(@Nullable PCBRangeEntity rangeEntity, @Nullable PCBAddressEntity addressEntity) {
        return rangeEntity != null && rangeEntity.getBanDelayWindowEndAt().toInstant().toEpochMilli() > 0L || addressEntity != null && addressEntity.getBanDelayWindowEndAt().toInstant().toEpochMilli() > 0L;
    }

    private boolean isBanDelayWindowExpired(@Nullable PCBRangeEntity rangeEntity, @Nullable PCBAddressEntity addressEntity) {
        return rangeEntity != null && rangeEntity.getBanDelayWindowEndAt().toInstant().toEpochMilli() > 0L && rangeEntity.getBanDelayWindowEndAt().isBefore(OffsetDateTime.now()) || addressEntity != null && addressEntity.getBanDelayWindowEndAt().toInstant().toEpochMilli() > 0L && addressEntity.getBanDelayWindowEndAt().isBefore(OffsetDateTime.now());
    }

    private void resetBanDelayWindow(@Nullable PCBRangeEntity rangeEntity, @Nullable PCBAddressEntity addressEntity) {
        if (rangeEntity != null && rangeEntity.getBanDelayWindowEndAt().toInstant().toEpochMilli() > 0L) {
            rangeEntity.setBanDelayWindowEndAt(TimeUtil.zeroOffsetDateTime);
        }
        if (addressEntity != null && addressEntity.getBanDelayWindowEndAt().toInstant().toEpochMilli() > 0L) {
            addressEntity.setBanDelayWindowEndAt(TimeUtil.zeroOffsetDateTime);
        }
    }

    private boolean isUploadingToPeer(Peer peer) {
        return peer.getUploadSpeed() > 0L || peer.getUploaded() > 0L;
    }

    private boolean fileTooSmall(long torrentSize) {
        return torrentSize < this.torrentMinimumSize;
    }

    @NotNull
    private Pair<PCBRangeEntity, PCBAddressEntity> loadFromDatabase(String downloader, String torrentId, String peerAddressPrefix, InetAddress peerAddressIp, int port) {
        CacheKey cacheKey = new CacheKey(downloader, torrentId, peerAddressPrefix, peerAddressIp);
        try {
            return (Pair)this.cache.get((Object)cacheKey, () -> {
                Object object = this.cacheDBLoadingLock;
                synchronized (object) {
                    PCBRangeEntity rangeEntity = this.pcbRangeDao.fetchFromDatabase(torrentId, peerAddressPrefix, downloader);
                    PCBAddressEntity pcbAddressEntity = this.pcbAddressDao.fetchFromDatabase(torrentId, peerAddressIp, port, downloader);
                    if (rangeEntity == null) {
                        log.debug("Creating new PCBRangeEntity for torrentId={}, peerAddressPrefix={}, downloader={}", new Object[]{torrentId, peerAddressPrefix, downloader});
                        rangeEntity = new PCBRangeEntity(null, peerAddressPrefix, torrentId, 0.0, 0L, 0L, 0, 0, OffsetDateTime.now(), OffsetDateTime.now(), downloader, TimeUtil.zeroOffsetDateTime, TimeUtil.zeroOffsetDateTime, 0L);
                        this.pcbRangeDao.save(rangeEntity);
                    }
                    if (pcbAddressEntity == null) {
                        log.debug("Creating new PCBAddressEntity for torrentId={}, peerAddressIp={}, port={}, downloader={}", new Object[]{torrentId, peerAddressIp, port, downloader});
                        pcbAddressEntity = new PCBAddressEntity(null, peerAddressIp, port, torrentId, 0.0, 0L, 0L, 0, 0, OffsetDateTime.now(), OffsetDateTime.now(), downloader, TimeUtil.zeroOffsetDateTime, TimeUtil.zeroOffsetDateTime, 0L);
                        this.pcbAddressDao.save(pcbAddressEntity);
                    }
                    return Pair.of(rangeEntity, pcbAddressEntity);
                }
            });
        }
        catch (ExecutionException e) {
            Sentry.captureException((Throwable)e);
            throw new RuntimeException(e.getCause());
        }
    }

    @NotNull
    private Pair<PCBRangeEntity, PCBAddressEntity> flushBackDatabase(PCBRangeEntity pcbRangeEntity, PCBAddressEntity pcbAddressEntity) {
        log.debug("Flushing back to database for pair PCBRangeEntity id={} and PCBAddressEntity id={}", (Object)pcbRangeEntity.getId(), (Object)pcbAddressEntity.getId());
        this.pcbRangeDao.saveOrUpdate(pcbRangeEntity);
        this.pcbAddressDao.saveOrUpdate(pcbAddressEntity);
        return Pair.of(pcbRangeEntity, pcbAddressEntity);
    }

    private String percent(double d) {
        return MsgUtil.getPercentageFormatter().format(d);
    }

    record CacheKey(String downloader, String torrentId, String peerAddressPrefix, InetAddress peerAddressIp) {
    }
}

