/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.module.impl.webapi;

import com.ghostchu.peerbanhelper.ExternalSwitch;
import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.downloader.Downloader;
import com.ghostchu.peerbanhelper.downloader.DownloaderManager;
import com.ghostchu.peerbanhelper.module.AbstractFeatureModule;
import com.ghostchu.peerbanhelper.module.impl.webapi.dto.AutoStunConfigDto;
import com.ghostchu.peerbanhelper.module.impl.webapi.dto.AutoStunConfigForm;
import com.ghostchu.peerbanhelper.module.impl.webapi.dto.TunnelInfoDTO;
import com.ghostchu.peerbanhelper.module.impl.webapi.dto.TunnelProxyConnectionDTO;
import com.ghostchu.peerbanhelper.module.impl.webapi.dto.TunnelsDTO;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.util.query.PBHPage;
import com.ghostchu.peerbanhelper.util.query.Pageable;
import com.ghostchu.peerbanhelper.util.traversal.btstun.BTStunInstance;
import com.ghostchu.peerbanhelper.util.traversal.btstun.BTStunManager;
import com.ghostchu.peerbanhelper.util.traversal.btstun.StunManager;
import com.ghostchu.peerbanhelper.util.traversal.forwarder.Forwarder;
import com.ghostchu.peerbanhelper.util.traversal.forwarder.ForwarderIOHandlerType;
import com.ghostchu.peerbanhelper.util.traversal.forwarder.table.ConnectionStatistics;
import com.ghostchu.peerbanhelper.web.JavalinWebContainer;
import com.ghostchu.peerbanhelper.web.Role;
import com.ghostchu.peerbanhelper.web.wrapper.StdResp;
import io.javalin.Javalin;
import io.javalin.http.Context;
import io.javalin.security.RouteRole;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.bspfsystems.yamlconfiguration.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import oshi.SystemInfo;

@Component
public class PBHAutoStunController
extends AbstractFeatureModule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PBHAutoStunController.class);
    private final JavalinWebContainer javalinWebContainer;
    private final StunManager stunManager;
    private final BTStunManager bTStunManager;
    private final DownloaderManager downloaderManager;
    private final SystemInfo systemInfo;

    public PBHAutoStunController(JavalinWebContainer javalinWebContainer, StunManager stunManager, BTStunManager bTStunManager, DownloaderManager downloaderManager, SystemInfo systemInfo) {
        this.javalinWebContainer = javalinWebContainer;
        this.stunManager = stunManager;
        this.bTStunManager = bTStunManager;
        this.downloaderManager = downloaderManager;
        this.systemInfo = systemInfo;
    }

    @Override
    public boolean isConfigurable() {
        return false;
    }

    @Override
    @NotNull
    public String getName() {
        return "WebAPI - AutoSTUN";
    }

    @Override
    @NotNull
    public String getConfigName() {
        return "webeapi-autostun";
    }

    @Override
    public void onEnable() {
        ((Javalin)((Javalin)((Javalin)((Javalin)((Javalin)((Javalin)this.javalinWebContainer.javalin().get("/api/autostun/status", this::getModuleStatus, new RouteRole[]{Role.USER_READ})).post("/api/autostun/refreshNatType", this::refreshNatType, new RouteRole[]{Role.USER_WRITE})).post("/api/autostun/restart", this::autoStunRestart, new RouteRole[]{Role.USER_WRITE})).get("/api/autostun/tunnels", this::tunnels, new RouteRole[]{Role.USER_READ})).get("/api/autostun/tunnel/{downloader}/info", this::tunnelInfo, new RouteRole[]{Role.USER_READ})).get("/api/autostun/tunnel/{downloader}/connections", this::tunnelConnections, new RouteRole[]{Role.USER_READ})).put("/api/autostun/config", this::putModuleConfig, new RouteRole[]{Role.USER_WRITE});
    }

    private void getModuleStatus(@NotNull Context context) {
        ConfigurationSection section = Main.getMainConfig().getConfigurationSection("auto-stun");
        if (section == null) {
            throw new IllegalStateException("Auto-stun configuration section not found");
        }
        String defaultIpv4Gateway = this.systemInfo.getOperatingSystem().getNetworkParams().getIpv4DefaultGateway();
        boolean isDockerBridge = defaultIpv4Gateway.startsWith("172.") && ExternalSwitch.parse("pbh.release", "unknown").toLowerCase(Locale.ROOT).contains("docker") && ExternalSwitch.parseBoolean("pbh.autostun.checkdockerbridge", true);
        AutoStunConfigDto autoStunConfigDto = new AutoStunConfigDto(section.getBoolean("enabled", false), section.getBoolean("use-friendly-loopback-mapping", true), section.getStringList("downloaders").stream().map(this.downloaderManager::getDownloaderById).filter(Objects::nonNull).map(this.downloaderManager::getDownloadInfo).toList(), this.stunManager.getCachedNatType(), isDockerBridge);
        context.json((Object)new StdResp(true, null, autoStunConfigDto));
    }

    private void putModuleConfig(@NotNull Context context) throws Exception {
        AutoStunConfigForm autoStunConfigForm = (AutoStunConfigForm)context.bodyAsClass(AutoStunConfigForm.class);
        ConfigurationSection section = Main.getMainConfig().getConfigurationSection("auto-stun");
        if (section == null) {
            throw new IllegalStateException("Auto-stun configuration section not found");
        }
        section.set("enabled", (Object)autoStunConfigForm.isEnabled());
        section.set("use-friendly-loopback-mapping", (Object)autoStunConfigForm.isUseFriendlyLoopbackMapping());
        section.set("downloaders", autoStunConfigForm.getDownloaders());
        Main.getMainConfig().save(Main.getMainConfigFile());
        this.bTStunManager.reloadModule();
        context.json((Object)new StdResp(true, TextManager.tl(this.locale(context), Lang.AUTOSTUN_CONFIG_REAPPLIED, new Object[0]), null));
    }

    private void tunnelConnections(@NotNull Context context) {
        Pageable pageable = new Pageable(context);
        String downloaderId = context.pathParam("downloader");
        Downloader downloader = this.downloaderManager.getDownloaderById(downloaderId);
        if (downloader == null) {
            context.json((Object)new StdResp(false, TextManager.tl(this.locale(context), new TranslationComponent(Lang.AUTOSTUN_DOWNLOADER_NOT_EXISTS, downloaderId)), null));
            return;
        }
        BTStunInstance stunInstance = this.bTStunManager.getStunInstance(downloader);
        if (stunInstance == null) {
            context.json((Object)new StdResp(false, TextManager.tl(this.locale(context), new TranslationComponent(Lang.AUTOSTUN_DOWNLOADER_TUNNEL_NOT_EXISTS, downloader.getName())), null));
            return;
        }
        Forwarder forwarder = stunInstance.getTcpForwarder();
        if (forwarder == null) {
            context.json((Object)new StdResp(false, TextManager.tl(this.locale(context), new TranslationComponent(Lang.AUTOSTUN_DOWNLOADER_TUNNEL_FORWARDER_NOT_EXISTS, downloader.getName())), List.of()));
            return;
        }
        LinkedList<TunnelProxyConnectionDTO> connectionList = new LinkedList<TunnelProxyConnectionDTO>();
        for (Map.Entry connection : forwarder.getDownstreamAddressAsKeyConnectionMap().entrySet()) {
            InetSocketAddress downstreamAddr = (InetSocketAddress)connection.getKey();
            InetSocketAddress proxyLAddr = (InetSocketAddress)connection.getValue();
            ConnectionStatistics statistics = forwarder.getDownstreamAddressAsKeyConnectionStats().get(downstreamAddr);
            if (statistics == null) continue;
            TunnelProxyConnectionDTO tunnelProxyConnectionDTO = new TunnelProxyConnectionDTO(statistics.getIpGeoData(), downstreamAddr.getHostString(), downstreamAddr.getPort(), forwarder.getProxyHost(), forwarder.getProxyPort(), proxyLAddr.getHostString(), proxyLAddr.getPort(), forwarder.getUpstremHost(), forwarder.getUpstreamPort(), statistics.getEstablishedAt(), statistics.getLastActivityAt(), statistics.getToDownstreamBytes().sum(), statistics.getToUpstreamBytes().sum());
            connectionList.add(tunnelProxyConnectionDTO);
        }
        connectionList.sort(Comparator.comparing(TunnelProxyConnectionDTO::getToDownstreamBytes).thenComparing(TunnelProxyConnectionDTO::getToUpstreamBytes).reversed());
        long total = connectionList.size();
        long skip = pageable.getZeroBasedPage() * pageable.getSize();
        context.json((Object)new StdResp(true, null, new PBHPage(pageable.getPage(), pageable.getSize(), total, connectionList.stream().skip(skip).limit(pageable.getSize()).toList())));
    }

    private void tunnelInfo(@NotNull Context context) {
        String downloaderId = context.pathParam("downloader");
        Downloader downloader = this.downloaderManager.getDownloaderById(downloaderId);
        if (downloader == null) {
            context.json((Object)new StdResp(false, TextManager.tl(this.locale(context), new TranslationComponent(Lang.AUTOSTUN_DOWNLOADER_NOT_EXISTS, downloaderId)), null));
            return;
        }
        BTStunInstance stunInstance = this.bTStunManager.getStunInstance(downloader);
        if (stunInstance == null) {
            context.json((Object)new StdResp(false, TextManager.tl(this.locale(context), new TranslationComponent(Lang.AUTOSTUN_DOWNLOADER_TUNNEL_NOT_EXISTS, downloader.getName())), null));
            return;
        }
        context.json((Object)new StdResp(true, null, this.toTunnelInfoDto(this.locale(context), stunInstance)));
    }

    private void tunnels(@NotNull Context context) {
        ArrayList<TunnelsDTO> tunnels = new ArrayList<TunnelsDTO>();
        for (Map.Entry<Downloader, BTStunInstance> entry : this.bTStunManager.getDownloadStunInstances().entrySet()) {
            Downloader downloader = entry.getKey();
            BTStunInstance stunInstance = entry.getValue();
            tunnels.add(new TunnelsDTO(this.downloaderManager.getDownloadInfo(downloader), this.toTunnelInfoDto(this.locale(context), stunInstance)));
        }
        context.json((Object)new StdResp(true, null, tunnels));
    }

    private TunnelInfoDTO toTunnelInfoDto(String locale, BTStunInstance stunInstance) {
        return new TunnelInfoDTO(stunInstance.getTunnel() != null && stunInstance.getTunnel().isValid(), stunInstance.getTunnel() != null ? stunInstance.getTunnel().getStartedAt() : 0L, stunInstance.getTunnel() != null ? stunInstance.getTunnel().getLastSuccessHeartbeatAt() : 0L, stunInstance.getTcpForwarder() != null ? stunInstance.getTcpForwarder().getConnectionHandled() : 0L, stunInstance.getTcpForwarder() != null ? stunInstance.getTcpForwarder().getConnectionFailed() : 0L, stunInstance.getTcpForwarder() != null ? stunInstance.getTcpForwarder().getConnectionBlocked() : 0L, stunInstance.getTcpForwarder() != null ? stunInstance.getTcpForwarder().getConnectionRejected() : 0L, stunInstance.getTcpForwarder() != null ? stunInstance.getTcpForwarder().getTotalToDownstream() : 0L, stunInstance.getTcpForwarder() != null ? stunInstance.getTcpForwarder().getTotalToUpstream() : 0L, stunInstance.getTcpForwarder() != null ? stunInstance.getTcpForwarder().getEstablishedConnections() : 0L, stunInstance.getTcpForwarder() != null ? stunInstance.getTcpForwarder().getProxyHost() : "???", stunInstance.getTcpForwarder() != null ? stunInstance.getTcpForwarder().getProxyPort() : 0, stunInstance.getTcpForwarder() != null ? stunInstance.getTcpForwarder().getUpstremHost() : "???", stunInstance.getTcpForwarder() != null ? stunInstance.getTcpForwarder().getUpstreamPort() : 0, stunInstance.getTcpForwarder() != null ? stunInstance.getTcpForwarder().getForwarderIOHandlerType() : ForwarderIOHandlerType.DEFAULT, TextManager.tl(locale, stunInstance.getShutdownReason()));
    }

    private void autoStunRestart(@NotNull Context context) {
        try {
            this.bTStunManager.reloadModule();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        context.json((Object)new StdResp(true, TextManager.tl(this.locale(context), new TranslationComponent(Lang.AUTOSTUN_RESTARTED)), null));
    }

    private void refreshNatType(@NotNull Context context) {
        Thread.ofVirtual().name("Refresh NAT Status").start(this.stunManager::refreshNatType);
        context.json((Object)new StdResp(true, "Refreshing NAT Status", null));
    }

    @Override
    public void onDisable() {
    }

    private void status(@NotNull Context context) {
    }
}

