/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.module.impl.webapi;

import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.event.program.logger.NewLogEntryCreatedEvent;
import com.ghostchu.peerbanhelper.module.AbstractWebSocketFeatureModule;
import com.ghostchu.peerbanhelper.module.impl.webapi.dto.WebSocketLogEntryDTO;
import com.ghostchu.peerbanhelper.util.logger.JListAppender;
import com.ghostchu.peerbanhelper.util.logger.LogEntry;
import com.ghostchu.peerbanhelper.web.JavalinWebContainer;
import com.ghostchu.peerbanhelper.web.Role;
import com.ghostchu.peerbanhelper.web.wrapper.StdResp;
import com.google.common.eventbus.Subscribe;
import io.javalin.Javalin;
import io.javalin.http.Context;
import io.javalin.security.RouteRole;
import io.javalin.websocket.WsConfig;
import io.javalin.websocket.WsContext;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class PBHLogsController
extends AbstractWebSocketFeatureModule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PBHLogsController.class);
    @Autowired
    private JavalinWebContainer webContainer;

    @Override
    public boolean isConfigurable() {
        return false;
    }

    @Override
    @NotNull
    public String getName() {
        return "WebAPI - Logs";
    }

    @Override
    @NotNull
    public String getConfigName() {
        return "webapi-logs";
    }

    @Override
    public void onEnable() {
        ((Javalin)this.webContainer.javalin().get("/api/logs/history", this::handleLogs, new RouteRole[]{Role.USER_WRITE})).ws("/api/logs/stream", this::handleLogsStream, new RouteRole[]{Role.USER_WRITE});
        Main.getEventBus().register((Object)this);
    }

    @Subscribe
    public void onLogRecordCreated(NewLogEntryCreatedEvent event) {
        for (WsContext wsContext : this.wsSessions) {
            wsContext.send((Object)new StdResp(true, null, new WebSocketLogEntryDTO(event.entry().time(), event.entry().thread(), event.entry().level().name(), event.entry().content(), event.entry().seq())));
        }
    }

    private void handleLogsStream(WsConfig wsConfig) {
        this.acceptWebSocket(wsConfig, ctx -> {
            String offset = ctx.queryParam("offset");
            this.sendHistoryLogs((WsContext)ctx, Long.parseLong(offset == null ? String.valueOf(Long.MAX_VALUE) : offset));
        });
    }

    private void sendHistoryLogs(WsContext ctx, long offset) {
        if (offset > JListAppender.getSeq().longValue()) {
            offset = 0L;
            LogEntry peekedRecord = JListAppender.ringDeque.peek();
            if (peekedRecord != null) {
                long headSeq = peekedRecord.seq();
                offset = headSeq - 1L;
            }
        }
        for (LogEntry logEntry : JListAppender.ringDeque) {
            if (logEntry.seq() <= offset) continue;
            ctx.send((Object)new StdResp(true, null, new WebSocketLogEntryDTO(logEntry.time(), logEntry.thread(), logEntry.level().name(), logEntry.content(), logEntry.seq())));
        }
    }

    private void handleLogs(Context ctx) {
        ctx.status(200);
        List<WebSocketLogEntryDTO> list = JListAppender.ringDeque.stream().map(e -> new WebSocketLogEntryDTO(e.time(), e.thread(), e.level().name(), e.content(), e.seq())).toList();
        ctx.json((Object)new StdResp(true, null, list));
    }

    @Override
    public void onDisable() {
        Main.getEventBus().unregister((Object)this);
    }
}

