/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.module.impl.webapi;

import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.module.AbstractFeatureModule;
import com.ghostchu.peerbanhelper.module.impl.webapi.body.LicenseDeleteBody;
import com.ghostchu.peerbanhelper.module.impl.webapi.body.LicensePutRequestBody;
import com.ghostchu.peerbanhelper.module.impl.webapi.body.PowCaptchaBody;
import com.ghostchu.peerbanhelper.module.impl.webapi.dto.LicenseKeyPairDTO;
import com.ghostchu.peerbanhelper.module.impl.webapi.dto.PBHPlusStatusDTO;
import com.ghostchu.peerbanhelper.module.impl.webapi.dto.PowCaptchaData;
import com.ghostchu.peerbanhelper.pbhplus.LicenseDownloader;
import com.ghostchu.peerbanhelper.pbhplus.LicenseManager;
import com.ghostchu.peerbanhelper.pbhplus.bean.License;
import com.ghostchu.peerbanhelper.pbhplus.bean.V1License;
import com.ghostchu.peerbanhelper.pbhplus.bean.V2License;
import com.ghostchu.peerbanhelper.pbhplus.data.LicenseStatus;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.util.pow.PoWServer;
import com.ghostchu.peerbanhelper.web.JavalinWebContainer;
import com.ghostchu.peerbanhelper.web.Role;
import com.ghostchu.peerbanhelper.web.wrapper.StdResp;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.javalin.Javalin;
import io.javalin.http.Context;
import io.javalin.security.RouteRole;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class PBHPlusController
extends AbstractFeatureModule {
    @Autowired
    private JavalinWebContainer webContainer;
    @Autowired
    private LicenseManager licenseManager;
    @Autowired
    private LicenseDownloader licenseDownloader;
    private final Cache<String, PoWServer> powCaptcha = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build();
    private final int powCaptchaDifficultyBits = 5;
    private final String powCaptchaAlgorithm = "SHA-1";

    @Override
    public boolean isConfigurable() {
        return false;
    }

    @Override
    @NotNull
    public String getName() {
        return "WebAPI - PBH Plus Interface";
    }

    @Override
    @NotNull
    public String getConfigName() {
        return "webapi-pbh-plus";
    }

    @Override
    public void onEnable() {
        ((Javalin)((Javalin)((Javalin)((Javalin)this.webContainer.javalin().get("/api/pbhplus/status", this::handleStatus, new RouteRole[]{Role.USER_READ})).put("/api/pbhplus/key", this::handleLicensePut, new RouteRole[]{Role.USER_WRITE})).delete("/api/pbhplus/key", this::handleLicenseDelete, new RouteRole[]{Role.USER_WRITE})).get("/api/pbhplus/claimRenewFreeLicenseCaptcha", this::claimRenewFreeLicenseCaptcha, new RouteRole[]{Role.USER_WRITE})).post("/api/pbhplus/renewFreeLicense", this::handleLicenseRenew, new RouteRole[]{Role.USER_WRITE});
    }

    private void claimRenewFreeLicenseCaptcha(@NotNull Context context) {
        PoWServer server = new PoWServer(5, "SHA-1");
        String challengeId = UUID.randomUUID().toString();
        this.powCaptcha.put((Object)challengeId, (Object)server);
        context.json((Object)new StdResp(true, null, new PowCaptchaData(challengeId, Base64.getEncoder().encodeToString(server.getChallenge()), server.getDifficultyBits(), "SHA-1")));
    }

    private void handleLicensePut(@NotNull Context context) throws Exception {
        LicensePutRequestBody body = (LicensePutRequestBody)context.bodyAsClass(LicensePutRequestBody.class);
        String input = body.key().trim();
        this.processLicensePut(context, input, false);
    }

    private void processLicensePut(Context context, String input, boolean selfCall) throws Exception {
        try {
            License license = this.licenseManager.getLicenseParser().fromLicense(input);
            LicenseStatus status = this.licenseManager.getLicenseBackend().getLicenseStatus(license);
            switch (status) {
                case EXPIRED: {
                    context.json((Object)new StdResp(false, TextManager.tlUI(Lang.PBH_LICENSE_KEY_EXPIRED, new Object[0]), null));
                    break;
                }
                case REVOKED: {
                    context.json((Object)new StdResp(false, TextManager.tlUI(Lang.PBH_LICENSE_KEY_REVOKED, new Object[0]), null));
                    break;
                }
                case VALID: 
                case NOT_STARTED: {
                    List keyList = Main.getMainConfig().getStringList("pbh-plus-key");
                    if (!keyList.contains(input)) {
                        keyList.add(input);
                    }
                    Main.getMainConfig().set("pbh-plus-key", (Object)keyList);
                    Main.getMainConfig().save(Main.getMainConfigFile());
                    this.licenseManager.reloadModule();
                    context.json((Object)new StdResp(true, TextManager.tlUI(Lang.PBH_PLUS_LICENSE_UPDATED, new Object[0]), null));
                    break;
                }
                default: {
                    context.json((Object)new StdResp(false, TextManager.tlUI(Lang.PBH_LICENSE_PARSE_FAILED, new Object[0]), null));
                    break;
                }
            }
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            String downloadedLicense;
            if (!selfCall && (downloadedLicense = this.licenseDownloader.attemptDownloadFromServer(input)) != null) {
                this.processLicensePut(context, downloadedLicense, true);
                return;
            }
            context.json((Object)new StdResp(false, TextManager.tlUI(Lang.PBH_LICENSE_PARSE_FAILED, new Object[0]), null));
        }
    }

    private void handleLicenseRenew(@NotNull Context context) throws Exception {
        PowCaptchaBody body = (PowCaptchaBody)context.bodyAsClass(PowCaptchaBody.class);
        PoWServer captchaServer = (PoWServer)this.powCaptcha.getIfPresent((Object)body.getCaptchaId());
        if (captchaServer == null) {
            context.json((Object)new StdResp(false, TextManager.tlUI(Lang.POW_CAPTCHA_SERVER_NOT_FOUND, new Object[0]), null));
            return;
        }
        if (!captchaServer.verify(Base64.getDecoder().decode(body.getCaptchaNonce()))) {
            context.json((Object)new StdResp(false, TextManager.tlUI(Lang.POW_CAPTCHA_SERVER_VERIFY_FAILED, new Object[0]), null));
            return;
        }
        if (this.licenseManager.isFeatureEnabled("basic")) {
            context.json((Object)new StdResp(false, TextManager.tlUI(Lang.PBH_PLUS_FREE_LICENSE_DENIED_EXISTS, new Object[0]), null));
            return;
        }
        String local = this.licenseManager.getLicenseParser().generateLocalLicense();
        List keyList = Main.getMainConfig().getStringList("pbh-plus-key");
        if (!keyList.contains(local)) {
            keyList.add(local);
            Main.getMainConfig().set("pbh-plus-key", (Object)keyList);
            Main.getMainConfig().save(Main.getMainConfigFile());
        }
        this.licenseManager.reloadModule();
        context.json((Object)new StdResp(true, TextManager.tlUI(Lang.PBH_PLUS_LICENSE_UPDATED, new Object[0]), null));
    }

    private void handleLicenseDelete(@NotNull Context context) throws Exception {
        String key = ((LicenseDeleteBody)context.bodyAsClass(LicenseDeleteBody.class)).getLicenseId();
        License mappedLicense = this.licenseManager.getLicenseBackend().getLicensesMap().get(key);
        if (this.licenseManager == null) {
            context.json((Object)new StdResp(false, TextManager.tlUI(Lang.PBH_LICENSE_KEY_DELETE_FAILED_NOT_EXISTS, new Object[0]), "Not found mappedLicense"));
            return;
        }
        List keyList = Main.getMainConfig().getStringList("pbh-plus-key");
        if (keyList.remove(mappedLicense.getKeyText())) {
            Main.getMainConfig().set("pbh-plus-key", (Object)keyList);
            Main.getMainConfig().save(Main.getMainConfigFile());
            this.licenseManager.reloadModule();
            context.json((Object)new StdResp(true, TextManager.tlUI(Lang.PBH_LICENSE_KEY_DELETED, new Object[0]), null));
        } else {
            context.json((Object)new StdResp(false, TextManager.tlUI(Lang.PBH_LICENSE_KEY_DELETE_FAILED_NOT_EXISTS, new Object[0]), "Not found target keyText"));
        }
    }

    private void handleStatus(@NotNull Context context) {
        ArrayList<LicenseKeyPairDTO> licenseKeyPairDTOList = new ArrayList<LicenseKeyPairDTO>();
        this.licenseManager.getLicenseBackend().getLicensesMap().forEach((licenseId, license) -> {
            LicenseKeyPairDTO dto = new LicenseKeyPairDTO((String)licenseId, license instanceof V2License ? 2 : (license instanceof V1License ? 1 : -1), this.licenseManager.getLicenseBackend().getLicenseStatus((License)license), (License)license);
            licenseKeyPairDTOList.add(dto);
        });
        context.json((Object)new StdResp(true, null, new PBHPlusStatusDTO(this.licenseManager.getLicenseBackend().getAllFeatures(), licenseKeyPairDTOList)));
    }

    @Override
    public void onDisable() {
    }
}

