/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.module.impl.webapi.dto;

import com.ghostchu.peerbanhelper.databasent.table.HistoryEntity;
import com.ghostchu.peerbanhelper.downloader.DownloaderBasicInfo;
import com.ghostchu.peerbanhelper.downloader.DownloaderManagerImpl;
import com.ghostchu.peerbanhelper.module.impl.webapi.dto.TorrentEntityDTO;
import com.ghostchu.peerbanhelper.text.TextManager;
import java.net.InetAddress;
import java.time.OffsetDateTime;
import lombok.Generated;

public final class BanLogDTO {
    private OffsetDateTime banAt;
    private OffsetDateTime unbanAt;
    private InetAddress peerIp;
    private int peerPort;
    private String peerId;
    private String peerClientName;
    private long peerUploaded;
    private long peerDownloaded;
    private double peerProgress;
    private String torrentInfoHash;
    private String torrentName;
    private long torrentSize;
    private String module;
    private String rule;
    private String description;
    private DownloaderBasicInfo downloader;

    public BanLogDTO(String locale, DownloaderManagerImpl downloaderManager, HistoryEntity history, TorrentEntityDTO torrent) {
        this.banAt = history.getBanAt();
        this.unbanAt = history.getUnbanAt();
        this.peerIp = history.getIp();
        this.peerPort = history.getPort();
        this.peerId = history.getPeerId();
        this.peerClientName = history.getPeerClientName();
        this.peerUploaded = history.getPeerUploaded();
        this.peerDownloaded = history.getPeerDownloaded();
        this.peerProgress = history.getPeerProgress();
        this.torrentInfoHash = torrent.infoHash();
        this.torrentName = torrent.name();
        this.torrentSize = torrent.size();
        this.module = history.getModuleName();
        this.rule = TextManager.tl(locale, history.getRuleName());
        this.description = TextManager.tl(locale, history.getDescription());
        this.downloader = downloaderManager.getDownloadInfo(history.getDownloader());
    }

    @Generated
    public BanLogDTO(OffsetDateTime banAt, OffsetDateTime unbanAt, InetAddress peerIp, int peerPort, String peerId, String peerClientName, long peerUploaded, long peerDownloaded, double peerProgress, String torrentInfoHash, String torrentName, long torrentSize, String module, String rule, String description, DownloaderBasicInfo downloader) {
        this.banAt = banAt;
        this.unbanAt = unbanAt;
        this.peerIp = peerIp;
        this.peerPort = peerPort;
        this.peerId = peerId;
        this.peerClientName = peerClientName;
        this.peerUploaded = peerUploaded;
        this.peerDownloaded = peerDownloaded;
        this.peerProgress = peerProgress;
        this.torrentInfoHash = torrentInfoHash;
        this.torrentName = torrentName;
        this.torrentSize = torrentSize;
        this.module = module;
        this.rule = rule;
        this.description = description;
        this.downloader = downloader;
    }

    @Generated
    public BanLogDTO() {
    }

    @Generated
    public OffsetDateTime getBanAt() {
        return this.banAt;
    }

    @Generated
    public OffsetDateTime getUnbanAt() {
        return this.unbanAt;
    }

    @Generated
    public InetAddress getPeerIp() {
        return this.peerIp;
    }

    @Generated
    public int getPeerPort() {
        return this.peerPort;
    }

    @Generated
    public String getPeerId() {
        return this.peerId;
    }

    @Generated
    public String getPeerClientName() {
        return this.peerClientName;
    }

    @Generated
    public long getPeerUploaded() {
        return this.peerUploaded;
    }

    @Generated
    public long getPeerDownloaded() {
        return this.peerDownloaded;
    }

    @Generated
    public double getPeerProgress() {
        return this.peerProgress;
    }

    @Generated
    public String getTorrentInfoHash() {
        return this.torrentInfoHash;
    }

    @Generated
    public String getTorrentName() {
        return this.torrentName;
    }

    @Generated
    public long getTorrentSize() {
        return this.torrentSize;
    }

    @Generated
    public String getModule() {
        return this.module;
    }

    @Generated
    public String getRule() {
        return this.rule;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public DownloaderBasicInfo getDownloader() {
        return this.downloader;
    }

    @Generated
    public void setBanAt(OffsetDateTime banAt) {
        this.banAt = banAt;
    }

    @Generated
    public void setUnbanAt(OffsetDateTime unbanAt) {
        this.unbanAt = unbanAt;
    }

    @Generated
    public void setPeerIp(InetAddress peerIp) {
        this.peerIp = peerIp;
    }

    @Generated
    public void setPeerPort(int peerPort) {
        this.peerPort = peerPort;
    }

    @Generated
    public void setPeerId(String peerId) {
        this.peerId = peerId;
    }

    @Generated
    public void setPeerClientName(String peerClientName) {
        this.peerClientName = peerClientName;
    }

    @Generated
    public void setPeerUploaded(long peerUploaded) {
        this.peerUploaded = peerUploaded;
    }

    @Generated
    public void setPeerDownloaded(long peerDownloaded) {
        this.peerDownloaded = peerDownloaded;
    }

    @Generated
    public void setPeerProgress(double peerProgress) {
        this.peerProgress = peerProgress;
    }

    @Generated
    public void setTorrentInfoHash(String torrentInfoHash) {
        this.torrentInfoHash = torrentInfoHash;
    }

    @Generated
    public void setTorrentName(String torrentName) {
        this.torrentName = torrentName;
    }

    @Generated
    public void setTorrentSize(long torrentSize) {
        this.torrentSize = torrentSize;
    }

    @Generated
    public void setModule(String module) {
        this.module = module;
    }

    @Generated
    public void setRule(String rule) {
        this.rule = rule;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setDownloader(DownloaderBasicInfo downloader) {
        this.downloader = downloader;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BanLogDTO)) {
            return false;
        }
        BanLogDTO other = (BanLogDTO)o;
        if (this.getPeerPort() != other.getPeerPort()) {
            return false;
        }
        if (this.getPeerUploaded() != other.getPeerUploaded()) {
            return false;
        }
        if (this.getPeerDownloaded() != other.getPeerDownloaded()) {
            return false;
        }
        if (Double.compare(this.getPeerProgress(), other.getPeerProgress()) != 0) {
            return false;
        }
        if (this.getTorrentSize() != other.getTorrentSize()) {
            return false;
        }
        OffsetDateTime this$banAt = this.getBanAt();
        OffsetDateTime other$banAt = other.getBanAt();
        if (this$banAt == null ? other$banAt != null : !((Object)this$banAt).equals(other$banAt)) {
            return false;
        }
        OffsetDateTime this$unbanAt = this.getUnbanAt();
        OffsetDateTime other$unbanAt = other.getUnbanAt();
        if (this$unbanAt == null ? other$unbanAt != null : !((Object)this$unbanAt).equals(other$unbanAt)) {
            return false;
        }
        InetAddress this$peerIp = this.getPeerIp();
        InetAddress other$peerIp = other.getPeerIp();
        if (this$peerIp == null ? other$peerIp != null : !((Object)this$peerIp).equals(other$peerIp)) {
            return false;
        }
        String this$peerId = this.getPeerId();
        String other$peerId = other.getPeerId();
        if (this$peerId == null ? other$peerId != null : !this$peerId.equals(other$peerId)) {
            return false;
        }
        String this$peerClientName = this.getPeerClientName();
        String other$peerClientName = other.getPeerClientName();
        if (this$peerClientName == null ? other$peerClientName != null : !this$peerClientName.equals(other$peerClientName)) {
            return false;
        }
        String this$torrentInfoHash = this.getTorrentInfoHash();
        String other$torrentInfoHash = other.getTorrentInfoHash();
        if (this$torrentInfoHash == null ? other$torrentInfoHash != null : !this$torrentInfoHash.equals(other$torrentInfoHash)) {
            return false;
        }
        String this$torrentName = this.getTorrentName();
        String other$torrentName = other.getTorrentName();
        if (this$torrentName == null ? other$torrentName != null : !this$torrentName.equals(other$torrentName)) {
            return false;
        }
        String this$module = this.getModule();
        String other$module = other.getModule();
        if (this$module == null ? other$module != null : !this$module.equals(other$module)) {
            return false;
        }
        String this$rule = this.getRule();
        String other$rule = other.getRule();
        if (this$rule == null ? other$rule != null : !this$rule.equals(other$rule)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        DownloaderBasicInfo this$downloader = this.getDownloader();
        DownloaderBasicInfo other$downloader = other.getDownloader();
        return !(this$downloader == null ? other$downloader != null : !((Object)this$downloader).equals(other$downloader));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPeerPort();
        long $peerUploaded = this.getPeerUploaded();
        result = result * 59 + (int)($peerUploaded >>> 32 ^ $peerUploaded);
        long $peerDownloaded = this.getPeerDownloaded();
        result = result * 59 + (int)($peerDownloaded >>> 32 ^ $peerDownloaded);
        long $peerProgress = Double.doubleToLongBits(this.getPeerProgress());
        result = result * 59 + (int)($peerProgress >>> 32 ^ $peerProgress);
        long $torrentSize = this.getTorrentSize();
        result = result * 59 + (int)($torrentSize >>> 32 ^ $torrentSize);
        OffsetDateTime $banAt = this.getBanAt();
        result = result * 59 + ($banAt == null ? 43 : ((Object)$banAt).hashCode());
        OffsetDateTime $unbanAt = this.getUnbanAt();
        result = result * 59 + ($unbanAt == null ? 43 : ((Object)$unbanAt).hashCode());
        InetAddress $peerIp = this.getPeerIp();
        result = result * 59 + ($peerIp == null ? 43 : ((Object)$peerIp).hashCode());
        String $peerId = this.getPeerId();
        result = result * 59 + ($peerId == null ? 43 : $peerId.hashCode());
        String $peerClientName = this.getPeerClientName();
        result = result * 59 + ($peerClientName == null ? 43 : $peerClientName.hashCode());
        String $torrentInfoHash = this.getTorrentInfoHash();
        result = result * 59 + ($torrentInfoHash == null ? 43 : $torrentInfoHash.hashCode());
        String $torrentName = this.getTorrentName();
        result = result * 59 + ($torrentName == null ? 43 : $torrentName.hashCode());
        String $module = this.getModule();
        result = result * 59 + ($module == null ? 43 : $module.hashCode());
        String $rule = this.getRule();
        result = result * 59 + ($rule == null ? 43 : $rule.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        DownloaderBasicInfo $downloader = this.getDownloader();
        result = result * 59 + ($downloader == null ? 43 : ((Object)$downloader).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BanLogDTO(banAt=" + String.valueOf(this.getBanAt()) + ", unbanAt=" + String.valueOf(this.getUnbanAt()) + ", peerIp=" + String.valueOf(this.getPeerIp()) + ", peerPort=" + this.getPeerPort() + ", peerId=" + this.getPeerId() + ", peerClientName=" + this.getPeerClientName() + ", peerUploaded=" + this.getPeerUploaded() + ", peerDownloaded=" + this.getPeerDownloaded() + ", peerProgress=" + this.getPeerProgress() + ", torrentInfoHash=" + this.getTorrentInfoHash() + ", torrentName=" + this.getTorrentName() + ", torrentSize=" + this.getTorrentSize() + ", module=" + this.getModule() + ", rule=" + this.getRule() + ", description=" + this.getDescription() + ", downloader=" + String.valueOf(this.getDownloader()) + ")";
    }
}

