/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util;

import java.lang.management.LockInfo;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.text.StringCharacterIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MsgUtil {
    private static final DecimalFormat df = new DecimalFormat("0.00%");
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final SimpleDateFormat stf = new SimpleDateFormat("HH:mm:ss");

    public static String escapeSql(String sql) {
        if (sql == null) {
            return null;
        }
        return sql.replace("'", "''");
    }

    public static String humanReadableByteCountBin(long bytes) {
        long absB;
        long l = absB = bytes == Long.MIN_VALUE ? Long.MAX_VALUE : Math.abs(bytes);
        if (absB < 1024L) {
            return bytes + " B";
        }
        long value = absB;
        StringCharacterIterator ci = new StringCharacterIterator("KMGTPE");
        for (int i = 40; i >= 0 && absB > 0xFFFCCCCCCCCCCCCL >> i; i -= 10) {
            value >>= 10;
            ci.next();
        }
        return String.format("%.1f %ciB", (double)(value *= (long)Long.signum(bytes)) / 1024.0, Character.valueOf(ci.current()));
    }

    public static String humanReadableByteCountSI(long bytes) {
        if (-1000L < bytes && bytes < 1000L) {
            return bytes + " B";
        }
        StringCharacterIterator ci = new StringCharacterIterator("kMGTPE");
        while (bytes <= -999950L || bytes >= 999950L) {
            bytes /= 1000L;
            ci.next();
        }
        return String.format("%.1f %cB", (double)bytes / 1000.0, Character.valueOf(ci.current()));
    }

    public static String threadInfoToString(ThreadInfo info) {
        LockInfo[] locks;
        int i;
        StringBuilder sb = new StringBuilder("\"" + info.getThreadName() + "\"" + (info.isDaemon() ? " daemon" : "") + " prio=" + info.getPriority() + " Id=" + info.getThreadId() + " " + String.valueOf((Object)info.getThreadState()));
        if (info.getLockName() != null) {
            sb.append(" on ").append(info.getLockName());
        }
        if (info.getLockOwnerName() != null) {
            sb.append(" owned by \"").append(info.getLockOwnerName()).append("\" Id=").append(info.getLockOwnerId());
        }
        if (info.isSuspended()) {
            sb.append(" (suspended)");
        }
        if (info.isInNative()) {
            sb.append(" (in native)");
        }
        sb.append('\n');
        for (i = 0; i < info.getStackTrace().length && i < 500; ++i) {
            StackTraceElement ste = info.getStackTrace()[i];
            sb.append("\tat ").append(ste.toString());
            sb.append('\n');
            if (i == 0 && info.getLockInfo() != null) {
                Thread.State ts = info.getThreadState();
                switch (ts) {
                    case BLOCKED: {
                        sb.append("\t-  blocked on ").append(info.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                    case WAITING: 
                    case TIMED_WAITING: {
                        sb.append("\t-  waiting on ").append(info.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                }
            }
            for (LockInfo lockInfo : info.getLockedMonitors()) {
                if (((MonitorInfo)lockInfo).getLockedStackDepth() != i) continue;
                sb.append("\t-  locked ").append(lockInfo);
                sb.append('\n');
            }
        }
        if (i < info.getStackTrace().length) {
            sb.append("\t...");
            sb.append('\n');
        }
        if ((locks = info.getLockedSynchronizers()).length > 0) {
            sb.append("\n\tNumber of locked synchronizers = ").append(locks.length);
            sb.append('\n');
            for (LockInfo lockInfo : locks) {
                sb.append("\t- ").append(lockInfo);
                sb.append('\n');
            }
        }
        sb.append('\n');
        return sb.toString();
    }

    public static DecimalFormat getPercentageFormatter() {
        return df;
    }

    public static SimpleDateFormat getDateFormatter() {
        return sdf;
    }

    public static SimpleDateFormat getTimeFormatter() {
        return stf;
    }

    @NotNull
    public static String fillArgs(@Nullable String raw, String ... args) {
        if (raw == null || raw.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        int start = 0;
        int argIndex = 0;
        while (start < raw.length()) {
            int placeholderIndex = raw.indexOf("{}", start);
            if (placeholderIndex == -1) {
                result.append(raw.substring(start));
                break;
            }
            result.append(raw, start, placeholderIndex);
            if (args != null && argIndex < args.length) {
                result.append(args[argIndex] != null ? args[argIndex] : "");
                ++argIndex;
            } else {
                result.append("{}");
            }
            start = placeholderIndex + 2;
        }
        return result.toString();
    }
}

