/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util;

import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Date;
import org.jetbrains.annotations.NotNull;

public class TimeUtil {
    public static final OffsetDateTime zeroOffsetDateTime = Instant.ofEpochMilli(0L).atOffset(ZoneOffset.UTC);
    public static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final SimpleDateFormat sdfTime = new SimpleDateFormat("HH:mm:ss");
    public static final SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd");

    @NotNull
    public static OffsetDateTime fromMillis(long millis) {
        return Instant.ofEpochMilli(millis).atOffset(ZoneOffset.UTC);
    }

    public static long toMillis(@NotNull OffsetDateTime dateTime) {
        return dateTime.toInstant().toEpochMilli();
    }

    public static String formatDateOnly(long timestamp) {
        return sdfDate.format(new Date(timestamp));
    }

    public static String formatDateTime(long timestamp) {
        return sdf.format(new Date(timestamp));
    }

    public static String formatTimeOnly(long timestamp) {
        return sdfTime.format(new Date(timestamp));
    }

    public static ZoneOffset getSystemZoneOffset() {
        return ZoneId.systemDefault().getRules().getOffset(Instant.now());
    }

    public static OffsetDateTime getStartOfToday(long time) {
        ZoneId systemZone = ZoneId.systemDefault();
        ZoneOffset currentOffsetForMyZone = systemZone.getRules().getOffset(Instant.ofEpochMilli(time));
        LocalDate date = Instant.ofEpochMilli(time).atZone(systemZone).toLocalDate();
        return date.atStartOfDay().atOffset(currentOffsetForMyZone);
    }

    public static OffsetDateTime getStartOfToday(OffsetDateTime time) {
        ZoneId systemZone = ZoneId.systemDefault();
        ZoneOffset currentOffsetForMyZone = systemZone.getRules().getOffset(time.toInstant());
        return time.toLocalDate().atStartOfDay().atOffset(currentOffsetForMyZone);
    }

    public static OffsetDateTime getEndOfToday(long time) {
        ZoneId systemZone = ZoneId.systemDefault();
        ZoneOffset currentOffsetForMyZone = systemZone.getRules().getOffset(Instant.now());
        LocalDateTime dateTime = Instant.ofEpochMilli(time).atZone(systemZone).toLocalDateTime();
        LocalDateTime dayEnd = dateTime.withHour(23).withMinute(59).withSecond(59).withNano(999999999);
        return dayEnd.atOffset(currentOffsetForMyZone);
    }

    public static OffsetDateTime getStartOfHour(long time) {
        ZoneId systemZone = ZoneId.systemDefault();
        ZoneOffset currentOffsetForMyZone = systemZone.getRules().getOffset(Instant.now());
        LocalDateTime dateTime = Instant.ofEpochMilli(time).atZone(systemZone).toLocalDateTime();
        LocalDateTime hourStart = dateTime.withMinute(0).withSecond(0).withNano(0);
        return hourStart.atOffset(currentOffsetForMyZone);
    }
}

