/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util.json;

import com.ghostchu.peerbanhelper.util.TimeUtil;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;

public final class OffsetDateTimeTypeAdapter
implements JsonSerializer<OffsetDateTime>,
JsonDeserializer<OffsetDateTime> {
    public static final OffsetDateTimeTypeAdapter INSTANCE = new OffsetDateTimeTypeAdapter();

    public JsonElement serialize(OffsetDateTime ts, Type t, JsonSerializationContext jsc) {
        return new JsonPrimitive((Number)TimeUtil.toMillis(ts));
    }

    public OffsetDateTime deserialize(JsonElement json, Type t, JsonDeserializationContext jsc) throws JsonParseException {
        if (!(json instanceof JsonPrimitive)) {
            throw new JsonParseException("The date should be a number value");
        }
        return TimeUtil.fromMillis(json.getAsLong());
    }
}

