/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util.lab;

import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.util.lab.Experiment;
import com.ghostchu.peerbanhelper.util.lab.Experiments;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.bspfsystems.yamlconfiguration.file.YamlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class Laboratory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Laboratory.class);
    private final int experimentalGroup;
    private final YamlConfiguration labConfig;
    private final File labConfigFile;
    private static final int LATEST_VERSION = 1;

    public Laboratory() throws IOException {
        String installationId = Main.getMainConfig().getString("installation-id", "???");
        int hashCode = installationId.hashCode();
        this.experimentalGroup = Math.abs(hashCode % 5);
        this.labConfigFile = new File(Main.getConfigDirectory(), "laboratory.yml");
        boolean firstInstall = false;
        if (!this.labConfigFile.exists()) {
            this.labConfigFile.createNewFile();
            firstInstall = true;
        }
        this.labConfig = YamlConfiguration.loadConfiguration((File)this.labConfigFile);
        if (firstInstall) {
            this.setEnabled(true);
            this.setConfigVersion(1);
        }
        this.checkConfigUpdate();
        for (Experiments value : Experiments.values()) {
            this.isExperimentActivated(value.getExperiment());
        }
    }

    private void checkConfigUpdate() {
        int configVersion = this.getConfigVersion();
        if (configVersion >= 1) {
            return;
        }
        if (configVersion == 0) {
            this.setEnabled(true);
            configVersion = 1;
        }
        this.setConfigVersion(configVersion);
    }

    public boolean isExperimentActivated(Experiment experiment) {
        if (!this.isEnabled()) {
            return false;
        }
        String value = this.labConfig.getString(experiment.id());
        if (value == null) {
            this.labConfig.set(experiment.id(), (Object)"default");
            value = "default";
            ArrayList<String> comments = new ArrayList<String>();
            comments.addAll(Arrays.stream(TextManager.tlUI(experiment.title()).split("\n")).toList());
            comments.addAll(Arrays.stream(TextManager.tlUI(experiment.description()).split("\n")).toList());
            this.labConfig.setComments(experiment.id(), comments);
            this.saveLabConfig();
        }
        if ("default".equals(value)) {
            return this.isExperimentalGroup(experiment.group());
        }
        return Boolean.parseBoolean(value);
    }

    public void setExperimentActivated(String id, Boolean activated) throws IllegalArgumentException {
        for (Experiments value : Experiments.values()) {
            if (!value.getExperiment().id().equals(id)) continue;
            this.labConfig.set(value.getExperiment().id(), activated == null ? "default" : activated);
            this.saveLabConfig();
            return;
        }
        throw new IllegalArgumentException("Invalid experiment id: " + id + ", it's not exists in Experiments registry");
    }

    private void saveLabConfig() {
        try {
            this.labConfig.save(this.labConfigFile);
        }
        catch (IOException e) {
            log.info("Unable to save laboratory configuration", (Throwable)e);
        }
    }

    public boolean isExperimentalGroup(List<Integer> group) {
        return group.contains(this.experimentalGroup);
    }

    public void setEnabled(boolean enabled) {
        this.labConfig.set("enabled", (Object)enabled);
        this.saveLabConfig();
    }

    public void setConfigVersion(int version) {
        this.labConfig.set("config-version", (Object)version);
        this.saveLabConfig();
    }

    public int getConfigVersion() {
        return this.labConfig.getInt("config-version", 0);
    }

    public boolean isEnabled() {
        return this.labConfig.getBoolean("enabled");
    }

    @Generated
    public int getExperimentalGroup() {
        return this.experimentalGroup;
    }
}

