/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util.rule.matcher;

import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.util.IPAddressUtil;
import com.ghostchu.peerbanhelper.util.rule.MatchResult;
import com.ghostchu.peerbanhelper.util.rule.MatchResultEnum;
import com.ghostchu.peerbanhelper.util.rule.RuleMatcher;
import inet.ipaddr.IPAddress;
import inet.ipaddr.format.util.AssociativeAddressTrie;
import inet.ipaddr.format.util.DualIPv4v6AssociativeTries;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPMatcher
extends RuleMatcher<DualIPv4v6AssociativeTries<String>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IPMatcher.class);
    private DualIPv4v6AssociativeTries<String> ips;

    public IPMatcher(String ruleId, String ruleName, List<DualIPv4v6AssociativeTries<String>> ruleData) {
        super(ruleId, ruleName, ruleData);
        this.ips = ruleData.getFirst();
    }

    @Override
    public void setData(String ruleName, List<DualIPv4v6AssociativeTries<String>> ruleData) {
        this.setRuleName(ruleName);
        this.ips = ruleData.getFirst();
    }

    public long size() {
        return this.ips.size();
    }

    @Override
    @NotNull
    public MatchResult match0(@NotNull String content) {
        IPAddress ip = IPAddressUtil.getIPAddress(content);
        if (ip == null) {
            return new MatchResult(MatchResultEnum.DEFAULT, new TranslationComponent("IP is null"));
        }
        if (this.ips == null) {
            return new MatchResult(MatchResultEnum.DEFAULT, new TranslationComponent("IPs set is null"));
        }
        AssociativeAddressTrie.AssociativeTrieNode node = this.ips.elementsContaining(ip);
        if (node != null) {
            return new MatchResult(MatchResultEnum.TRUE, new TranslationComponent((String)node.getValue()));
        }
        return new MatchResult(MatchResultEnum.DEFAULT, new TranslationComponent("Given IP not in IPs set"));
    }

    @Override
    public TranslationComponent matcherName() {
        return new TranslationComponent(Lang.RULE_MATCHER_SUB_RULE, this.getRuleName());
    }

    @Override
    public String matcherIdentifier() {
        return "peerbanhelper:ipmatcher";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IPMatcher)) {
            return false;
        }
        IPMatcher other = (IPMatcher)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DualIPv4v6AssociativeTries<String> this$ips = this.ips;
        DualIPv4v6AssociativeTries<String> other$ips = other.ips;
        return !(this$ips == null ? other$ips != null : !this$ips.equals(other$ips));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof IPMatcher;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        DualIPv4v6AssociativeTries<String> $ips = this.ips;
        result = result * 59 + ($ips == null ? 43 : $ips.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "IPMatcher(super=" + super.toString() + ", ips=" + String.valueOf(this.ips) + ")";
    }
}

