/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util.traversal.stun;

import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.util.traversal.stun.MappingResult;
import com.ghostchu.peerbanhelper.util.traversal.stun.StunSocketTool;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpStunClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TcpStunClient.class);
    private final int sourcePort;
    private final List<String> stunServerList;
    private final String sourceHost;
    private int currentServerIndex = 0;

    public TcpStunClient(List<String> stunServerList, String sourceHost, int localPort) {
        if (stunServerList == null || stunServerList.isEmpty()) {
            throw new IllegalArgumentException("STUN server list cannot be empty");
        }
        this.stunServerList = stunServerList;
        this.sourceHost = sourceHost;
        this.sourcePort = localPort;
    }

    public MappingResult getMapping() {
        String firstServer = this.stunServerList.getFirst();
        while (true) {
            try {
                return this.getMappingFromServer();
            }
            catch (Exception e) {
                this.currentServerIndex = (this.currentServerIndex + 1) % this.stunServerList.size();
                if (!this.stunServerList.get(this.currentServerIndex).equals(firstServer)) continue;
                log.error(TextManager.tlUI(Lang.STUN_CLIENT_NO_AVAILABLE_SERVER, new Object[0]), this.stunServerList, (Object)e);
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException("Application is closing");
                }
            }
        }
    }

    private String getCurrentServer() {
        return this.stunServerList.get(this.currentServerIndex);
    }

    private MappingResult getMappingFromServer() throws IOException {
        String serverStr = this.getCurrentServer();
        String[] parts = serverStr.split(":");
        String stunHost = parts[0];
        int stunPort = parts.length > 1 ? Integer.parseInt(parts[1]) : 3478;
        return this.getMappingTcp(stunHost, stunPort);
    }

    private MappingResult getMappingTcp(String stunHost, int stunPort) throws IOException {
        MappingResult mappingResult;
        block9: {
            Socket socket = StunSocketTool.getSocket();
            try {
                socket.setReuseAddress(true);
                socket.bind(new InetSocketAddress(this.sourceHost, this.sourcePort));
                socket.connect(new InetSocketAddress(stunHost, stunPort));
                InetSocketAddress innerAddr = (InetSocketAddress)socket.getLocalSocketAddress();
                byte[] request = this.createStunBindingRequest();
                socket.getOutputStream().write(request);
                socket.getOutputStream().flush();
                byte[] buffer = new byte[1500];
                int bytesRead = socket.getInputStream().read(buffer);
                if (bytesRead < 20) {
                    throw new ServerUnavailable("Invalid STUN response length", null);
                }
                InetSocketAddress outerAddr = this.parseStunResponse(buffer, bytesRead);
                log.debug("STUN TCP: outer={}, inner={}, stunHost={}, stunPort={}", new Object[]{outerAddr, innerAddr, stunHost, stunPort});
                mappingResult = new MappingResult(innerAddr, outerAddr);
                if (socket == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (socket != null) {
                        try {
                            socket.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ServerUnavailable("STUN server unavailable: " + e.getMessage(), e);
                }
            }
            socket.close();
        }
        return mappingResult;
    }

    private byte[] createStunBindingRequest() {
        ByteBuffer buffer = ByteBuffer.allocate(20);
        buffer.putShort((short)1);
        buffer.putShort((short)0);
        buffer.putInt(554869826);
        buffer.putInt(1312904274);
        buffer.putInt(ThreadLocalRandom.current().nextInt());
        buffer.putInt(ThreadLocalRandom.current().nextInt());
        return buffer.array();
    }

    private InetSocketAddress parseStunResponse(byte[] buffer, int length) throws IOException {
        if (length < 20) {
            throw new IOException("Invalid STUN response length");
        }
        ByteBuffer buf = ByteBuffer.wrap(buffer, 0, length);
        short messageType = buf.getShort();
        if (messageType != 257) {
            throw new IOException("Invalid STUN response type: " + Integer.toHexString(messageType));
        }
        buf.getShort();
        int magicCookie = buf.getInt();
        if (magicCookie != 554869826) {
            throw new IOException("Invalid magic cookie");
        }
        buf.position(20);
        String ip = null;
        int port = 0;
        while (buf.remaining() >= 4) {
            short attrType = buf.getShort();
            short attrLength = buf.getShort();
            if (attrType == 1 || attrType == 32) {
                if (attrLength >= 8) {
                    buf.get();
                    byte family = buf.get();
                    if (family != 1) continue;
                    short portValue = buf.getShort();
                    int ipValue = buf.getInt();
                    if (attrType == 32) {
                        portValue = (short)(portValue ^ 0x2112);
                        ipValue ^= 0x2112A442;
                    }
                    port = portValue & 0xFFFF;
                    ip = String.format("%d.%d.%d.%d", ipValue >>> 24 & 0xFF, ipValue >>> 16 & 0xFF, ipValue >>> 8 & 0xFF, ipValue & 0xFF);
                    break;
                }
                buf.position(buf.position() + attrLength);
                continue;
            }
            buf.position(buf.position() + attrLength);
            int padding = (4 - attrLength % 4) % 4;
            buf.position(buf.position() + padding);
        }
        if (ip == null || port == 0) {
            throw new IOException("No mapped address found in STUN response");
        }
        return new InetSocketAddress(ip, port);
    }

    public static class ServerUnavailable
    extends IOException {
        public ServerUnavailable(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

