/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util.traversal.stun.tunnel;

import com.ghostchu.peerbanhelper.ExternalSwitch;
import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.util.MiscUtil;
import com.ghostchu.peerbanhelper.util.portmapper.PBHPortMapper;
import com.ghostchu.peerbanhelper.util.portmapper.Protocol;
import com.ghostchu.peerbanhelper.util.traversal.stun.MappingResult;
import com.ghostchu.peerbanhelper.util.traversal.stun.StunListener;
import com.ghostchu.peerbanhelper.util.traversal.stun.StunSocketTool;
import com.ghostchu.peerbanhelper.util.traversal.stun.TcpStunClient;
import com.ghostchu.peerbanhelper.util.traversal.stun.tunnel.StunTcpTunnel;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.StandardSocketOptions;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StunTcpTunnelImpl
implements StunTcpTunnel {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StunTcpTunnelImpl.class);
    private final StunListener stunListener;
    private final ScheduledExecutorService keepAliveService = Executors.newScheduledThreadPool(1, runnable -> Thread.ofVirtual().name("StunTcpTunnel-KeepAlive").unstarted(runnable));
    private final AtomicBoolean valid = new AtomicBoolean(false);
    private final PBHPortMapper pbhPortMapper;
    private final String testHost;
    private Socket keepAliveSocket;
    private long startedAt;
    private long lastSuccessHeartbeatAt;
    private int keepAliveConsecutiveFailures = 0;
    private int localPort;

    public StunTcpTunnelImpl(PBHPortMapper pbhPortMapper, StunListener stunListener) {
        this.pbhPortMapper = pbhPortMapper;
        this.stunListener = stunListener;
        this.testHost = ExternalSwitch.parse("pbh.stunTcpTunnel.testHost", "qq.com");
    }

    @Override
    public void createMapping(int localPort) {
        this.startedAt = System.currentTimeMillis();
        if (localPort == 0) {
            localPort = MiscUtil.randomAvailablePort();
        }
        this.localPort = localPort;
        this.pbhPortMapper.mapPort(localPort, Protocol.TCP, "PeerBanHelper STUN Hole Puncher (TCP/" + localPort + ")").join();
        TcpStunClient tcpStunClient = new TcpStunClient(Main.getMainConfig().getStringList("stun.tcp-servers"), "0.0.0.0", localPort);
        MappingResult mappingResult = tcpStunClient.getMapping();
        InetSocketAddress interResult = mappingResult.interAddress();
        InetSocketAddress outerResult = mappingResult.outerAddress();
        log.debug("STUN CreateMapping: Inter address: {}, Outer address: {}", (Object)interResult, (Object)outerResult);
        try {
            boolean testPass;
            if (Main.getMainConfig().getBoolean("stun.available-test", true) && !(testPass = this.testMapping(interResult, outerResult))) {
                this.stunListener.onNotApplicable(new TranslationComponent(Lang.AUTOSTUN_DOWNLOADER_TUNNEL_TEST_FAILED));
                return;
            }
            this.valid.set(true);
            this.startNATHolder(interResult.getHostString(), interResult.getPort());
            this.stunListener.onCreate(interResult, outerResult);
        }
        catch (IOException e) {
            log.error("Failed to test mapping with outer address: {}", (Object)outerResult, (Object)e);
            this.stunListener.onClose(e);
        }
    }

    private boolean testMapping(InetSocketAddress interResult, InetSocketAddress outerResult) throws IOException {
        HttpServer httpServer = HttpServer.create(interResult, 0);
        httpServer.createContext("/test", exchange -> {
            exchange.sendResponseHeaders(204, -1L);
            exchange.close();
        });
        httpServer.start();
        try {
            Socket httpSocket;
            block10: {
                boolean bl;
                httpSocket = new Socket();
                try {
                    httpSocket.connect(outerResult, 5000);
                    String request = "GET /test HTTP/1.1\r\nHost: " + interResult.getHostString() + "\r\nConnection: close\r\n\r\n";
                    httpSocket.getOutputStream().write(request.getBytes());
                    httpSocket.getOutputStream().flush();
                    byte[] buffer = new byte[1024];
                    int bytesRead = httpSocket.getInputStream().read(buffer);
                    if (bytesRead <= 0) break block10;
                    String response = new String(buffer, 0, bytesRead);
                    log.debug("Received response: {}", (Object)response);
                    bl = response.contains("204");
                }
                catch (Throwable throwable) {
                    try {
                        httpSocket.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                httpSocket.close();
                return bl;
            }
            log.warn("No response received from the test mapping request.");
            boolean bl = false;
            httpSocket.close();
            return bl;
        }
        finally {
            httpServer.stop(0);
        }
    }

    @Override
    public boolean isValid() {
        return this.valid.get();
    }

    @Override
    public long getLastSuccessHeartbeatAt() {
        return this.lastSuccessHeartbeatAt;
    }

    @Override
    public long getStartedAt() {
        return this.startedAt;
    }

    private void startNATHolder(String keepAliveHost, int keepAlivePort) {
        this.keepAliveService.scheduleAtFixedRate(() -> this.keepAliveNATTunnel(keepAliveHost, keepAlivePort), 1L, 10L, TimeUnit.SECONDS);
    }

    private void keepAliveNATTunnel(String keepAliveHost, int keepAlivePort) {
        block6: {
            try {
                Socket socket = this.getKeepAliveSocket(keepAliveHost, keepAlivePort);
                socket.getOutputStream().write(("HEAD / HTTP/1.1\r\nHost: " + this.testHost + "\r\nUser-Agent: PeerBanHelper-NAT-Keeper/1.0\r\nConnection: keep-alive\r\n\r\n").getBytes());
                socket.getOutputStream().flush();
                byte[] buffer = new byte[1024];
                int bytesRead = socket.getInputStream().read(buffer);
                if (bytesRead > 0) {
                    String string = new String(buffer, 0, bytesRead);
                }
                this.lastSuccessHeartbeatAt = System.currentTimeMillis();
                this.keepAliveConsecutiveFailures = 0;
            }
            catch (IOException e) {
                int maxAllowedRetries = ExternalSwitch.parseInt("pbh.stunTcpTunnel.maxKeepAliveFailures", 5);
                ++this.keepAliveConsecutiveFailures;
                log.warn(TextManager.tlUI(Lang.AUTOSTUN_KEEP_ALIVE_FAILED_RETRYING, keepAliveHost + ":" + keepAlivePort, this.keepAliveConsecutiveFailures, maxAllowedRetries, e.getMessage()));
                if (this.keepAliveSocket != null) {
                    try {
                        this.keepAliveSocket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.keepAliveSocket = null;
                }
                if (this.keepAliveConsecutiveFailures < maxAllowedRetries) break block6;
                log.error(TextManager.tlUI(Lang.AUTOSTUN_KEEP_ALIVE_FAILED_TOO_MANY_FAILS, keepAliveHost + ":" + keepAlivePort));
                this.valid.set(false);
                this.stunListener.onClose(new IOException(TextManager.tlUI(Lang.AUTOSTUN_KEEP_ALIVE_FAILED_TOO_MANY_FAILS_CLOSE_REASON, new Object[0])));
            }
        }
    }

    private Socket getKeepAliveSocket(String keepAliveHost, int keepAlivePort) throws IOException {
        if (this.keepAliveSocket != null && this.keepAliveSocket.isConnected() && !this.keepAliveSocket.isClosed()) {
            return this.keepAliveSocket;
        }
        this.keepAliveSocket = StunSocketTool.getSocket();
        log.debug("Creating keep-alive socket for NAT traversal keep-alive from {}:{}", (Object)keepAliveHost, (Object)keepAlivePort);
        this.keepAliveSocket.bind(new InetSocketAddress(keepAliveHost, keepAlivePort));
        if (this.keepAliveSocket.supportedOptions().contains(StandardSocketOptions.SO_REUSEPORT)) {
            this.keepAliveSocket.setOption(StandardSocketOptions.SO_REUSEPORT, true);
        }
        if (this.keepAliveSocket.supportedOptions().contains(StandardSocketOptions.SO_REUSEADDR)) {
            this.keepAliveSocket.setOption(StandardSocketOptions.SO_REUSEADDR, true);
        }
        this.keepAliveSocket.connect(new InetSocketAddress(this.testHost, 80), 1000);
        return this.keepAliveSocket;
    }

    @Override
    public void close() {
        this.valid.set(false);
        this.keepAliveService.close();
        this.stunListener.onClose(null);
        if (this.localPort > 0) {
            this.pbhPortMapper.unmapPort(this.localPort, Protocol.TCP);
        }
        if (this.keepAliveSocket != null && !this.keepAliveSocket.isClosed()) {
            try {
                this.keepAliveSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

