/*
 * Decompiled with CFR 0.152.
 */
package raccoonfink.deluge.responses;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import raccoonfink.deluge.DelugeException;
import raccoonfink.deluge.Host;
import raccoonfink.deluge.responses.DelugeResponse;

public final class HostResponse
extends DelugeResponse {
    private final List<Host> m_hosts = new ArrayList<Host>();

    public HostResponse(Integer httpResponseCode, JsonObject response, boolean singleResult) throws DelugeException {
        super(httpResponseCode, response);
        if (!response.has("result")) {
            throw new DelugeException("Missing 'result' field in JSON response");
        }
        JsonArray result = response.getAsJsonArray("result");
        if (singleResult) {
            this.m_hosts.add(this.getHost(result));
        } else {
            for (JsonElement element : result) {
                JsonArray host = element.getAsJsonArray();
                this.m_hosts.add(this.getHost(host));
            }
        }
    }

    public List<Host> getHosts() {
        return Collections.unmodifiableList(this.m_hosts);
    }

    private Host getHost(JsonArray host) {
        String id = host.get(0).getAsString();
        String hostname = host.get(1).getAsString();
        int port = host.get(2).getAsInt();
        String status = host.get(3).getAsString();
        String version = host.size() > 4 ? host.get(4).getAsString() : null;
        return new Host(id, hostname, port, status, version);
    }

    @Override
    public JsonObject toResponseJSON() {
        JsonObject ret = super.toResponseJSON();
        JsonArray resultArray = new JsonArray();
        for (Host host : this.m_hosts) {
            resultArray.add((JsonElement)host.toJSON());
        }
        ret.add("result", (JsonElement)resultArray);
        return ret;
    }
}

