/*
 * Decompiled with CFR 0.152.
 */
package com.maxmind.geoip2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.maxmind.db.MaxMindDbConstructor;
import com.maxmind.db.MaxMindDbIpAddress;
import com.maxmind.db.MaxMindDbNetwork;
import com.maxmind.db.MaxMindDbParameter;
import com.maxmind.db.Network;
import com.maxmind.geoip2.JsonSerializable;
import com.maxmind.geoip2.NetworkDeserializer;
import java.net.InetAddress;
import java.time.LocalDate;

public record AnonymousPlusResponse(@JsonProperty(value="ip_address") InetAddress ipAddress, @JsonProperty(value="is_anonymous") @MaxMindDbParameter(name="is_anonymous", useDefault=true) boolean isAnonymous, @JsonProperty(value="is_anonymous_vpn") @MaxMindDbParameter(name="is_anonymous_vpn", useDefault=true) boolean isAnonymousVpn, @JsonProperty(value="is_hosting_provider") @MaxMindDbParameter(name="is_hosting_provider", useDefault=true) boolean isHostingProvider, @JsonProperty(value="is_public_proxy") @MaxMindDbParameter(name="is_public_proxy", useDefault=true) boolean isPublicProxy, @JsonProperty(value="is_residential_proxy") @MaxMindDbParameter(name="is_residential_proxy", useDefault=true) boolean isResidentialProxy, @JsonProperty(value="is_tor_exit_node") @MaxMindDbParameter(name="is_tor_exit_node", useDefault=true) boolean isTorExitNode, @JsonProperty(value="network") @JsonDeserialize(using=NetworkDeserializer.class) Network network, @JsonProperty(value="anonymizer_confidence") @MaxMindDbParameter(name="anonymizer_confidence") Integer anonymizerConfidence, @JsonProperty(value="network_last_seen") @MaxMindDbParameter(name="network_last_seen") LocalDate networkLastSeen, @JsonProperty(value="provider_name") @MaxMindDbParameter(name="provider_name") String providerName) implements JsonSerializable
{
    @MaxMindDbConstructor
    public AnonymousPlusResponse(@MaxMindDbIpAddress InetAddress ipAddress, @MaxMindDbParameter(name="is_anonymous", useDefault=true) boolean isAnonymous, @MaxMindDbParameter(name="is_anonymous_vpn", useDefault=true) boolean isAnonymousVpn, @MaxMindDbParameter(name="is_hosting_provider", useDefault=true) boolean isHostingProvider, @MaxMindDbParameter(name="is_public_proxy", useDefault=true) boolean isPublicProxy, @MaxMindDbParameter(name="is_residential_proxy", useDefault=true) boolean isResidentialProxy, @MaxMindDbParameter(name="is_tor_exit_node", useDefault=true) boolean isTorExitNode, @MaxMindDbNetwork Network network, @MaxMindDbParameter(name="anonymizer_confidence") Integer anonymizerConfidence, @MaxMindDbParameter(name="network_last_seen") String networkLastSeen, @MaxMindDbParameter(name="provider_name") String providerName) {
        this(ipAddress, isAnonymous, isAnonymousVpn, isHostingProvider, isPublicProxy, isResidentialProxy, isTorExitNode, network, anonymizerConfidence, networkLastSeen != null ? LocalDate.parse(networkLastSeen) : null, providerName);
    }

    @Deprecated(since="5.0.0", forRemoval=true)
    @JsonProperty(value="ip_address")
    public String getIpAddress() {
        return this.ipAddress().getHostAddress();
    }

    @Deprecated(since="5.0.0", forRemoval=true)
    @JsonProperty
    @JsonSerialize(using=ToStringSerializer.class)
    public Network getNetwork() {
        return this.network();
    }

    @Deprecated(since="5.0.0", forRemoval=true)
    @JsonProperty
    public Integer getAnonymizerConfidence() {
        return this.anonymizerConfidence();
    }

    @Deprecated(since="5.0.0", forRemoval=true)
    @JsonProperty
    public LocalDate getNetworkLastSeen() {
        return this.networkLastSeen();
    }

    @Deprecated(since="5.0.0", forRemoval=true)
    @JsonProperty
    public String getProviderName() {
        return this.providerName();
    }
}

