/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonSerializable;
import io.sentry.JsonUnknown;
import io.sentry.ObjectReader;
import io.sentry.ObjectWriter;
import io.sentry.SentryLevel;
import io.sentry.SentryMetricsEvent;
import io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SentryMetricsEvents
implements JsonUnknown,
JsonSerializable {
    @NotNull
    private List<SentryMetricsEvent> items;
    @Nullable
    private Map<String, Object> unknown;

    public SentryMetricsEvents(@NotNull List<SentryMetricsEvent> items) {
        this.items = items;
    }

    @NotNull
    public List<SentryMetricsEvent> getItems() {
        return this.items;
    }

    @Override
    public void serialize(@NotNull ObjectWriter writer, @NotNull ILogger logger) throws IOException {
        writer.beginObject();
        writer.name("items").value(logger, this.items);
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value = this.unknown.get(key);
                writer.name(key).value(logger, value);
            }
        }
        writer.endObject();
    }

    @Override
    @Nullable
    public Map<String, Object> getUnknown() {
        return this.unknown;
    }

    @Override
    public void setUnknown(@Nullable Map<String, Object> unknown) {
        this.unknown = unknown;
    }

    public static final class JsonKeys {
        public static final String ITEMS = "items";
    }

    public static final class Deserializer
    implements JsonDeserializer<SentryMetricsEvents> {
        @Override
        @NotNull
        public SentryMetricsEvents deserialize(@NotNull ObjectReader reader, @NotNull ILogger logger) throws Exception {
            @Nullable HashMap<String, Object> unknown = null;
            List<SentryMetricsEvent> items = null;
            reader.beginObject();
            block6: while (reader.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "items": {
                        items = reader.nextListOrNull(logger, new SentryMetricsEvent.Deserializer());
                        continue block6;
                    }
                }
                if (unknown == null) {
                    unknown = new HashMap<String, Object>();
                }
                reader.nextUnknown(logger, unknown, nextName);
            }
            reader.endObject();
            if (items == null) {
                String message = "Missing required field \"items\"";
                IllegalStateException exception = new IllegalStateException("Missing required field \"items\"");
                logger.log(SentryLevel.ERROR, "Missing required field \"items\"", exception);
                throw exception;
            }
            SentryMetricsEvents metricsEvent = new SentryMetricsEvents(items);
            metricsEvent.setUnknown(unknown);
            return metricsEvent;
        }
    }
}

