/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.metrics;

import io.sentry.HostnameCache;
import io.sentry.IScope;
import io.sentry.ISpan;
import io.sentry.PropagationContext;
import io.sentry.Scopes;
import io.sentry.SentryAttribute;
import io.sentry.SentryAttributeType;
import io.sentry.SentryAttributes;
import io.sentry.SentryDate;
import io.sentry.SentryLevel;
import io.sentry.SentryLogEventAttributeValue;
import io.sentry.SentryMetricsEvent;
import io.sentry.SentryOptions;
import io.sentry.SpanId;
import io.sentry.metrics.IMetricsApi;
import io.sentry.metrics.SentryMetricsParameters;
import io.sentry.protocol.SdkVersion;
import io.sentry.protocol.SentryId;
import io.sentry.protocol.User;
import io.sentry.util.Platform;
import io.sentry.util.TracingUtils;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MetricsApi
implements IMetricsApi {
    @NotNull
    private final Scopes scopes;

    public MetricsApi(@NotNull Scopes scopes) {
        this.scopes = scopes;
    }

    @Override
    public void count(@NotNull String name) {
        this.captureMetrics(SentryMetricsParameters.create(null, null), name, "counter", 1.0, null);
    }

    @Override
    public void count(@NotNull String name, @Nullable Double value) {
        this.captureMetrics(SentryMetricsParameters.create(null, null), name, "counter", value, null);
    }

    @Override
    public void count(@NotNull String name, @Nullable String unit) {
        this.captureMetrics(SentryMetricsParameters.create(null, null), name, "counter", 1.0, unit);
    }

    @Override
    public void count(@NotNull String name, @Nullable Double value, @Nullable String unit) {
        this.captureMetrics(SentryMetricsParameters.create(null, null), name, "counter", value, unit);
    }

    @Override
    public void count(@NotNull String name, @Nullable Double value, @Nullable String unit, @NotNull SentryMetricsParameters params) {
        this.captureMetrics(params, name, "counter", value, unit);
    }

    @Override
    public void distribution(@NotNull String name, @Nullable Double value) {
        this.captureMetrics(SentryMetricsParameters.create(null, null), name, "distribution", value, null);
    }

    @Override
    public void distribution(@NotNull String name, @Nullable Double value, @Nullable String unit) {
        this.captureMetrics(SentryMetricsParameters.create(null, null), name, "distribution", value, unit);
    }

    @Override
    public void distribution(@NotNull String name, @Nullable Double value, @Nullable String unit, @NotNull SentryMetricsParameters params) {
        this.captureMetrics(params, name, "distribution", value, unit);
    }

    @Override
    public void gauge(@NotNull String name, @Nullable Double value) {
        this.captureMetrics(SentryMetricsParameters.create(null, null), name, "gauge", value, null);
    }

    @Override
    public void gauge(@NotNull String name, @Nullable Double value, @Nullable String unit) {
        this.captureMetrics(SentryMetricsParameters.create(null, null), name, "gauge", value, unit);
    }

    @Override
    public void gauge(@NotNull String name, @Nullable Double value, @Nullable String unit, @NotNull SentryMetricsParameters params) {
        this.captureMetrics(params, name, "gauge", value, unit);
    }

    private void captureMetrics(@NotNull SentryMetricsParameters params, @Nullable String name, @Nullable String type, @Nullable Double value, @Nullable String unit) {
        @NotNull SentryOptions options = this.scopes.getOptions();
        try {
            if (!this.scopes.isEnabled()) {
                options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'metrics' call is a no-op.", new Object[0]);
                return;
            }
            if (!options.getMetrics().isEnabled()) {
                options.getLogger().log(SentryLevel.WARNING, "Sentry Metrics is disabled and this 'metrics' call is a no-op.", new Object[0]);
                return;
            }
            if (name == null) {
                return;
            }
            if (type == null) {
                return;
            }
            if (value == null) {
                return;
            }
            @Nullable SentryDate timestamp = params.getTimestamp();
            @NotNull SentryDate timestampToUse = timestamp == null ? options.getDateProvider().now() : timestamp;
            @NotNull IScope combinedScope = this.scopes.getCombinedScopeView();
            @NotNull PropagationContext propagationContext = combinedScope.getPropagationContext();
            @Nullable ISpan span = combinedScope.getSpan();
            if (span == null) {
                TracingUtils.maybeUpdateBaggage(combinedScope, options);
            }
            @NotNull SentryId traceId = span == null ? propagationContext.getTraceId() : span.getSpanContext().getTraceId();
            @NotNull SpanId spanId = span == null ? propagationContext.getSpanId() : span.getSpanContext().getSpanId();
            SentryMetricsEvent metricsEvent = new SentryMetricsEvent(traceId, timestampToUse, name, type, value);
            metricsEvent.setSpanId(spanId);
            metricsEvent.setUnit(unit);
            metricsEvent.setAttributes(this.createAttributes(params));
            this.scopes.getClient().captureMetric(metricsEvent, combinedScope, params.getHint());
        }
        catch (Throwable e) {
            options.getLogger().log(SentryLevel.ERROR, "Error while capturing metrics event", e);
        }
    }

    @NotNull
    private HashMap<String, SentryLogEventAttributeValue> createAttributes(@NotNull SentryMetricsParameters params) {
        SentryId scopeReplayId;
        String environment;
        SdkVersion sdkVersion;
        SentryAttributes incomingAttributes;
        @NotNull HashMap<String, SentryLogEventAttributeValue> attributes = new HashMap<String, SentryLogEventAttributeValue>();
        @NotNull String origin = params.getOrigin();
        if (!"manual".equalsIgnoreCase(origin)) {
            attributes.put("sentry.origin", new SentryLogEventAttributeValue(SentryAttributeType.STRING, (Object)origin));
        }
        if ((incomingAttributes = params.getAttributes()) != null) {
            for (SentryAttribute attribute : incomingAttributes.getAttributes().values()) {
                @Nullable Object value = attribute.getValue();
                @NotNull SentryAttributeType type = attribute.getType() == null ? this.getType(value) : attribute.getType();
                attributes.put(attribute.getName(), new SentryLogEventAttributeValue(type, value));
            }
        }
        if ((sdkVersion = this.scopes.getOptions().getSdkVersion()) != null) {
            attributes.put("sentry.sdk.name", new SentryLogEventAttributeValue(SentryAttributeType.STRING, (Object)sdkVersion.getName()));
            attributes.put("sentry.sdk.version", new SentryLogEventAttributeValue(SentryAttributeType.STRING, (Object)sdkVersion.getVersion()));
        }
        if ((environment = this.scopes.getOptions().getEnvironment()) != null) {
            attributes.put("sentry.environment", new SentryLogEventAttributeValue(SentryAttributeType.STRING, (Object)environment));
        }
        if (!SentryId.EMPTY_ID.equals(scopeReplayId = this.scopes.getCombinedScopeView().getReplayId())) {
            attributes.put("sentry.replay_id", new SentryLogEventAttributeValue(SentryAttributeType.STRING, (Object)scopeReplayId.toString()));
        } else {
            @NotNull SentryId controllerReplayId = this.scopes.getOptions().getReplayController().getReplayId();
            if (!SentryId.EMPTY_ID.equals(controllerReplayId)) {
                attributes.put("sentry.replay_id", new SentryLogEventAttributeValue(SentryAttributeType.STRING, (Object)controllerReplayId.toString()));
                attributes.put("sentry._internal.replay_is_buffering", new SentryLogEventAttributeValue(SentryAttributeType.BOOLEAN, (Object)true));
            }
        }
        @Nullable String release = this.scopes.getOptions().getRelease();
        if (release != null) {
            attributes.put("sentry.release", new SentryLogEventAttributeValue(SentryAttributeType.STRING, (Object)release));
        }
        if (Platform.isJvm()) {
            this.setServerName(attributes);
        }
        if (this.scopes.getOptions().isSendDefaultPii()) {
            this.setUser(attributes);
        }
        return attributes;
    }

    private void setServerName(@NotNull HashMap<String, SentryLogEventAttributeValue> attributes) {
        String hostname;
        @NotNull SentryOptions options = this.scopes.getOptions();
        @Nullable String optionsServerName = options.getServerName();
        if (optionsServerName != null) {
            attributes.put("server.address", new SentryLogEventAttributeValue(SentryAttributeType.STRING, (Object)optionsServerName));
        } else if (options.isAttachServerName() && (hostname = HostnameCache.getInstance().getHostname()) != null) {
            attributes.put("server.address", new SentryLogEventAttributeValue(SentryAttributeType.STRING, (Object)hostname));
        }
    }

    private void setUser(@NotNull HashMap<String, SentryLogEventAttributeValue> attributes) {
        @Nullable User user = this.scopes.getCombinedScopeView().getUser();
        if (user == null) {
            @Nullable String id = this.scopes.getOptions().getDistinctId();
            if (id != null) {
                attributes.put("user.id", new SentryLogEventAttributeValue(SentryAttributeType.STRING, (Object)id));
            }
        } else {
            String email;
            String username;
            @Nullable String id = user.getId();
            if (id != null) {
                attributes.put("user.id", new SentryLogEventAttributeValue(SentryAttributeType.STRING, (Object)id));
            }
            if ((username = user.getUsername()) != null) {
                attributes.put("user.name", new SentryLogEventAttributeValue(SentryAttributeType.STRING, (Object)username));
            }
            if ((email = user.getEmail()) != null) {
                attributes.put("user.email", new SentryLogEventAttributeValue(SentryAttributeType.STRING, (Object)email));
            }
        }
    }

    @NotNull
    private SentryAttributeType getType(@Nullable Object arg) {
        if (arg instanceof Boolean) {
            return SentryAttributeType.BOOLEAN;
        }
        if (arg instanceof Integer) {
            return SentryAttributeType.INTEGER;
        }
        if (arg instanceof Number) {
            return SentryAttributeType.DOUBLE;
        }
        return SentryAttributeType.STRING;
    }
}

