/*
 * Decompiled with CFR 0.152.
 */
package org.stone.beecp.pool;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.CommonDataSource;
import org.stone.beecp.BeeConnectionFactory;
import org.stone.tools.CommonUtil;

public final class ConnectionFactoryByDriver
implements BeeConnectionFactory,
CommonDataSource {
    private final Driver driver;
    private final Properties properties;
    private String url;

    public ConnectionFactoryByDriver(String url, Driver driver, Properties properties) {
        this.url = url;
        this.driver = driver;
        this.properties = properties;
    }

    @Override
    public Connection create() throws SQLException {
        return this.driver.connect(this.url, this.properties);
    }

    public void setUsername(String username) {
        if (username != null) {
            this.properties.put("user", username);
        } else {
            this.properties.remove("user");
        }
    }

    public void setPassword(String password) {
        if (password != null) {
            this.properties.put("password", password);
        } else {
            this.properties.remove("password");
        }
    }

    public void setUrl(String jdbcUrl) {
        if (CommonUtil.isNotBlank(jdbcUrl)) {
            this.url = jdbcUrl;
        }
    }

    public void setJdbcUrl(String jdbcUrl) {
        if (CommonUtil.isNotBlank(jdbcUrl)) {
            this.url = jdbcUrl;
        }
    }

    @Override
    public PrintWriter getLogWriter() {
        return DriverManager.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) {
        DriverManager.setLogWriter(out);
    }

    @Override
    public int getLoginTimeout() {
        return DriverManager.getLoginTimeout();
    }

    @Override
    public void setLoginTimeout(int seconds) {
        DriverManager.setLoginTimeout(seconds);
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.driver.getParentLogger();
    }
}

