/*
 * Decompiled with CFR 0.152.
 */
package org.stone.beecp.pool;

import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import org.stone.beecp.BeeConnectionFactory;
import org.stone.beecp.BeeConnectionPool;
import org.stone.beecp.BeeConnectionPoolMonitorVo;
import org.stone.beecp.BeeDataSourceConfig;
import org.stone.beecp.BeeMethodLog;
import org.stone.beecp.BeeMethodLogListener;
import org.stone.beecp.BeeXaConnectionFactory;
import org.stone.beecp.exception.BeeDataSourceConfigException;
import org.stone.beecp.exception.BeeDataSourcePoolException;
import org.stone.beecp.exception.BeeDataSourcePoolNotReadyException;
import org.stone.beecp.exception.BeeDataSourcePoolRestartedFailureException;
import org.stone.beecp.exception.BeeDataSourcePoolStartedFailureException;
import org.stone.beecp.exception.ConnectionCreatedException;
import org.stone.beecp.exception.ConnectionDefaultValueGetException;
import org.stone.beecp.exception.ConnectionDefaultValueSetException;
import org.stone.beecp.exception.ConnectionGetException;
import org.stone.beecp.exception.ConnectionGetInterruptedException;
import org.stone.beecp.exception.ConnectionGetTimeoutException;
import org.stone.beecp.exception.XaConnectionCreatedException;
import org.stone.beecp.pool.Borrower;
import org.stone.beecp.pool.ConnectionCreatingInfo;
import org.stone.beecp.pool.ConnectionPoolStatics;
import org.stone.beecp.pool.FastConnectionPoolMXBean;
import org.stone.beecp.pool.FastConnectionPoolMonitorVo;
import org.stone.beecp.pool.MethodExecutionLogCache;
import org.stone.beecp.pool.PooledConnection;
import org.stone.beecp.pool.PooledConnectionAliveTest;
import org.stone.beecp.pool.PooledConnectionTransferPolicy;
import org.stone.beecp.pool.ProxyConnectionBase;
import org.stone.beecp.pool.ProxyConnectionFactory;
import org.stone.beecp.pool.ProxyConnectionFactory4L;
import org.stone.beecp.pool.XaProxyConnection;
import org.stone.beecp.pool.XaProxyResource;
import org.stone.beecp.pool.XaResourceLocalImpl;
import org.stone.tools.BeanUtil;
import org.stone.tools.CommonUtil;
import org.stone.tools.LogPrinter;
import org.stone.tools.atomic.IntegerFieldUpdaterImpl;
import org.stone.tools.atomic.ReferenceFieldUpdaterImpl;
import org.stone.tools.extension.InterruptableReentrantReadWriteLock;
import org.stone.tools.extension.InterruptableSemaphore;

public class FastConnectionPool
extends Thread
implements BeeConnectionPool,
FastConnectionPoolMXBean,
PooledConnectionAliveTest,
PooledConnectionTransferPolicy {
    static final AtomicIntegerFieldUpdater<FastConnectionPool> ServantStateUpd = IntegerFieldUpdaterImpl.newUpdater(FastConnectionPool.class, "servantState");
    private static final AtomicIntegerFieldUpdater<PooledConnection> ConStUpd = IntegerFieldUpdaterImpl.newUpdater(PooledConnection.class, "state");
    private static final AtomicReferenceFieldUpdater<Borrower, Object> BorrowStUpd = ReferenceFieldUpdaterImpl.newUpdater(Borrower.class, Object.class, "state");
    private static final AtomicIntegerFieldUpdater<FastConnectionPool> PoolStateUpd = IntegerFieldUpdaterImpl.newUpdater(FastConnectionPool.class, "poolState");
    private static final AtomicIntegerFieldUpdater<FastConnectionPool> ServantTryCountUpd = IntegerFieldUpdaterImpl.newUpdater(FastConnectionPool.class, "servantTryCount");
    LogPrinter logPrinter = LogPrinter.DefaultLogPrinter;
    String poolName;
    volatile int poolState;
    volatile int servantState;
    volatile int servantTryCount;
    BeeDataSourceConfig poolConfig;
    PooledConnection[] connectionArray;
    ConcurrentLinkedQueue<Borrower> waitQueue;
    long methodLogTimeoutMs;
    MethodExecutionLogCache methodLogCache;
    private boolean isFairMode;
    private boolean isCompeteMode;
    private int semaphoreSize;
    private InterruptableSemaphore semaphore;
    private long maxWaitMs;
    private long maxWaitNs;
    private long aliveAssumeTimeMs;
    private int aliveTestTimeout;
    private long parkTimeForRetryNs;
    private int stateCodeOnRelease;
    private int connectionArrayLen;
    private boolean connectionArrayInitialized;
    private InterruptableReentrantReadWriteLock connectionArrayInitLock;
    private PooledConnectionTransferPolicy transferPolicy;
    private boolean isRawXaConnFactory;
    private BeeConnectionFactory rawConnFactory;
    private BeeXaConnectionFactory rawXaConnFactory;
    private ProxyConnectionFactory conProxyFactory;
    private PooledConnectionAliveTest conValidTest;
    private ThreadPoolExecutor networkTimeoutExecutor;
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    private ScheduledFuture<?> timeoutLogsClearTaskFuture;
    private ScheduledFuture<?> timeoutConnectionsClearTaskFuture;
    private FastConnectionPoolMonitorVo simplePoolMonitorVo;
    private long idleTimeoutMs;
    private long holdTimeoutMs;
    private boolean supportHoldTimeout;
    private boolean collectMethodLogs;
    private boolean useThreadLocal;
    private ThreadLocal<WeakReference<Borrower>> threadLocal;
    private String poolNameOfRegisteredMBean;
    private ConnectionPoolHook exitHook;

    @Override
    public void start(BeeDataSourceConfig config) throws SQLException {
        if (config == null) {
            throw new BeeDataSourcePoolStartedFailureException("Data source configuration can't be null");
        }
        if (PoolStateUpd.compareAndSet(this, 0, 1)) {
            try {
                ConnectionPoolStatics.checkJdbcProxyClass();
                this.startupInternal(1, config.check());
                this.poolState = 2;
            }
            catch (Throwable e) {
                this.logPrinter.info("BeeCP({})-started failure", this.poolName, e);
                this.shutdownInternalThreads(false);
                this.poolState = 0;
                throw new BeeDataSourcePoolStartedFailureException("Data source pool started failure", e);
            }
        } else {
            throw new BeeDataSourcePoolStartedFailureException("Data source pool is starting or already started up");
        }
    }

    private void startupInternal(int poolWorkState, BeeDataSourceConfig config) throws SQLException {
        String poolInitInfo;
        String driverClassNameOrFactoryName;
        String poolMode;
        this.logPrinter = LogPrinter.getLogPrinter(FastConnectionPool.class, config.isPrintRuntimeLogs());
        this.poolConfig = config;
        this.poolName = this.poolConfig.getPoolName();
        this.logPrinter.info("BeeCP({})-starting up....", this.poolName);
        Object rawFactory = this.poolConfig.getConnectionFactory();
        if (rawFactory instanceof BeeXaConnectionFactory) {
            this.isRawXaConnFactory = true;
            this.rawXaConnFactory = (BeeXaConnectionFactory)rawFactory;
        } else {
            this.isRawXaConnFactory = false;
            this.rawConnFactory = (BeeConnectionFactory)rawFactory;
        }
        this.connectionArrayInitialized = false;
        this.connectionArrayLen = this.poolConfig.getMaxActive();
        this.connectionArray = new PooledConnection[this.connectionArrayLen];
        this.connectionArrayInitLock = new InterruptableReentrantReadWriteLock();
        for (int i = 0; i < this.connectionArrayLen; ++i) {
            this.connectionArray[i] = new PooledConnection(this);
        }
        this.maxWaitMs = this.poolConfig.getMaxWait();
        this.maxWaitNs = TimeUnit.MILLISECONDS.toNanos(this.maxWaitMs);
        PoolThreadThreadFactory poolThreadFactory = new PoolThreadThreadFactory(this.poolName);
        this.scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(2, poolThreadFactory);
        this.scheduledThreadPoolExecutor.setMaximumPoolSize(2);
        this.scheduledThreadPoolExecutor.setKeepAliveTime(10L, TimeUnit.SECONDS);
        this.scheduledThreadPoolExecutor.allowCoreThreadTimeOut(true);
        this.simplePoolMonitorVo = new FastConnectionPoolMonitorVo();
        this.timeoutConnectionsClearTaskFuture = this.scheduledThreadPoolExecutor.scheduleWithFixedDelay(new ConnectionTimeoutTask(this), this.poolConfig.getIntervalOfClearTimeout(), this.poolConfig.getIntervalOfClearTimeout(), TimeUnit.MILLISECONDS);
        int initialSize = this.poolConfig.getInitialSize();
        if (initialSize > 0 && !this.poolConfig.isAsyncCreateInitConnections()) {
            try {
                this.createInitConnections(initialSize, true);
            }
            catch (SQLException e) {
                this.timeoutConnectionsClearTaskFuture.cancel(true);
                throw e;
            }
        }
        if (this.poolConfig.isFairMode()) {
            poolMode = "fair";
            this.isFairMode = true;
            this.isCompeteMode = false;
            this.transferPolicy = new FairTransferPolicy();
        } else {
            poolMode = "compete";
            this.isFairMode = false;
            this.isCompeteMode = true;
            this.transferPolicy = this;
        }
        this.stateCodeOnRelease = this.transferPolicy.getStateCodeOnRelease();
        this.idleTimeoutMs = this.poolConfig.getIdleTimeout();
        this.holdTimeoutMs = this.poolConfig.getHoldTimeout();
        this.supportHoldTimeout = this.holdTimeoutMs > 0L;
        this.aliveAssumeTimeMs = this.poolConfig.getAliveAssumeTime();
        this.aliveTestTimeout = this.poolConfig.getAliveTestTimeout();
        this.parkTimeForRetryNs = TimeUnit.MILLISECONDS.toNanos(this.poolConfig.getParkTimeForRetry());
        this.methodLogTimeoutMs = this.poolConfig.getLogTimeout();
        this.semaphoreSize = this.poolConfig.getSemaphoreSize();
        this.semaphore = new InterruptableSemaphore(this.semaphoreSize, this.isFairMode);
        this.useThreadLocal = this.poolConfig.isUseThreadLocal();
        if (this.useThreadLocal) {
            this.threadLocal = new BorrowerThreadLocal();
        }
        if (1 == poolWorkState) {
            this.waitQueue = new ConcurrentLinkedQueue();
            this.methodLogCache = new MethodExecutionLogCache();
            this.servantTryCount = 0;
            this.servantState = 0;
            this.setDaemon(true);
            this.setName("BeeCP(" + this.poolName + ")-asyncAdd");
            this.start();
            this.exitHook = new ConnectionPoolHook(this);
            Runtime.getRuntime().addShutdownHook(this.exitHook);
        }
        this.methodLogCache.init(this.poolName, this.poolConfig.getLogCacheSize(), this.poolConfig.getSlowConnectionThreshold(), this.poolConfig.getSlowSQLThreshold(), this.poolConfig.getLogListener());
        if (this.poolConfig.isEnableLogCache()) {
            this.conProxyFactory = new ProxyConnectionFactory4L(this.methodLogCache);
            this.collectMethodLogs = true;
        } else {
            this.conProxyFactory = new ProxyConnectionFactory();
            this.collectMethodLogs = false;
        }
        this.timeoutLogsClearTaskFuture = this.scheduledThreadPoolExecutor.scheduleWithFixedDelay(new MethodLogTimeoutTask(this), this.poolConfig.getIntervalOfClearTimeoutLogs(), this.poolConfig.getIntervalOfClearTimeoutLogs(), TimeUnit.MILLISECONDS);
        if (initialSize > 0 && this.poolConfig.isAsyncCreateInitConnections()) {
            new PoolInitAsyncCreateThread(this, initialSize, "BeeCP(" + this.poolName + ")-asyncInitialConnectionCreator").start();
        }
        if (this.poolConfig.isRegisterMbeans()) {
            this.registerMBeans(this.poolConfig);
        }
        if (CommonUtil.isNotBlank(driverClassNameOrFactoryName = this.poolConfig.getDriverClassName())) {
            poolInitInfo = "BeeCP({})-has startup{mode:{},init size:{},max size:{},semaphore size:{},max wait:{}ms,driver:{}}";
        } else {
            driverClassNameOrFactoryName = rawFactory.getClass().getName();
            poolInitInfo = "BeeCP({})-has startup{mode:{},init size:{},max size:{},semaphore size:{},max wait:{}ms,factory:{}}";
        }
        this.logPrinter.info(poolInitInfo, this.poolName, poolMode, initialSize, this.connectionArrayLen, this.semaphoreSize, this.maxWaitMs, driverClassNameOrFactoryName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createInitConnections(int initSize, boolean syn) throws SQLException {
        boolean isWriteLocked;
        ReentrantReadWriteLock.WriteLock writeLock = this.connectionArrayInitLock.writeLock();
        boolean bl = isWriteLocked = !syn && !this.connectionArrayInitialized && !this.connectionArrayInitLock.isWriteLocked() && writeLock.tryLock();
        if (syn || isWriteLocked) {
            int index;
            try {
                Thread creatingThread = Thread.currentThread();
                for (index = 0; index < initSize; ++index) {
                    PooledConnection p = this.connectionArray[index];
                    p.state = 2;
                    this.fillRawConnection(p, 1, creatingThread);
                }
            }
            catch (SQLException e) {
                if (syn) {
                    for (int i = 0; i < index; ++i) {
                        this.connectionArray[i].onRemove("pool_init");
                    }
                    throw e;
                }
                this.logPrinter.warn("Failed to create initial connections by async mode", e);
            }
            finally {
                if (isWriteLocked) {
                    writeLock.unlock();
                }
            }
        }
    }

    private PooledConnection fillRawConnection(PooledConnection p, int state, Thread creatingThread) throws SQLException {
        this.logPrinter.info("BeeCP({})-start to create a connection", this.poolName);
        Connection rawConn = null;
        XAConnection rawXaConn = null;
        XAResource rawXaRes = null;
        try {
            p.creatingInfo = new ConnectionCreatingInfo(creatingThread);
            if (this.isRawXaConnFactory) {
                rawXaConn = this.rawXaConnFactory.create();
                if (rawXaConn == null) {
                    if (creatingThread.isInterrupted() && Thread.interrupted()) {
                        throw new ConnectionGetInterruptedException("An interruption occurred when created an XA connection");
                    }
                    throw new XaConnectionCreatedException("A unknown error occurred when created an XA connection");
                }
                rawConn = rawXaConn.getConnection();
                rawXaRes = rawXaConn.getXAResource();
            } else {
                rawConn = this.rawConnFactory.create();
                if (rawConn == null) {
                    if (creatingThread.isInterrupted() && Thread.interrupted()) {
                        throw new ConnectionGetInterruptedException("An interruption occurred when created a connection");
                    }
                    throw new ConnectionCreatedException("A unknown error occurred when created a connection");
                }
            }
            if (this.connectionArrayInitialized) {
                p.setRawConnection(state, rawConn, rawXaRes);
            } else {
                this.initPooledConnectionArray(rawConn);
                p.setRawConnection2(state, rawConn, rawXaRes);
                this.connectionArrayInitialized = true;
            }
            this.logPrinter.info("BeeCP({})-created a new connection:{} to fill pooled connection:{}", this.poolName, rawConn, p);
            PooledConnection pooledConnection = p;
            return pooledConnection;
        }
        catch (Throwable e) {
            p.state = 0;
            if (rawConn != null) {
                ConnectionPoolStatics.oclose(rawConn);
            } else if (rawXaConn != null) {
                ConnectionPoolStatics.oclose(rawXaConn);
            }
            throw e instanceof SQLException ? (SQLException)e : new ConnectionCreatedException(e);
        }
        finally {
            p.creatingInfo = null;
        }
    }

    private void initPooledConnectionArray(Connection firstConn) throws SQLException {
        boolean supportNetworkTimeoutInd;
        int defaultNetworkTimeout;
        boolean enableDefaultSchema;
        String defaultSchema;
        boolean enableDefaultCatalog;
        String defaultCatalog;
        boolean enableDefaultReadOnly;
        boolean defaultReadOnly;
        boolean enableDefaultTransactionIsolation;
        int defaultTransactionIsolation;
        boolean enableDefaultAutoCommit;
        boolean defaultAutoCommit;
        block45: {
            defaultAutoCommit = true;
            enableDefaultAutoCommit = this.poolConfig.isEnableDefaultAutoCommit();
            if (enableDefaultAutoCommit) {
                if (this.poolConfig.isDefaultAutoCommit() == null) {
                    try {
                        defaultAutoCommit = firstConn.getAutoCommit();
                    }
                    catch (Throwable e) {
                        throw new ConnectionDefaultValueGetException("Failed to get default value of 'auto-commit' from initial test connection", e);
                    }
                } else {
                    defaultAutoCommit = this.poolConfig.isDefaultAutoCommit();
                }
                try {
                    firstConn.setAutoCommit(defaultAutoCommit);
                }
                catch (Throwable e) {
                    throw new ConnectionDefaultValueSetException("Failed to set default value(" + defaultAutoCommit + ") of 'auto-commit' to initial test connection", e);
                }
            }
            defaultTransactionIsolation = 2;
            enableDefaultTransactionIsolation = this.poolConfig.isEnableDefaultTransactionIsolation();
            if (enableDefaultTransactionIsolation) {
                if (this.poolConfig.getDefaultTransactionIsolation() == null) {
                    try {
                        defaultTransactionIsolation = firstConn.getTransactionIsolation();
                    }
                    catch (Throwable e) {
                        throw new ConnectionDefaultValueGetException("Failed to get default value of 'transaction-isolation' from initial test connection", e);
                    }
                } else {
                    defaultTransactionIsolation = this.poolConfig.getDefaultTransactionIsolation();
                }
                try {
                    firstConn.setTransactionIsolation(defaultTransactionIsolation);
                }
                catch (Throwable e) {
                    throw new ConnectionDefaultValueSetException("Failed to set default value(" + defaultTransactionIsolation + ") of 'transaction-isolation' to initial test connection", e);
                }
            }
            defaultReadOnly = false;
            enableDefaultReadOnly = this.poolConfig.isEnableDefaultReadOnly();
            if (enableDefaultReadOnly) {
                if (this.poolConfig.isDefaultReadOnly() == null) {
                    try {
                        defaultReadOnly = firstConn.isReadOnly();
                    }
                    catch (Throwable e) {
                        throw new ConnectionDefaultValueGetException("Failed to get default value of 'read-only' from initial test connection", e);
                    }
                } else {
                    defaultReadOnly = this.poolConfig.isDefaultReadOnly();
                }
                try {
                    firstConn.setReadOnly(defaultReadOnly);
                }
                catch (Throwable e) {
                    throw new ConnectionDefaultValueSetException("Failed to set default value(" + defaultReadOnly + ") of 'read-only' to initial test connection", e);
                }
            }
            defaultCatalog = this.poolConfig.getDefaultCatalog();
            enableDefaultCatalog = this.poolConfig.isEnableDefaultCatalog();
            if (enableDefaultCatalog) {
                if (CommonUtil.isBlank(defaultCatalog)) {
                    try {
                        defaultCatalog = firstConn.getCatalog();
                    }
                    catch (Throwable e) {
                        throw new ConnectionDefaultValueGetException("Failed to get default value of 'catalog' from initial test connection", e);
                    }
                }
                if (CommonUtil.isNotBlank(defaultCatalog)) {
                    try {
                        firstConn.setCatalog(defaultCatalog);
                    }
                    catch (Throwable e) {
                        throw new ConnectionDefaultValueSetException("Failed to set default value(" + defaultCatalog + ") of 'catalog' to initial test connection", e);
                    }
                }
            }
            defaultSchema = this.poolConfig.getDefaultSchema();
            enableDefaultSchema = this.poolConfig.isEnableDefaultSchema();
            if (enableDefaultSchema) {
                if (CommonUtil.isBlank(defaultSchema)) {
                    try {
                        defaultSchema = firstConn.getSchema();
                    }
                    catch (Throwable e) {
                        throw new ConnectionDefaultValueGetException("Failed to get default value of 'schema' from initial test connection", e);
                    }
                }
                if (CommonUtil.isNotBlank(defaultSchema)) {
                    try {
                        firstConn.setSchema(defaultSchema);
                    }
                    catch (Throwable e) {
                        throw new ConnectionDefaultValueSetException("Failed to set default value(" + defaultSchema + ") of 'schema' to initial test connection", e);
                    }
                }
            }
            boolean supportIsValid = true;
            try {
                if (firstConn.isValid(this.aliveTestTimeout)) {
                    this.conValidTest = this;
                } else {
                    supportIsValid = false;
                    this.logPrinter.warn("BeeCP({})-driver not support 'isValid' method call on connection", this.poolName);
                }
            }
            catch (Throwable e) {
                supportIsValid = false;
                this.logPrinter.warn("BeeCP({})-exception occurred when call 'isValid' method on initial test connection", this.poolName, e);
            }
            if (!supportIsValid) {
                String conTestSql = this.poolConfig.getAliveTestSql();
                boolean supportQueryTimeout = ConnectionPoolStatics.validateTestSQL(this.poolName, firstConn, conTestSql, this.aliveTestTimeout, defaultAutoCommit);
                this.conValidTest = new PooledConnectionAliveTestBySql(this.poolName, conTestSql, this.aliveTestTimeout, defaultAutoCommit, supportQueryTimeout, this);
            }
            defaultNetworkTimeout = 0;
            supportNetworkTimeoutInd = true;
            try {
                defaultNetworkTimeout = firstConn.getNetworkTimeout();
                if (defaultNetworkTimeout < 0) {
                    supportNetworkTimeoutInd = false;
                    this.logPrinter.warn("BeeCP({})-driver not support 'getNetworkTimeout()/setNetworkTimeout(time)' method call on connection", this.poolName);
                } else {
                    int threadSize = Math.min(this.connectionArrayLen, CommonUtil.NCPU);
                    this.networkTimeoutExecutor = new ThreadPoolExecutor(threadSize, threadSize, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(this.connectionArrayLen), this.scheduledThreadPoolExecutor.getThreadFactory());
                    this.networkTimeoutExecutor.allowCoreThreadTimeOut(true);
                    firstConn.setNetworkTimeout(this.networkTimeoutExecutor, defaultNetworkTimeout);
                }
            }
            catch (Throwable e) {
                supportNetworkTimeoutInd = false;
                this.logPrinter.warn("BeeCP({})-exception occurred when call 'getNetworkTimeout()/setNetworkTimeout(time)' method on initial test connection", this.poolName, e);
                if (this.networkTimeoutExecutor == null) break block45;
                this.networkTimeoutExecutor.shutdownNow();
                this.networkTimeoutExecutor = null;
            }
        }
        for (int i = 0; i < this.connectionArrayLen; ++i) {
            this.connectionArray[i].init(enableDefaultAutoCommit, defaultAutoCommit, enableDefaultTransactionIsolation, defaultTransactionIsolation, enableDefaultReadOnly, defaultReadOnly, enableDefaultCatalog, defaultCatalog, this.poolConfig.isForceDirtyWhenSetCatalog(), enableDefaultSchema, defaultSchema, this.poolConfig.isForceDirtyWhenSetSchema(), supportNetworkTimeoutInd, defaultNetworkTimeout, this.networkTimeoutExecutor, this.poolConfig.getSqlExceptionCodeList(), this.poolConfig.getSqlExceptionStateList(), this.poolConfig.getPredicate());
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.collectMethodLogs) {
            BeeMethodLog log = this.methodLogCache.beforeCall(1, "FastConnectionPool.getConnection()", null, null, null);
            try {
                ProxyConnectionBase con = this.conProxyFactory.createProxyConnection(this.getPooledConnection());
                this.methodLogCache.afterCall(con, 0L, null, log);
                return con;
            }
            catch (SQLException e) {
                this.methodLogCache.afterCall(e, 0L, null, log);
                throw e;
            }
        }
        return this.conProxyFactory.createProxyConnection(this.getPooledConnection());
    }

    @Override
    public XAConnection getXAConnection() throws SQLException {
        if (this.collectMethodLogs) {
            BeeMethodLog log = this.methodLogCache.beforeCall(1, "FastConnectionPool.getXAConnection()", null, null, null);
            try {
                PooledConnection p = this.getPooledConnection();
                ProxyConnectionBase proxyConn = this.conProxyFactory.createProxyConnection(p);
                XAResource proxyResource = this.isRawXaConnFactory ? new XaProxyResource(p.rawXaRes, proxyConn) : new XaResourceLocalImpl(proxyConn);
                XaProxyConnection xaConn = new XaProxyConnection(proxyConn, proxyResource);
                this.methodLogCache.afterCall(xaConn, 0L, null, log);
                return xaConn;
            }
            catch (SQLException e) {
                this.methodLogCache.afterCall(e, 0L, null, log);
                throw e;
            }
        }
        PooledConnection p = this.getPooledConnection();
        ProxyConnectionBase proxyConn = this.conProxyFactory.createProxyConnection(p);
        XAResource proxyResource = this.isRawXaConnFactory ? new XaProxyResource(p.rawXaRes, proxyConn) : new XaResourceLocalImpl(proxyConn);
        return new XaProxyConnection(proxyConn, proxyResource);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PooledConnection getPooledConnection() throws SQLException {
        PooledConnection p;
        if (this.poolState != 2) {
            throw new BeeDataSourcePoolNotReadyException("Pool has been closed or is restarting");
        }
        Borrower b = null;
        if (this.useThreadLocal && (b = (Borrower)this.threadLocal.get().get()) != null && (p = b.lastUsed) != null) {
            int state = p.state;
            if (state == 1) {
                if (ConStUpd.compareAndSet(p, 1, 3)) {
                    if (this.testOnBorrow(p)) {
                        return p;
                    }
                } else if (p.state == 0 && ConStUpd.compareAndSet(p, 0, 2)) {
                    return this.fillRawConnection(p, 3, b.thread);
                }
            } else if (state == 0 && ConStUpd.compareAndSet(p, 0, 2)) {
                return this.fillRawConnection(p, 3, b.thread);
            }
        }
        try {
            long deadline = System.currentTimeMillis();
            if (!this.semaphore.tryAcquire(this.maxWaitNs, TimeUnit.NANOSECONDS)) throw new ConnectionGetTimeoutException("Waited timeout on pool semaphore");
            try {
                Thread borrowThread = b != null ? b.thread : Thread.currentThread();
                p = this.searchOrCreate(borrowThread);
                if (p != null) {
                    if (this.useThreadLocal) {
                        if (b != null) {
                            b.lastUsed = p;
                        } else {
                            this.threadLocal.set(new WeakReference<Borrower>(new Borrower(borrowThread, p)));
                        }
                    }
                    PooledConnection pooledConnection = p;
                    return pooledConnection;
                }
                if (b != null) {
                    b.state = null;
                } else {
                    b = new Borrower(borrowThread);
                    if (this.useThreadLocal) {
                        this.threadLocal.set(new WeakReference<Borrower>(b));
                    }
                }
                this.waitQueue.offer(b);
                deadline += this.maxWaitMs;
                while (true) {
                    long t;
                    Object s;
                    if ((s = b.state) instanceof PooledConnection) {
                        p = (PooledConnection)s;
                        if (this.transferPolicy.tryCatch(p) && this.testOnBorrow(p)) {
                            this.waitQueue.remove(b);
                            PooledConnection pooledConnection = b.lastUsed = p;
                            return pooledConnection;
                        }
                    } else if (s instanceof Throwable) {
                        SQLException sQLException;
                        this.waitQueue.remove(b);
                        if (s instanceof SQLException) {
                            sQLException = (SQLException)s;
                            throw sQLException;
                        }
                        sQLException = new ConnectionGetException((Throwable)s);
                        throw sQLException;
                    }
                    if ((t = deadline - System.currentTimeMillis()) <= 0L) {
                        PooledConnection pooledConnection = this.handleTimeoutAndInterruption(true, s, b);
                        return pooledConnection;
                    }
                    if (s != null) {
                        b.state = null;
                    }
                    if (this.servantTryCount > 0 && this.servantState == 1 && ServantStateUpd.compareAndSet(this, 1, 0)) {
                        LockSupport.unpark(this);
                    }
                    LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(t));
                    if (!borrowThread.isInterrupted() || !Thread.interrupted()) continue;
                    this.handleTimeoutAndInterruption(false, null, b);
                }
            }
            finally {
                this.semaphore.release();
            }
        }
        catch (InterruptedException e) {
            throw new ConnectionGetInterruptedException("An interruption occurred while waiting on pool semaphore");
        }
    }

    private boolean testOnBorrow(PooledConnection p) {
        if (System.currentTimeMillis() - p.lastAccessTime - this.aliveAssumeTimeMs >= 0L && !this.conValidTest.isAlive(p)) {
            p.onRemove("bad");
            this.tryWakeupServantThread();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PooledConnection searchOrCreate(Thread creatingThread) throws SQLException {
        if (!this.connectionArrayInitialized) {
            ReentrantReadWriteLock.ReadLock readLock = this.connectionArrayInitLock.readLock();
            ReentrantReadWriteLock.WriteLock writeLock = this.connectionArrayInitLock.writeLock();
            try {
                if (!this.connectionArrayInitLock.isWriteLocked() && writeLock.tryLock()) {
                    try {
                        PooledConnection p = this.connectionArray[0];
                        p.state = 2;
                        PooledConnection pooledConnection = this.fillRawConnection(p, 3, creatingThread);
                        return pooledConnection;
                    }
                    finally {
                        writeLock.unlock();
                    }
                }
                if (!readLock.tryLock(this.maxWaitNs, TimeUnit.NANOSECONDS)) throw new ConnectionGetTimeoutException("Waited timeout on pool lock");
                readLock.unlock();
                if (!this.connectionArrayInitialized) {
                    throw new ConnectionGetException("Pool first connection created fail or first connection initialized fail");
                }
            }
            catch (InterruptedException e) {
                throw new ConnectionGetInterruptedException("An interruption occurred while waiting on pool lock");
            }
        }
        PooledConnection[] pooledConnectionArray = this.connectionArray;
        int n = pooledConnectionArray.length;
        int n2 = 0;
        while (n2 < n) {
            PooledConnection p = pooledConnectionArray[n2];
            int state = p.state;
            if (state == 1) {
                if (ConStUpd.compareAndSet(p, 1, 3)) {
                    if (this.testOnBorrow(p)) {
                        return p;
                    }
                } else if (p.state == 0 && ConStUpd.compareAndSet(p, 0, 2)) {
                    return this.fillRawConnection(p, 3, creatingThread);
                }
            } else if (state == 0 && ConStUpd.compareAndSet(p, 0, 2)) {
                return this.fillRawConnection(p, 3, creatingThread);
            }
            ++n2;
        }
        return null;
    }

    private PooledConnection handleTimeoutAndInterruption(boolean isTimeout, Object s, Borrower b) throws SQLException {
        this.waitQueue.remove(b);
        PooledConnection p = null;
        if (s == null) {
            s = b.state;
            if (s instanceof PooledConnection) {
                p = (PooledConnection)s;
                if (!this.transferPolicy.tryCatch(p) || !this.testOnBorrow(p)) {
                    p = null;
                }
            } else if (s instanceof Throwable) {
                throw s instanceof SQLException ? (SQLException)s : new ConnectionGetException((Throwable)s);
            }
        }
        if (isTimeout) {
            if (p != null) {
                b.lastUsed = p;
                return b.lastUsed;
            }
            throw new ConnectionGetTimeoutException("Waited timeout for a released connection");
        }
        if (p != null) {
            this.recycle(p);
        }
        throw new ConnectionGetInterruptedException("An interruption occurred while waiting for a released connection");
    }

    void recycle(PooledConnection p) {
        if (this.isCompeteMode) {
            p.state = 1;
        }
        for (Borrower b : this.waitQueue) {
            if (p.state != this.stateCodeOnRelease) {
                return;
            }
            if (b.state != null || !BorrowStUpd.compareAndSet(b, null, p)) continue;
            LockSupport.unpark(b.thread);
            return;
        }
        if (this.isFairMode) {
            p.state = 1;
        }
        this.tryWakeupServantThread();
    }

    private void transferException(Throwable e) {
        for (Borrower b : this.waitQueue) {
            if (b.state != null || !BorrowStUpd.compareAndSet(b, null, e)) continue;
            LockSupport.unpark(b.thread);
            return;
        }
    }

    void abort(PooledConnection p, String reason) {
        p.onRemove(reason);
        this.tryWakeupServantThread();
    }

    private void tryWakeupServantThread() {
        int c;
        do {
            if ((c = this.servantTryCount) < this.connectionArrayLen) continue;
            return;
        } while (!ServantTryCountUpd.compareAndSet(this, c, c + 1));
        if (!this.waitQueue.isEmpty() && this.servantState == 1 && ServantStateUpd.compareAndSet(this, 1, 0)) {
            LockSupport.unpark(this);
        }
    }

    @Override
    public void restart(boolean forceRecycleBorrowed) throws SQLException {
        this.restart(forceRecycleBorrowed, false, null);
    }

    @Override
    public void restart(boolean forceRecycleBorrowed, BeeDataSourceConfig config) throws SQLException {
        this.restart(forceRecycleBorrowed, true, config);
    }

    private void restart(boolean forceRecycleBorrowed, boolean reinit, BeeDataSourceConfig config) throws SQLException {
        if (reinit && config == null) {
            throw new BeeDataSourceConfigException("Data source configuration can't be null");
        }
        int poolState = this.poolState;
        boolean hasRunToStartupInternal = false;
        if ((poolState == 2 || poolState == 6) && PoolStateUpd.compareAndSet(this, poolState, 5)) {
            try {
                BeeDataSourceConfig checkedConfig = null;
                if (reinit) {
                    checkedConfig = config.check();
                    this.shutdownInternalThreads(false);
                }
                this.logPrinter.info("BeeCP({})-begin to remove all connections", this.poolName);
                this.removeAllConnections(forceRecycleBorrowed, "pool_restart");
                this.logPrinter.info("BeeCP({})-completed to remove all connections", this.poolName);
                if (reinit) {
                    this.logPrinter.info("BeeCP({})-begin to restart pool", this.poolName);
                    hasRunToStartupInternal = true;
                    this.startupInternal(5, checkedConfig);
                    this.logPrinter.info("BeeCP({})-restart pool successful", this.poolName);
                }
                this.poolState = 2;
            }
            catch (Throwable e) {
                this.logPrinter.error("BeeCP({})-restarted failure", this.poolName, e);
                if (hasRunToStartupInternal) {
                    this.poolState = 6;
                    this.shutdownInternalThreads(false);
                } else {
                    this.poolState = 2;
                }
                if (e instanceof BeeDataSourcePoolException) {
                    throw (BeeDataSourcePoolException)e;
                }
                throw new BeeDataSourcePoolRestartedFailureException("Data source pool restarted failure", e);
            }
        } else {
            throw new BeeDataSourcePoolRestartedFailureException("Pool has been closed or is restarting");
        }
    }

    private void removeAllConnections(boolean force, String source) {
        this.interruptWaitingThreads();
        int closedCount = 0;
        while (true) {
            for (PooledConnection p : this.connectionArray) {
                int state = p.state;
                if (state == 1) {
                    if (!ConStUpd.compareAndSet(p, 1, 0)) continue;
                    ++closedCount;
                    p.onRemove(source);
                    continue;
                }
                if (state == 3) {
                    ProxyConnectionBase proxyInUsing = p.proxyInUsing;
                    if (proxyInUsing == null || !force && (!this.supportHoldTimeout || System.currentTimeMillis() - p.lastAccessTime - this.holdTimeoutMs < 0L)) continue;
                    ConnectionPoolStatics.oclose(proxyInUsing);
                    continue;
                }
                if (state != 0) continue;
                ++closedCount;
            }
            if (closedCount == this.connectionArrayLen) break;
            LockSupport.parkNanos(this.parkTimeForRetryNs);
            closedCount = 0;
        }
        if (this.logPrinter.isEnableLogOutput()) {
            BeeConnectionPoolMonitorVo vo = this.getPoolMonitorVo();
            this.logPrinter.info("BeeCP({})-after clear,idle:{},borrowed:{},semaphore-waiting:{},transfer-waiting:{}", this.poolName, vo.getIdleSize(), vo.getBorrowedSize(), vo.getSemaphoreWaitingSize(), vo.getTransferWaitingSize());
        }
    }

    @Override
    public boolean suspendPool() {
        return PoolStateUpd.compareAndSet(this, 2, 7);
    }

    @Override
    public boolean resumePool() {
        return PoolStateUpd.compareAndSet(this, 7, 2);
    }

    @Override
    public boolean isClosed() {
        return this.poolState == 4;
    }

    @Override
    public String toString() {
        return ConnectionPoolStatics.getPoolStateDesc(this.poolState);
    }

    @Override
    public void close() {
        block3: {
            int poolStateCode;
            while (true) {
                if ((poolStateCode = this.poolState) == 4 || poolStateCode == 3) {
                    return;
                }
                if (poolStateCode == 0 && PoolStateUpd.compareAndSet(this, 0, 4)) {
                    return;
                }
                if (poolStateCode != 1 && poolStateCode != 5) break;
                LockSupport.parkNanos(this.parkTimeForRetryNs);
            }
            if (!PoolStateUpd.compareAndSet(this, poolStateCode, 3)) break block3;
            this.logPrinter.info("BeeCP({})-begin to shutdown pool", this.poolName);
            this.shutdownInternalThreads(true);
            this.removeAllConnections(this.poolConfig.isForceRecycleBorrowedOnClose(), "pool_shutdown");
            this.poolState = 4;
            this.logPrinter.info("BeeCP({})-has shutdown pool", this.poolName);
        }
    }

    private void shutdownInternalThreads(boolean isCloseCall) {
        this.logPrinter.info("BeeCP({})-begin to shutdown pool internal threads", this.poolName);
        if (this.networkTimeoutExecutor != null) {
            this.networkTimeoutExecutor.shutdownNow();
            this.networkTimeoutExecutor.getQueue().clear();
            this.networkTimeoutExecutor = null;
        }
        if (this.scheduledThreadPoolExecutor != null) {
            if (this.timeoutLogsClearTaskFuture != null) {
                this.timeoutLogsClearTaskFuture.cancel(true);
                this.timeoutLogsClearTaskFuture = null;
            }
            if (this.timeoutConnectionsClearTaskFuture != null) {
                this.timeoutConnectionsClearTaskFuture.cancel(true);
                this.timeoutConnectionsClearTaskFuture = null;
            }
            this.scheduledThreadPoolExecutor.shutdownNow();
            this.scheduledThreadPoolExecutor.getQueue().clear();
            this.scheduledThreadPoolExecutor = null;
        }
        if (this.exitHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.exitHook);
            }
            catch (Throwable throwable) {
            }
            finally {
                this.exitHook = null;
            }
        }
        if (isCloseCall) {
            int curState = this.servantState;
            this.servantState = 2;
            if (curState == 1) {
                LockSupport.unpark(this);
            }
        }
        this.threadLocal = null;
        if (this.waitQueue != null) {
            this.waitQueue.clear();
        }
        if (this.methodLogCache != null) {
            this.methodLogCache.clear(0);
        }
        if (this.poolNameOfRegisteredMBean != null) {
            this.unregisterMBeans();
        }
        this.logPrinter.info("BeeCP({})-completed to shutdown pool internal threads", this.poolName);
    }

    @Override
    public void changeLogListener(BeeMethodLogListener listener) {
        this.methodLogCache.setMethodExecutionListener(listener);
    }

    @Override
    public List<BeeMethodLog> getLogs(int type) {
        return this.methodLogCache.getLog(type);
    }

    @Override
    public void clearLogs(int type) {
        this.methodLogCache.clear(type);
    }

    @Override
    public synchronized void enableLogCache(boolean enable) {
        if (enable != this.collectMethodLogs) {
            if (enable) {
                this.conProxyFactory = new ProxyConnectionFactory4L(this.methodLogCache);
                this.collectMethodLogs = true;
                this.timeoutLogsClearTaskFuture = this.scheduledThreadPoolExecutor.scheduleWithFixedDelay(new MethodLogTimeoutTask(this), this.poolConfig.getIntervalOfClearTimeoutLogs(), this.poolConfig.getIntervalOfClearTimeoutLogs(), TimeUnit.MILLISECONDS);
            } else {
                this.conProxyFactory = new ProxyConnectionFactory();
                this.collectMethodLogs = false;
                this.methodLogCache.clear(0);
                if (this.timeoutLogsClearTaskFuture != null) {
                    this.timeoutLogsClearTaskFuture.cancel(true);
                    this.timeoutLogsClearTaskFuture = null;
                }
            }
        }
    }

    @Override
    public boolean cancelStatement(String id) throws SQLException {
        return this.methodLogCache.cancelStatement(id);
    }

    private void registerMBeans(BeeDataSourceConfig poolConfig) {
        String configMBeanName = String.format("org.stone.beecp.BeeDataSourceConfig:type=BeeCP(%s)-config", this.poolName);
        try {
            BeanUtil.registerMBean(configMBeanName, poolConfig);
        }
        catch (Throwable e) {
            this.logPrinter.warn("BeeCP({})-failed to register a MBean with name:{}", this.poolName, configMBeanName, e);
        }
        String poolMBeanName = String.format("org.stone.beecp.pool.FastConnectionPool:type=BeeCP(%s)", this.poolName);
        try {
            BeanUtil.registerMBean(poolMBeanName, this);
        }
        catch (Throwable e) {
            this.logPrinter.warn("BeeCP({})-failed to register a MBean with name:{}", this.poolName, poolMBeanName, e);
        }
        this.poolNameOfRegisteredMBean = this.poolName;
    }

    private void unregisterMBeans() {
        String configMBeanName = String.format("org.stone.beecp.BeeDataSourceConfig:type=BeeCP(%s)-config", this.poolNameOfRegisteredMBean);
        try {
            BeanUtil.unregisterMBean(configMBeanName);
        }
        catch (Throwable e) {
            this.logPrinter.warn("BeeCP({})-failed to unregister a MBean with name:{}", this.poolNameOfRegisteredMBean, configMBeanName, e);
        }
        String poolMBeanName = String.format("org.stone.beecp.pool.FastConnectionPool:type=BeeCP(%s)", this.poolNameOfRegisteredMBean);
        try {
            BeanUtil.unregisterMBean(poolMBeanName);
        }
        catch (Throwable e) {
            this.logPrinter.warn("BeeCP({})-failed to unregister a MBean with name:{}", this.poolNameOfRegisteredMBean, poolMBeanName, e);
        }
        this.poolNameOfRegisteredMBean = null;
    }

    @Override
    public synchronized void enableLogPrinter(boolean enable) {
        this.logPrinter = LogPrinter.getLogPrinter(FastConnectionPool.class, enable);
    }

    @Override
    public List<Thread> interruptWaitingThreads() {
        LinkedList<Thread> threads = new LinkedList<Thread>();
        if (this.semaphore != null) {
            threads.addAll(this.semaphore.interruptQueuedWaitThreads());
        }
        if (this.waitQueue != null && !this.waitQueue.isEmpty()) {
            BeeDataSourcePoolRestartedFailureException exception = new BeeDataSourcePoolRestartedFailureException("Pool has been closed or is restarting");
            while (!this.waitQueue.isEmpty()) {
                this.transferException(exception);
            }
        }
        if (this.connectionArrayInitLock != null) {
            threads.addAll(this.connectionArrayInitLock.interruptAllThreads());
        }
        if (this.connectionArray != null) {
            for (PooledConnection p : this.connectionArray) {
                ConnectionCreatingInfo creatingInfo = p.creatingInfo;
                if (creatingInfo == null) continue;
                creatingInfo.creatingThread.interrupt();
                threads.add(creatingInfo.creatingThread);
            }
        }
        return threads;
    }

    @Override
    public BeeConnectionPoolMonitorVo getPoolMonitorVo() {
        return this.getPoolMonitorVo(false);
    }

    private BeeConnectionPoolMonitorVo getPoolMonitorVo(boolean simple) {
        if (simple) {
            int idleSize = 0;
            int borrowedSize = 0;
            for (PooledConnection p : this.connectionArray) {
                if (p == null) continue;
                int state = p.state;
                if (state == 1) {
                    ++idleSize;
                    continue;
                }
                if (state != 3) continue;
                ++borrowedSize;
            }
            int semaphoreRemainSize = 0;
            int semaphoreWaitingSize = 0;
            if (this.semaphore != null) {
                semaphoreRemainSize = this.semaphore.availablePermits();
                semaphoreWaitingSize = this.semaphore.getQueueLength();
            }
            this.simplePoolMonitorVo.fillSimple(idleSize, borrowedSize, semaphoreRemainSize, semaphoreWaitingSize);
            return this.simplePoolMonitorVo;
        }
        int idleSize = 0;
        int borrowedSize = 0;
        int creatingCount = 0;
        int creatingTimeoutCount = 0;
        if (this.connectionArray != null) {
            long currentTimeMillis = System.currentTimeMillis();
            for (PooledConnection p : this.connectionArray) {
                if (p == null) continue;
                int state = p.state;
                if (state == 1) {
                    ++idleSize;
                } else if (state == 3) {
                    ++borrowedSize;
                }
                ConnectionCreatingInfo creatingInfo = p.creatingInfo;
                if (creatingInfo == null) continue;
                ++creatingCount;
                if (currentTimeMillis - creatingInfo.creatingStartTime - this.maxWaitMs < 0L) continue;
                ++creatingTimeoutCount;
            }
        }
        int semaphoreRemainSize = 0;
        int semaphoreWaitingSize = 0;
        int transferWaitingSize = 0;
        if (this.semaphore != null) {
            semaphoreRemainSize = this.semaphore.availablePermits();
            semaphoreWaitingSize = this.semaphore.getQueueLength();
        }
        if (this.waitQueue != null) {
            for (Borrower borrower : this.waitQueue) {
                if (borrower.state != null) continue;
                ++transferWaitingSize;
            }
        }
        return new FastConnectionPoolMonitorVo(this.poolName, this.isFairMode, this.connectionArrayLen, this.semaphoreSize, this.useThreadLocal, this.poolState, idleSize, borrowedSize, semaphoreRemainSize, semaphoreWaitingSize, transferWaitingSize, creatingCount, creatingTimeoutCount, this.logPrinter.isEnableLogOutput(), this.collectMethodLogs);
    }

    @Override
    public int getStateCodeOnRelease() {
        return 1;
    }

    @Override
    public boolean tryCatch(PooledConnection p) {
        return p.state == 1 && ConStUpd.compareAndSet(p, 1, 3);
    }

    @Override
    public boolean isAlive(PooledConnection p) {
        try {
            if (p.rawConn.isValid(this.aliveTestTimeout)) {
                p.lastAccessTime = System.currentTimeMillis();
                return true;
            }
        }
        catch (Throwable e) {
            this.logPrinter.warn("BeeCP({})-alive test failed on a borrowed connection", this.poolName, e);
        }
        return false;
    }

    @Override
    public void run() {
        int servantState;
        Thread currentThread = Thread.currentThread();
        while ((servantState = this.servantState) != 2) {
            if (servantState == 0) {
                if (this.servantTryCount > 0 && !this.waitQueue.isEmpty()) {
                    ServantTryCountUpd.decrementAndGet(this);
                    try {
                        PooledConnection p = this.searchOrCreate(currentThread);
                        if (p == null) continue;
                        this.recycle(p);
                    }
                    catch (Throwable e) {
                        this.transferException(e);
                    }
                    continue;
                }
                if (!ServantStateUpd.compareAndSet(this, 0, 1)) continue;
                LockSupport.park();
                continue;
            }
            this.servantState = 0;
        }
    }

    void closeIdleTimeoutConnections() {
        Object vo;
        if (this.logPrinter.isEnableLogOutput()) {
            vo = this.getPoolMonitorVo(true);
            this.logPrinter.info("BeeCP({})-before timed scan,idle:{},borrowed:{},semaphore-waiting:{},transfer-waiting:{}", this.poolName, vo.getIdleSize(), vo.getBorrowedSize(), vo.getSemaphoreWaitingSize(), vo.getTransferWaitingSize());
        }
        for (PooledConnection p : this.connectionArray) {
            ProxyConnectionBase proxyInUsing;
            if (p == null) continue;
            int state = p.state;
            if (state == 2) {
                ConnectionCreatingInfo creatingInfo = p.creatingInfo;
                if (creatingInfo == null || System.currentTimeMillis() - creatingInfo.creatingStartTime - this.maxWaitMs < 0L) continue;
                creatingInfo.creatingThread.interrupt();
                continue;
            }
            if (state == 1 && this.semaphore.availablePermits() == this.semaphoreSize) {
                boolean isTimeoutInIdle;
                boolean bl = isTimeoutInIdle = System.currentTimeMillis() - p.lastAccessTime - this.idleTimeoutMs >= 0L;
                if (!isTimeoutInIdle || !ConStUpd.compareAndSet(p, state, 0)) continue;
                p.onRemove("idle");
                this.tryWakeupServantThread();
                continue;
            }
            if (state != 3 || !this.supportHoldTimeout || System.currentTimeMillis() - p.lastAccessTime - this.holdTimeoutMs < 0L || (proxyInUsing = p.proxyInUsing) == null) continue;
            ConnectionPoolStatics.oclose(proxyInUsing);
        }
        if (this.logPrinter.isEnableLogOutput()) {
            vo = this.getPoolMonitorVo(true);
            this.logPrinter.info("BeeCP({})-after timed scan,idle:{},borrowed:{},semaphore-waiting:{},transfer-waiting:{}", this.poolName, vo.getIdleSize(), vo.getBorrowedSize(), vo.getSemaphoreWaitingSize(), vo.getTransferWaitingSize());
        }
    }

    private static class PooledConnectionAliveTestBySql
    implements PooledConnectionAliveTest {
        private final String poolName;
        private final String testSql;
        private final int validTestTimeout;
        private final boolean isDefaultAutoCommit;
        private final boolean supportQueryTimeout;
        private final FastConnectionPool pool;

        public PooledConnectionAliveTestBySql(String poolName, String testSql, int validTestTimeout, boolean isDefaultAutoCommit, boolean supportQueryTimeout, FastConnectionPool pool) {
            this.poolName = poolName;
            this.testSql = testSql;
            this.validTestTimeout = validTestTimeout;
            this.isDefaultAutoCommit = isDefaultAutoCommit;
            this.supportQueryTimeout = supportQueryTimeout;
            this.pool = pool;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isAlive(PooledConnection p) {
            boolean checkPassed;
            Connection rawConn;
            boolean changed;
            block22: {
                Statement st = null;
                changed = false;
                rawConn = p.rawConn;
                checkPassed = true;
                try {
                    if (this.isDefaultAutoCommit) {
                        rawConn.setAutoCommit(false);
                        changed = true;
                    }
                    st = rawConn.createStatement();
                    if (this.supportQueryTimeout) {
                        try {
                            st.setQueryTimeout(this.validTestTimeout);
                        }
                        catch (Throwable e) {
                            this.pool.logPrinter.warn("BeeCP({})-failed to set query timeout value on statement of a borrowed connection", this.poolName, e);
                        }
                    }
                    try {
                        st.execute(this.testSql);
                        p.lastAccessTime = System.currentTimeMillis();
                    }
                    finally {
                        rawConn.rollback();
                    }
                    if (st == null) break block22;
                }
                catch (Throwable e) {
                    block23: {
                        try {
                            checkPassed = false;
                            this.pool.logPrinter.warn("BeeCP({})-connection alive test failed with sql,pool will abandon it", this.poolName, e);
                            if (st == null) break block23;
                        }
                        catch (Throwable throwable) {
                            if (st != null) {
                                ConnectionPoolStatics.oclose(st);
                            }
                            if (changed) {
                                try {
                                    rawConn.setAutoCommit(true);
                                }
                                catch (Throwable e2) {
                                    this.pool.logPrinter.warn("BeeCP({})-failed to reset 'auto-commit' to false after alive test,pool will abandon test connection", this.poolName, e2);
                                    checkPassed = false;
                                }
                            }
                            throw throwable;
                        }
                        ConnectionPoolStatics.oclose(st);
                    }
                    if (changed) {
                        try {
                            rawConn.setAutoCommit(true);
                        }
                        catch (Throwable e3) {
                            this.pool.logPrinter.warn("BeeCP({})-failed to reset 'auto-commit' to false after alive test,pool will abandon test connection", this.poolName, e3);
                            checkPassed = false;
                        }
                    }
                }
                ConnectionPoolStatics.oclose(st);
            }
            if (changed) {
                try {
                    rawConn.setAutoCommit(true);
                }
                catch (Throwable e) {
                    this.pool.logPrinter.warn("BeeCP({})-failed to reset 'auto-commit' to false after alive test,pool will abandon test connection", this.poolName, e);
                    checkPassed = false;
                }
            }
            return checkPassed;
        }
    }

    private static class ConnectionPoolHook
    extends Thread {
        private final FastConnectionPool pool;

        ConnectionPoolHook(FastConnectionPool pool) {
            this.pool = pool;
        }

        @Override
        public void run() {
            this.pool.logPrinter.info("BeeCP({})-detect Jvm exit,pool will be shutdown", this.pool.poolName);
            try {
                this.pool.close();
            }
            catch (Throwable e) {
                this.pool.logPrinter.error("BeeCP({})-an exception occurred when shutdown pool", this.pool.poolName, e);
            }
        }
    }

    private static final class MethodLogTimeoutTask
    implements Runnable {
        private final FastConnectionPool pool;

        MethodLogTimeoutTask(FastConnectionPool pool) {
            this.pool = pool;
        }

        @Override
        public void run() {
            try {
                this.pool.methodLogCache.clearTimeout(this.pool.methodLogTimeoutMs);
            }
            catch (Throwable e) {
                this.pool.logPrinter.warn("BeeCP({})-an exception occurred while scanning timeout method logs", this.pool.poolName, e);
            }
        }
    }

    private static final class ConnectionTimeoutTask
    implements Runnable {
        private final FastConnectionPool pool;

        ConnectionTimeoutTask(FastConnectionPool pool) {
            this.pool = pool;
        }

        @Override
        public void run() {
            try {
                this.pool.closeIdleTimeoutConnections();
            }
            catch (Throwable e) {
                this.pool.logPrinter.warn("BeeCP({})-an exception occurred while scanning idle-timeout connections", this.pool.poolName, e);
            }
        }
    }

    private static final class FairTransferPolicy
    implements PooledConnectionTransferPolicy {
        FairTransferPolicy() {
        }

        @Override
        public int getStateCodeOnRelease() {
            return 3;
        }

        @Override
        public boolean tryCatch(PooledConnection p) {
            return p.state == 3;
        }
    }

    private static final class BorrowerThreadLocal
    extends ThreadLocal<WeakReference<Borrower>> {
        BorrowerThreadLocal() {
        }

        @Override
        protected WeakReference<Borrower> initialValue() {
            return new WeakReference<Borrower>(new Borrower(Thread.currentThread()));
        }
    }

    private static final class PoolInitAsyncCreateThread
    extends Thread {
        private final int initialSize;
        private final FastConnectionPool pool;

        PoolInitAsyncCreateThread(FastConnectionPool pool, int initialSize, String threadName) {
            super(threadName);
            this.pool = pool;
            this.initialSize = initialSize;
        }

        @Override
        public void run() {
            try {
                this.pool.createInitConnections(this.initialSize, false);
                this.pool.servantTryCount = this.pool.connectionArray.length;
                if (!this.pool.waitQueue.isEmpty() && this.pool.servantState == 1 && ServantStateUpd.compareAndSet(this.pool, 1, 0)) {
                    LockSupport.unpark(this.pool);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static class PoolThreadThreadFactory
    implements ThreadFactory {
        private final String poolName;

        PoolThreadThreadFactory(String poolName) {
            this.poolName = poolName;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread th = new Thread(r, this.poolName + "-networkTimeoutRestThread");
            th.setDaemon(true);
            return th;
        }
    }
}

