/*
 * Decompiled with CFR 0.152.
 */
package org.stone.beecp.pool;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import org.stone.beecp.BeeMethodLog;
import org.stone.beecp.BeeMethodLogListener;
import org.stone.beecp.pool.MethodExecutionLog;

final class MethodExecutionLogCache {
    private String poolName;
    private int maxSize;
    private long slowConnectionThreshold;
    private long slowSQLThreshold;
    private LinkedBlockingQueue<MethodExecutionLog> connectionGetLogsQueue;
    private LinkedBlockingQueue<MethodExecutionLog> sqlExecutionLogsQueue;
    private BeeMethodLogListener listener;

    MethodExecutionLogCache() {
    }

    void init(String poolName, int cacheSize, long slowGet, long slowExec, BeeMethodLogListener listener) {
        this.poolName = poolName;
        this.listener = listener;
        this.slowConnectionThreshold = slowGet;
        this.slowSQLThreshold = slowExec;
        this.maxSize = cacheSize;
        this.connectionGetLogsQueue = new LinkedBlockingQueue(cacheSize);
        this.sqlExecutionLogsQueue = new LinkedBlockingQueue(cacheSize);
    }

    public void setMethodExecutionListener(BeeMethodLogListener handler) {
        this.listener = handler;
    }

    public BeeMethodLog beforeCall(int type, String method, Object[] parameters, String sql, Statement statement) throws SQLException {
        MethodExecutionLog log = new MethodExecutionLog(this.poolName, type, method, parameters, statement);
        this.offerQueue(log, type, parameters, sql);
        if (this.listener != null) {
            this.listener.onMethodStart(log);
        }
        return log;
    }

    private void offerQueue(MethodExecutionLog log, int type, Object[] parameters, String sql) {
        LinkedBlockingQueue<MethodExecutionLog> queue;
        if (type == 1) {
            queue = this.connectionGetLogsQueue;
        } else {
            queue = this.sqlExecutionLogsQueue;
            if (parameters == null || parameters.length == 0) {
                log.setSql(sql);
            } else {
                log.setSql((String)parameters[0]);
            }
        }
        while (!queue.offer(log)) {
            MethodExecutionLog firstLog;
            if (queue.size() != this.maxSize || (firstLog = queue.poll()) == null) continue;
            firstLog.setRemoved(true);
        }
    }

    public void afterCall(Object callResult, long preparationTookTime, Object[] preparedParameters, BeeMethodLog log) throws SQLException {
        MethodExecutionLog defaultTypeLog = (MethodExecutionLog)log;
        defaultTypeLog.setResult(callResult, preparationTookTime, preparedParameters);
        int logType = defaultTypeLog.getType();
        if (defaultTypeLog.isRemoved()) {
            defaultTypeLog.setRemoved(false);
            this.offerQueue(defaultTypeLog, logType, defaultTypeLog.getParameters(), defaultTypeLog.getSql());
        }
        defaultTypeLog.setAsSlow(0L, 1 == logType ? this.slowConnectionThreshold : this.slowSQLThreshold);
        if (this.listener != null) {
            this.listener.onMethodEnd(log);
        }
    }

    public List<BeeMethodLog> getLog(int type) {
        LinkedList<BeeMethodLog> logList = new LinkedList<BeeMethodLog>();
        switch (type) {
            case 1: {
                logList.addAll(this.connectionGetLogsQueue);
                break;
            }
            case 2: {
                for (BeeMethodLog beeMethodLog : this.sqlExecutionLogsQueue) {
                    if (beeMethodLog.getType() != 2) continue;
                    logList.add(beeMethodLog);
                }
                break;
            }
            case 3: {
                logList.addAll(this.sqlExecutionLogsQueue);
                break;
            }
            default: {
                logList.addAll(this.connectionGetLogsQueue);
                logList.addAll(this.sqlExecutionLogsQueue);
            }
        }
        return logList;
    }

    public void clear(int type) {
        LinkedList<BeeMethodLog> removedLogList = new LinkedList<BeeMethodLog>();
        switch (type) {
            case 1: {
                this.connectionGetLogsQueue.drainTo(removedLogList);
                break;
            }
            case 2: {
                for (BeeMethodLog beeMethodLog : this.sqlExecutionLogsQueue) {
                    if (beeMethodLog.getType() != 2) continue;
                    removedLogList.add(beeMethodLog);
                }
                if (removedLogList.isEmpty()) break;
                this.sqlExecutionLogsQueue.removeAll(removedLogList);
                break;
            }
            case 3: {
                this.sqlExecutionLogsQueue.drainTo(removedLogList);
                break;
            }
            default: {
                this.connectionGetLogsQueue.drainTo(removedLogList);
                this.sqlExecutionLogsQueue.drainTo(removedLogList);
            }
        }
        for (BeeMethodLog beeMethodLog : removedLogList) {
            ((MethodExecutionLog)beeMethodLog).setRemoved(true);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void clearTimeout(long timeout) {
        ArrayList<BeeMethodLog> longRunningLogList = new ArrayList<BeeMethodLog>(1);
        LinkedList<MethodExecutionLog> conPendingRemovalLogList = new LinkedList<MethodExecutionLog>();
        LinkedList<MethodExecutionLog> sqlPendingRemovalLogList = new LinkedList<MethodExecutionLog>();
        long currentTime = System.currentTimeMillis();
        for (MethodExecutionLog methodExecutionLog : this.connectionGetLogsQueue) {
            if (currentTime - methodExecutionLog.getStartTime() - timeout >= 0L) {
                conPendingRemovalLogList.add(methodExecutionLog);
            }
            methodExecutionLog.setAsSlow(currentTime, this.slowConnectionThreshold);
            if (!methodExecutionLog.isLongRunning() || methodExecutionLog.hasHandledByListener()) continue;
            longRunningLogList.add(methodExecutionLog);
        }
        for (MethodExecutionLog methodExecutionLog : this.sqlExecutionLogsQueue) {
            if (currentTime - methodExecutionLog.getStartTime() - timeout >= 0L) {
                sqlPendingRemovalLogList.add(methodExecutionLog);
                if (methodExecutionLog.getEndTime() == 0L) {
                    conPendingRemovalLogList.add(methodExecutionLog);
                }
            }
            methodExecutionLog.setAsSlow(currentTime, this.slowSQLThreshold);
            if (!methodExecutionLog.isLongRunning() || methodExecutionLog.hasHandledByListener()) continue;
            longRunningLogList.add(methodExecutionLog);
        }
        if (!conPendingRemovalLogList.isEmpty()) {
            this.connectionGetLogsQueue.removeAll(conPendingRemovalLogList);
            for (BeeMethodLog beeMethodLog : conPendingRemovalLogList) {
                ((MethodExecutionLog)beeMethodLog).setRemoved(true);
            }
        }
        if (!sqlPendingRemovalLogList.isEmpty()) {
            this.sqlExecutionLogsQueue.removeAll(sqlPendingRemovalLogList);
            for (BeeMethodLog beeMethodLog : sqlPendingRemovalLogList) {
                ((MethodExecutionLog)beeMethodLog).setRemoved(true);
            }
        }
        if (!longRunningLogList.isEmpty() && this.listener != null) {
            try {
                List<Boolean> processFlags = this.listener.onLongRunningDetected(longRunningLogList);
                if (processFlags != null && !processFlags.isEmpty()) {
                    void var9_16;
                    boolean bl = false;
                    int l = processFlags.size();
                    while (var9_16 < l) {
                        ((MethodExecutionLog)longRunningLogList.get((int)var9_16)).setHandled(processFlags.get((int)var9_16));
                        ++var9_16;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public boolean cancelStatement(Object logId) throws SQLException {
        if (logId == null) {
            return false;
        }
        for (BeeMethodLog beeMethodLog : this.sqlExecutionLogsQueue) {
            if (!logId.equals(beeMethodLog.getId())) continue;
            return beeMethodLog.cancelStatement();
        }
        return false;
    }
}

