/*
 * Decompiled with CFR 0.152.
 */
package org.stone.beecp.pool;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.LoaderClassPath;
import javassist.Modifier;
import org.stone.beecp.pool.ConnectionPoolStatics;
import org.stone.beecp.pool.MethodExecutionLogCache;
import org.stone.beecp.pool.PooledConnection;
import org.stone.beecp.pool.ProxyConnectionBase;
import org.stone.beecp.pool.ProxyConnectionFactory;
import org.stone.beecp.pool.ProxyConnectionFactory4L;
import org.stone.beecp.pool.ProxyDatabaseMetaDataBase;
import org.stone.beecp.pool.ProxyResultSetBase;
import org.stone.beecp.pool.ProxyResultSetMetaDataBase;
import org.stone.beecp.pool.ProxyStatementBase;
import org.stone.tools.BeanUtil;
import org.stone.tools.CommonUtil;

final class ProxyClassesGenerator {
    private static final String DefaultFolder = "stone/target/classes";

    ProxyClassesGenerator() {
    }

    public static void main(String[] args) throws Exception {
        String classesFolder = "";
        if (args != null && args.length > 0) {
            classesFolder = args[0];
        }
        if (CommonUtil.isBlank(classesFolder)) {
            classesFolder = DefaultFolder;
        }
        ProxyClassesGenerator.writeProxyFile(classesFolder);
    }

    private static void writeProxyFile(String folder) throws Exception {
        CtClass[] ctClasses;
        for (CtClass ctClass : ctClasses = ProxyClassesGenerator.createProxyClasses()) {
            ctClass.writeFile(folder);
        }
    }

    private static CtClass[] createProxyClasses() throws Exception {
        ClassPool classPool = ClassPool.getDefault();
        classPool.importPackage("java.sql");
        classPool.importPackage("org.stone.beecp");
        classPool.importPackage("org.stone.beecp.pool");
        classPool.appendClassPath((ClassPath)new LoaderClassPath(BeanUtil.BeeClassLoader));
        CtClass ctConnectionClass = classPool.get(Connection.class.getName());
        CtClass ctProxyConnectionBaseClass = classPool.get(ProxyConnectionBase.class.getName());
        CtClass ctPooledConnectionClass = classPool.get(PooledConnection.class.getName());
        CtClass ctBeeMethodLogCacheClass = classPool.get(MethodExecutionLogCache.class.getName());
        CtClass ctProxyConnectionClass = classPool.makeClass("org.stone.beecp.pool.ProxyConnection", ctProxyConnectionBaseClass);
        CtConstructor ctConstructor = new CtConstructor(new CtClass[]{ctPooledConnectionClass}, ctProxyConnectionClass);
        ctConstructor.setBody("{super($$);}");
        ctProxyConnectionClass.addConstructor(ctConstructor);
        ctConstructor = new CtConstructor(new CtClass[]{ctPooledConnectionClass, ctBeeMethodLogCacheClass}, ctProxyConnectionClass);
        ctConstructor.setBody("{super($$);}");
        ctProxyConnectionClass.addConstructor(ctConstructor);
        CtClass ctLongClass = classPool.get("long");
        CtClass ctStringClass = classPool.get("java.lang.String");
        CtClass ctStatementClass = classPool.get(Statement.class.getName());
        CtClass ctProxyStatementBaseClass = classPool.get(ProxyStatementBase.class.getName());
        CtClass ctProxyStatementClass = classPool.makeClass("org.stone.beecp.pool.ProxyStatement", ctProxyStatementBaseClass);
        CtClass[] statementCreateParamTypes = new CtClass[]{ctStatementClass, ctProxyConnectionBaseClass, ctPooledConnectionClass};
        ctConstructor = new CtConstructor(statementCreateParamTypes, ctProxyStatementClass);
        ctConstructor.setBody("{super($$);}");
        ctProxyStatementClass.addConstructor(ctConstructor);
        CtClass[] tStatementCreateParamTypes = new CtClass[]{ctStatementClass, ctProxyConnectionBaseClass, ctPooledConnectionClass, ctLongClass, ctStringClass};
        ctConstructor = new CtConstructor(tStatementCreateParamTypes, ctProxyStatementClass);
        ctConstructor.setBody("{super($$);}");
        ctProxyStatementClass.addConstructor(ctConstructor);
        CtClass ctPreparedStatementClass = classPool.get(PreparedStatement.class.getName());
        CtClass ctProxyPsStatementClass = classPool.makeClass("org.stone.beecp.pool.ProxyPsStatement", ctProxyStatementClass);
        ctProxyPsStatementClass.setInterfaces(new CtClass[]{ctPreparedStatementClass});
        CtClass[] statementPsCreateParamTypes = new CtClass[]{ctPreparedStatementClass, ctProxyConnectionBaseClass, ctPooledConnectionClass};
        ctConstructor = new CtConstructor(statementPsCreateParamTypes, ctProxyPsStatementClass);
        ctConstructor.setBody("{super($$);}");
        ctProxyPsStatementClass.addConstructor(ctConstructor);
        CtClass[] tStatementPsCreateParamTypes = new CtClass[]{ctPreparedStatementClass, ctProxyConnectionBaseClass, ctPooledConnectionClass, ctLongClass, ctStringClass};
        ctConstructor = new CtConstructor(tStatementPsCreateParamTypes, ctProxyPsStatementClass);
        ctConstructor.setBody("{super($$);}");
        ctProxyPsStatementClass.addConstructor(ctConstructor);
        CtClass ctCallableStatementClass = classPool.get(CallableStatement.class.getName());
        CtClass ctProxyCsStatementClass = classPool.makeClass("org.stone.beecp.pool.ProxyCsStatement", ctProxyPsStatementClass);
        ctProxyCsStatementClass.setInterfaces(new CtClass[]{ctCallableStatementClass});
        CtClass[] statementCsCreateParamTypes = new CtClass[]{ctCallableStatementClass, ctProxyConnectionBaseClass, ctPooledConnectionClass};
        ctConstructor = new CtConstructor(statementCsCreateParamTypes, ctProxyCsStatementClass);
        ctConstructor.setBody("{super($$);}");
        ctProxyCsStatementClass.addConstructor(ctConstructor);
        CtClass[] tStatementCsCreateParamTypes = new CtClass[]{ctCallableStatementClass, ctProxyConnectionBaseClass, ctPooledConnectionClass, ctLongClass, ctStringClass};
        ctConstructor = new CtConstructor(tStatementCsCreateParamTypes, ctProxyCsStatementClass);
        ctConstructor.setBody("{super($$);}");
        ctProxyCsStatementClass.addConstructor(ctConstructor);
        CtClass ctDatabaseMetaDataClass = classPool.get(DatabaseMetaData.class.getName());
        CtClass ctProxyDatabaseMetaDataBaseClass = classPool.get(ProxyDatabaseMetaDataBase.class.getName());
        CtClass ctProxyDatabaseMetaDataClass = classPool.makeClass("org.stone.beecp.pool.ProxyDatabaseMetaData", ctProxyDatabaseMetaDataBaseClass);
        ctProxyDatabaseMetaDataClass.setModifiers(16);
        CtClass[] databaseMetaDataTypes = new CtClass[]{ctDatabaseMetaDataClass, ctPooledConnectionClass};
        ctConstructor = new CtConstructor(databaseMetaDataTypes, ctProxyDatabaseMetaDataClass);
        ctConstructor.setBody("{super($$);}");
        ctProxyDatabaseMetaDataClass.addConstructor(ctConstructor);
        CtClass ctResultSetClass = classPool.get(ResultSet.class.getName());
        CtClass ctProxyResultSetBaseClass = classPool.get(ProxyResultSetBase.class.getName());
        CtClass ctProxyResultSetClass = classPool.makeClass("org.stone.beecp.pool.ProxyResultSet", ctProxyResultSetBaseClass);
        ctProxyResultSetClass.setModifiers(16);
        CtClass[] resultSetCreateParamTypes1 = new CtClass[]{ctResultSetClass, ctPooledConnectionClass};
        ctConstructor = new CtConstructor(resultSetCreateParamTypes1, ctProxyResultSetClass);
        ctConstructor.setBody("{super($$);}");
        ctProxyResultSetClass.addConstructor(ctConstructor);
        CtClass[] resultSetCreateParamTypes = new CtClass[]{ctResultSetClass, ctProxyStatementBaseClass, ctPooledConnectionClass};
        ctConstructor = new CtConstructor(resultSetCreateParamTypes, ctProxyResultSetClass);
        ctConstructor.setBody("{super($$);}");
        ctProxyResultSetClass.addConstructor(ctConstructor);
        CtClass ctResultSetMetaDataClass = classPool.get(ResultSetMetaData.class.getName());
        CtClass ctProxyResultSetMetaDataBaseClass = classPool.get(ProxyResultSetMetaDataBase.class.getName());
        CtClass ctProxyResultSetMetaDataClass = classPool.makeClass("org.stone.beecp.pool.ProxyResultSetMetaData", ctProxyResultSetMetaDataBaseClass);
        ctProxyResultSetMetaDataClass.setModifiers(16);
        CtClass[] resultSetMetaDataCreateParamTypes = new CtClass[]{ctResultSetMetaDataClass, ctProxyResultSetBaseClass, ctPooledConnectionClass};
        ctConstructor = new CtConstructor(resultSetMetaDataCreateParamTypes, ctProxyResultSetMetaDataClass);
        ctConstructor.setBody("{super($$);}");
        ctProxyResultSetMetaDataClass.addConstructor(ctConstructor);
        ProxyClassesGenerator.addMethodsToProxyConnectionClass(classPool, ctProxyConnectionClass, ctConnectionClass, ctProxyConnectionBaseClass, true);
        ProxyClassesGenerator.addMethodsToProxyStatementClass(classPool, ctProxyStatementClass, ctStatementClass, ctProxyStatementBaseClass, true);
        ProxyClassesGenerator.addMethodsToProxyStatementClass(classPool, ctProxyPsStatementClass, ctPreparedStatementClass, ctProxyStatementClass, true);
        ProxyClassesGenerator.addMethodsToProxyStatementClass(classPool, ctProxyCsStatementClass, ctCallableStatementClass, ctProxyPsStatementClass, true);
        ProxyClassesGenerator.addMethodsToProxyDatabaseMetaDataClass(classPool, ctProxyDatabaseMetaDataClass, ctDatabaseMetaDataClass, ctProxyDatabaseMetaDataBaseClass);
        ProxyClassesGenerator.addOverrideMethodsForProxyResultSetClass(classPool, ctProxyResultSetClass, ctResultSetClass, ctProxyResultSetBaseClass);
        ProxyClassesGenerator.addOverrideMethodsForProxyResultSetMetaDataClass(ctProxyResultSetMetaDataClass, ctResultSetMetaDataClass, ctProxyResultSetMetaDataBaseClass);
        CtClass ctProxyConnection4LClass = classPool.makeClass("org.stone.beecp.pool.ProxyConnection4L", ctProxyConnectionClass);
        ctProxyConnection4LClass.setModifiers(17);
        ctConstructor = new CtConstructor(new CtClass[]{ctPooledConnectionClass, ctBeeMethodLogCacheClass}, ctProxyConnection4LClass);
        ctConstructor.setBody("{super($$);}");
        ctProxyConnection4LClass.addConstructor(ctConstructor);
        CtClass ctProxyStatement4LClass = classPool.makeClass("org.stone.beecp.pool.ProxyStatement4L", ctProxyStatementClass);
        ctProxyStatement4LClass.setModifiers(17);
        ctConstructor = new CtConstructor(tStatementCreateParamTypes, ctProxyStatement4LClass);
        ctConstructor.setBody("{super($$);}");
        ctProxyStatement4LClass.addConstructor(ctConstructor);
        CtClass ctProxyPsStatement4LClass = classPool.makeClass("org.stone.beecp.pool.ProxyPsStatement4L", ctProxyStatementClass);
        ctProxyPsStatement4LClass.setInterfaces(new CtClass[]{ctPreparedStatementClass});
        ctProxyPsStatement4LClass.setModifiers(17);
        ctConstructor = new CtConstructor(tStatementPsCreateParamTypes, ctProxyPsStatement4LClass);
        ctConstructor.setBody("{super($$);}");
        ctProxyPsStatement4LClass.addConstructor(ctConstructor);
        CtClass ctProxyCsStatement4LClass = classPool.makeClass("org.stone.beecp.pool.ProxyCsStatement4L", ctProxyCsStatementClass);
        ctProxyCsStatement4LClass.setInterfaces(new CtClass[]{ctCallableStatementClass});
        ctProxyCsStatement4LClass.setModifiers(17);
        ctConstructor = new CtConstructor(tStatementCsCreateParamTypes, ctProxyCsStatement4LClass);
        ctConstructor.setBody("{super($$);}");
        ctProxyCsStatement4LClass.addConstructor(ctConstructor);
        ProxyClassesGenerator.addMethodsToProxyConnectionClass(classPool, ctProxyConnection4LClass, ctConnectionClass, ctProxyConnectionClass, false);
        ProxyClassesGenerator.addMethodsToProxyStatementClass(classPool, ctProxyStatement4LClass, ctStatementClass, ctProxyStatementClass, false);
        ProxyClassesGenerator.addMethodsToProxyStatementClass(classPool, ctProxyPsStatement4LClass, ctPreparedStatementClass, ctProxyStatementClass, false);
        ProxyClassesGenerator.addMethodsToProxyStatementClass(classPool, ctProxyCsStatement4LClass, ctCallableStatementClass, ctProxyPsStatementClass, false);
        CtClass ctProxyObjectFactoryClass = classPool.get(ProxyConnectionFactory.class.getName());
        for (CtMethod method : ctProxyObjectFactoryClass.getDeclaredMethods()) {
            if (!"createProxyConnection".equals(method.getName())) continue;
            method.setBody("{return new ProxyConnection($$);}");
            break;
        }
        CtClass ctProxyObjectFactory4LClass = classPool.get(ProxyConnectionFactory4L.class.getName());
        for (CtMethod method : ctProxyObjectFactory4LClass.getDeclaredMethods()) {
            if (!"createProxyConnection".equals(method.getName())) continue;
            method.setBody("{return new ProxyConnection4L($$,logCache);}");
            break;
        }
        CtClass ctConnectionPoolStaticsClass = classPool.get(ConnectionPoolStatics.class.getName());
        for (CtMethod method : ctConnectionPoolStaticsClass.getDeclaredMethods()) {
            if (!"createProxyResultSet".equals(method.getName())) continue;
            method.setBody("{return new ProxyResultSet($$);}");
            break;
        }
        return new CtClass[]{ctProxyConnectionClass, ctProxyStatementClass, ctProxyPsStatementClass, ctProxyCsStatementClass, ctProxyDatabaseMetaDataClass, ctProxyResultSetClass, ctProxyResultSetMetaDataClass, ctProxyObjectFactoryClass, ctConnectionPoolStaticsClass, ctProxyConnection4LClass, ctProxyStatement4LClass, ctProxyPsStatement4LClass, ctProxyCsStatement4LClass, ctProxyObjectFactory4LClass};
    }

    private static HashSet<String> findMethodsNotNeedProxy(CtClass baseClass) {
        HashSet<String> notNeedAddProxyMethods = new HashSet<String>(16);
        for (CtMethod ctSuperClassMethod : baseClass.getMethods()) {
            int modifiers = ctSuperClassMethod.getModifiers();
            if ((Modifier.isAbstract((int)modifiers) || !Modifier.isPublic((int)modifiers) && !Modifier.isProtected((int)modifiers)) && !Modifier.isFinal((int)modifiers) && !Modifier.isStatic((int)modifiers) && !Modifier.isNative((int)modifiers)) continue;
            notNeedAddProxyMethods.add(ctSuperClassMethod.getName() + ctSuperClassMethod.getSignature());
        }
        return notNeedAddProxyMethods;
    }

    private static void addMethodsToProxyConnectionClass(ClassPool classPool, CtClass ctConnectionClassProxyClass, CtClass ctConnectionClass, CtClass ctConBaseClass, boolean noTrace) throws Exception {
        ArrayList<CtMethod> linkedList = new ArrayList<CtMethod>(50);
        CtClass ctStatementClass = classPool.get(Statement.class.getName());
        CtClass ctPreparedStatementClass = classPool.get(PreparedStatement.class.getName());
        CtClass ctCallableStatementClass = classPool.get(CallableStatement.class.getName());
        CtClass ctDatabaseMetaDataClass = classPool.get(DatabaseMetaData.class.getName());
        if (noTrace) {
            HashSet<String> notNeedAddProxyMethods = ProxyClassesGenerator.findMethodsNotNeedProxy(ctConBaseClass);
            ProxyClassesGenerator.resolveInterfaceMethods(ctConnectionClass, linkedList, notNeedAddProxyMethods);
            StringBuilder methodBuffer = new StringBuilder(50);
            for (CtMethod ctMethod : linkedList) {
                CtClass ctResultType;
                String methodName = ctMethod.getName();
                CtMethod newCtMethod = CtNewMethod.copy((CtMethod)ctMethod, (CtClass)ctConnectionClassProxyClass, null);
                newCtMethod.setModifiers(1);
                methodBuffer.delete(0, methodBuffer.length());
                methodBuffer.append("{");
                boolean existsSQLException = ProxyClassesGenerator.exitsSQLException(ctMethod.getExceptionTypes());
                if (existsSQLException) {
                    methodBuffer.append("  try{");
                }
                if ((ctResultType = ctMethod.getReturnType()) == ctStatementClass) {
                    methodBuffer.append("return new ProxyStatement(raw.").append(methodName).append("($$),this,p);");
                } else if (ctResultType == ctPreparedStatementClass) {
                    methodBuffer.append("return new ProxyPsStatement(raw.").append(methodName).append("($$),this,p);");
                } else if (ctResultType == ctCallableStatementClass) {
                    methodBuffer.append("return new ProxyCsStatement(raw.").append(methodName).append("($$),this,p);");
                } else if (ctResultType == ctDatabaseMetaDataClass) {
                    methodBuffer.append("return new ProxyDatabaseMetaData(raw.").append(methodName).append("($$),p);");
                } else {
                    if (methodName.equals("close")) continue;
                    if (ctResultType == CtClass.voidType) {
                        methodBuffer.append("raw.").append(methodName).append("($$);");
                    } else {
                        methodBuffer.append("return raw.").append(methodName).append("($$);");
                    }
                }
                if (existsSQLException) {
                    methodBuffer.append(" }catch(SQLException e){ p.checkSQLException(e);throw e;}");
                }
                methodBuffer.append("}");
                newCtMethod.setBody(methodBuffer.toString());
                ctConnectionClassProxyClass.addMethod(newCtMethod);
            }
        } else {
            ProxyClassesGenerator.getConnectionStatementMethods(classPool, ctConnectionClass, linkedList);
            StringBuilder methodBuffer = new StringBuilder(50);
            for (CtMethod ctMethod : linkedList) {
                int i;
                int methodParameterSize;
                CtClass[] parameterTypes;
                String methodSignature;
                String methodName = ctMethod.getName();
                CtMethod newCtMethod = CtNewMethod.copy((CtMethod)ctMethod, (CtClass)ctConnectionClassProxyClass, null);
                newCtMethod.setModifiers(1);
                methodBuffer.delete(0, methodBuffer.length());
                methodBuffer.append("{");
                boolean existsSQLException = ProxyClassesGenerator.exitsSQLException(ctMethod.getExceptionTypes());
                CtClass ctResultType = ctMethod.getReturnType();
                if (ctResultType == ctStatementClass) {
                    if (existsSQLException) {
                        methodBuffer.append(" try{");
                    }
                    methodBuffer.append("return new ProxyStatement4L(raw.").append(methodName).append("($$),this,p,0L,null);");
                    if (existsSQLException) {
                        methodBuffer.append(" }catch(SQLException e){");
                        methodBuffer.append(" p.checkSQLException(e);throw e;}");
                    }
                } else if (ctResultType == ctPreparedStatementClass) {
                    methodSignature = ProxyClassesGenerator.getCtMethodSignature("Connection", ctMethod);
                    parameterTypes = ctMethod.getParameterTypes();
                    methodParameterSize = parameterTypes.length;
                    if (methodParameterSize == 0) {
                        methodBuffer.append("BeeMethodLog log = logCache.beforeCall(BeeMethodLog.Type_Statement_Log,").append(methodSignature).append(",null,null,null);");
                    } else {
                        methodBuffer.append("Object[]parameters = new Object[]{");
                        for (i = 0; i < methodParameterSize; ++i) {
                            if (i > 0) {
                                methodBuffer.append(",");
                            }
                            methodBuffer.append(ProxyClassesGenerator.getConvertType("$" + (i + 1), parameterTypes[i]));
                        }
                        methodBuffer.append("};");
                        methodBuffer.append("BeeMethodLog log = logCache.beforeCall(BeeMethodLog.Type_Statement_Log,").append(methodSignature).append(",parameters,null,null);");
                    }
                    if (existsSQLException) {
                        methodBuffer.append(" try{");
                    }
                    methodBuffer.append(ctResultType.getName()).append(" re=raw.").append(methodName).append("($$);");
                    methodBuffer.append("logCache.afterCall(re,0L,null,log);");
                    methodBuffer.append("return new ProxyPsStatement4L(re,this,p,log.getEndTime() - log.getStartTime(),$1);");
                    if (existsSQLException) {
                        methodBuffer.append(" }catch(SQLException e){");
                        methodBuffer.append(" p.checkSQLException(e);");
                        methodBuffer.append(" logCache.afterCall(e,0L,null,log);");
                        methodBuffer.append(" throw e;}");
                    }
                } else if (ctResultType == ctCallableStatementClass) {
                    methodSignature = ProxyClassesGenerator.getCtMethodSignature("Connection", ctMethod);
                    parameterTypes = ctMethod.getParameterTypes();
                    methodParameterSize = parameterTypes.length;
                    if (methodParameterSize == 0) {
                        methodBuffer.append("BeeMethodLog log = logCache.beforeCall(BeeMethodLog.Type_Connection_Log,").append(methodSignature).append(",null,null,null);");
                    } else {
                        methodBuffer.append("Object[]parameters = new Object[]{");
                        for (i = 0; i < methodParameterSize; ++i) {
                            if (i > 0) {
                                methodBuffer.append(",");
                            }
                            methodBuffer.append(ProxyClassesGenerator.getConvertType("$" + (i + 1), parameterTypes[i]));
                        }
                        methodBuffer.append("};");
                        methodBuffer.append("BeeMethodLog log = logCache.beforeCall(BeeMethodLog.Type_Connection_Log,").append(methodSignature).append(",parameters,null,null);");
                    }
                    if (existsSQLException) {
                        methodBuffer.append(" try{");
                    }
                    methodBuffer.append(ctResultType.getName()).append(" re=raw.").append(methodName).append("($$);");
                    methodBuffer.append("logCache.afterCall(re,0L,null,log);");
                    methodBuffer.append("return new ProxyCsStatement4L(re,this,p,log.getEndTime()-log.getStartTime(),$1);");
                    if (existsSQLException) {
                        methodBuffer.append(" }catch(SQLException e){");
                        methodBuffer.append(" p.checkSQLException(e);");
                        methodBuffer.append(" logCache.afterCall(e,0L,null,log);");
                        methodBuffer.append(" throw e;}");
                    }
                }
                methodBuffer.append("}");
                newCtMethod.setBody(methodBuffer.toString());
                ctConnectionClassProxyClass.addMethod(newCtMethod);
            }
        }
    }

    private static void addMethodsToProxyStatementClass(ClassPool classPool, CtClass statementProxyClass, CtClass ctStatementClass, CtClass ctStatementSuperClass, boolean noTrace) throws Exception {
        ArrayList<CtMethod> linkedList = new ArrayList<CtMethod>(50);
        if (noTrace) {
            HashSet<String> notNeedAddProxyMethods = ProxyClassesGenerator.findMethodsNotNeedProxy(ctStatementSuperClass);
            ProxyClassesGenerator.resolveInterfaceMethods(ctStatementClass, linkedList, notNeedAddProxyMethods);
            CtClass ctResultSetClass = classPool.get(ResultSet.class.getName());
            StringBuilder methodBuffer = new StringBuilder(50);
            String rawName = "raw.";
            if ("java.sql.PreparedStatement".equals(ctStatementClass.getName())) {
                rawName = "((PreparedStatement)raw).";
            } else if ("java.sql.CallableStatement".equals(ctStatementClass.getName())) {
                rawName = "((CallableStatement)raw).";
            }
            for (CtMethod ctMethod : linkedList) {
                methodBuffer.delete(0, methodBuffer.length());
                methodBuffer.append("{");
                boolean existsSQLException = ProxyClassesGenerator.exitsSQLException(ctMethod.getExceptionTypes());
                if (existsSQLException) {
                    methodBuffer.append("  try{");
                }
                String methodName = ctMethod.getName();
                CtClass ctResultType = ctMethod.getReturnType();
                boolean executeMethod = methodName.startsWith("execute");
                if (executeMethod) {
                    methodBuffer.append("p.commitDirtyInd=!p.curAutoCommit;");
                }
                if (ctResultType == CtClass.voidType) {
                    methodBuffer.append(rawName).append(methodName).append("($$);");
                } else {
                    methodBuffer.append(ctResultType.getName()).append(" r=").append(rawName).append(methodName).append("($$);");
                }
                if (executeMethod) {
                    methodBuffer.append("p.lastAccessTime=System.currentTimeMillis();");
                }
                if (ctResultType == ctResultSetClass) {
                    methodBuffer.append("return new ProxyResultSet(r,this,p);");
                } else if (ctResultType != CtClass.voidType) {
                    methodBuffer.append("return r;");
                }
                if (existsSQLException) {
                    methodBuffer.append(" }catch(SQLException e){ p.checkSQLException(e);throw e;}");
                }
                methodBuffer.append("}");
                CtMethod newCtMethod = CtNewMethod.copy((CtMethod)ctMethod, (CtClass)statementProxyClass, null);
                newCtMethod.setBody(methodBuffer.toString());
                statementProxyClass.addMethod(newCtMethod);
            }
        } else {
            String statementType;
            ProxyClassesGenerator.getStatementExecutionMethods(ctStatementClass, linkedList);
            CtClass ctResultSetClass = classPool.get(ResultSet.class.getName());
            StringBuilder methodBuffer = new StringBuilder(50);
            String rawName = "raw.";
            if ("java.sql.PreparedStatement".equals(ctStatementClass.getName())) {
                statementType = "PreparedStatement";
                rawName = "((PreparedStatement)raw).";
            } else if ("java.sql.CallableStatement".equals(ctStatementClass.getName())) {
                statementType = "CallableStatement";
                rawName = "((CallableStatement)raw).";
            } else {
                statementType = "Statement";
            }
            for (CtMethod ctMethod : linkedList) {
                methodBuffer.delete(0, methodBuffer.length());
                methodBuffer.append("{");
                String methodName = ctMethod.getName();
                CtClass ctResultType = ctMethod.getReturnType();
                String methodSignature = ProxyClassesGenerator.getCtMethodSignature(statementType, ctMethod);
                CtClass[] parameterTypes = ctMethod.getParameterTypes();
                int methodParameterSize = parameterTypes.length;
                if (methodParameterSize == 0) {
                    methodBuffer.append("BeeMethodLog log = logCache.beforeCall(BeeMethodLog.Type_Statement_Log,").append(methodSignature).append(",null,preparedSql,this);");
                } else {
                    methodBuffer.append("Object[]parameters = new Object[]{");
                    for (int i = 0; i < methodParameterSize; ++i) {
                        if (i > 0) {
                            methodBuffer.append(",");
                        }
                        methodBuffer.append(ProxyClassesGenerator.getConvertType("$" + (i + 1), parameterTypes[i]));
                    }
                    methodBuffer.append("};");
                    methodBuffer.append("BeeMethodLog log = logCache.beforeCall(BeeMethodLog.Type_Statement_Log,").append(methodSignature).append(",parameters,preparedSql,this);");
                }
                boolean existsSQLException = ProxyClassesGenerator.exitsSQLException(ctMethod.getExceptionTypes());
                if (existsSQLException) {
                    methodBuffer.append("  try{");
                }
                methodBuffer.append("p.commitDirtyInd=!p.curAutoCommit;");
                if (ctResultType == CtClass.voidType) {
                    methodBuffer.append(rawName).append(methodName).append("($$);");
                } else {
                    methodBuffer.append(ctResultType.getName()).append(" r=").append(rawName).append(methodName).append("($$);");
                }
                methodBuffer.append("p.lastAccessTime=System.currentTimeMillis();");
                if (ctResultType == CtClass.voidType) {
                    methodBuffer.append("logCache.afterCall(null,preparationTookTime,null,log);");
                } else {
                    methodBuffer.append("logCache.afterCall(").append(ProxyClassesGenerator.getConvertType("r", ctResultType)).append(",preparationTookTime,null,log);");
                }
                if (ctResultType == ctResultSetClass) {
                    methodBuffer.append("return new ProxyResultSet(r,this,p);");
                } else if (ctResultType != CtClass.voidType) {
                    methodBuffer.append("return r;");
                }
                if (existsSQLException) {
                    methodBuffer.append(" }catch(SQLException e){");
                    methodBuffer.append(" p.checkSQLException(e);");
                    methodBuffer.append(" logCache.afterCall(e,preparationTookTime,null,log);");
                    methodBuffer.append(" throw e;}");
                }
                methodBuffer.append("}");
                CtMethod newCtMethod = CtNewMethod.copy((CtMethod)ctMethod, (CtClass)statementProxyClass, null);
                newCtMethod.setBody(methodBuffer.toString());
                statementProxyClass.addMethod(newCtMethod);
            }
        }
    }

    private static String getConvertType(String variableName, CtClass parameterType) {
        if (parameterType.isPrimitive()) {
            String typeName = parameterType.getName();
            if ("boolean".equals(typeName)) {
                return "Boolean.valueOf(" + variableName + ")";
            }
            if ("byte".equals(typeName)) {
                return "Byte.valueOf(" + variableName + ")";
            }
            if ("short".equals(typeName)) {
                return "Short.valueOf(" + variableName + ")";
            }
            if ("int".equals(typeName)) {
                return "Integer.valueOf(" + variableName + ")";
            }
            if ("long".equals(typeName)) {
                return "Long.valueOf(" + variableName + ")";
            }
            if ("float".equals(typeName)) {
                return "Float.valueOf(" + variableName + ")";
            }
            if ("double".equals(typeName)) {
                return "Double.valueOf(" + variableName + ")";
            }
            if ("char".equals(typeName)) {
                return "Character.valueOf(" + variableName + ")";
            }
            return variableName;
        }
        return variableName;
    }

    private static void addMethodsToProxyDatabaseMetaDataClass(ClassPool classPool, CtClass ctProxyDatabaseMetaDataClass, CtClass ctDatabaseMetaDataClass, CtClass ctDatabaseMetaDataSuperClass) throws Exception {
        ArrayList<CtMethod> linkedList = new ArrayList<CtMethod>(50);
        HashSet<String> notNeedAddProxyMethods = ProxyClassesGenerator.findMethodsNotNeedProxy(ctDatabaseMetaDataSuperClass);
        ProxyClassesGenerator.resolveInterfaceMethods(ctDatabaseMetaDataClass, linkedList, notNeedAddProxyMethods);
        CtClass ctResultSetClass = classPool.get(ResultSet.class.getName());
        StringBuilder methodBuffer = new StringBuilder(40);
        for (CtMethod ctMethod : linkedList) {
            String methodName = ctMethod.getName();
            CtMethod newCtMethod = CtNewMethod.copy((CtMethod)ctMethod, (CtClass)ctProxyDatabaseMetaDataClass, null);
            newCtMethod.setModifiers(1);
            methodBuffer.delete(0, methodBuffer.length());
            methodBuffer.append("{").append("this.owner.checkClosed();");
            boolean existsSQLException = ProxyClassesGenerator.exitsSQLException(ctMethod.getExceptionTypes());
            if (existsSQLException) {
                methodBuffer.append("  try{");
            }
            if (ctMethod.getReturnType() == ctResultSetClass) {
                methodBuffer.append("ResultSet r = raw.").append(methodName).append("($$);");
                methodBuffer.append("return r==null?null:new ProxyResultSet(r,p);");
            } else if (ctMethod.getReturnType() == CtClass.voidType) {
                methodBuffer.append("raw.").append(methodName).append("($$);");
            } else {
                methodBuffer.append("return raw.").append(methodName).append("($$);");
            }
            if (existsSQLException) {
                methodBuffer.append(" }catch(SQLException e){ p.checkSQLException(e);throw e;}");
            }
            methodBuffer.append("}");
            newCtMethod.setBody(methodBuffer.toString());
            ctProxyDatabaseMetaDataClass.addMethod(newCtMethod);
        }
    }

    private static void addOverrideMethodsForProxyResultSetClass(ClassPool classPool, CtClass ctResultSetClassProxyClass, CtClass ctResultSetClass, CtClass ctResultSetClassSuperClass) throws Exception {
        ArrayList<CtMethod> linkedList = new ArrayList<CtMethod>(50);
        HashSet<String> notNeedAddProxyMethods = ProxyClassesGenerator.findMethodsNotNeedProxy(ctResultSetClassSuperClass);
        ProxyClassesGenerator.resolveInterfaceMethods(ctResultSetClass, linkedList, notNeedAddProxyMethods);
        CtClass ctResultSetMetaDataClass = classPool.get(ResultSetMetaData.class.getName());
        StringBuilder methodBuffer = new StringBuilder(25);
        for (CtMethod ctMethod : linkedList) {
            String methodName = ctMethod.getName();
            CtMethod newCtMethod = CtNewMethod.copy((CtMethod)ctMethod, (CtClass)ctResultSetClassProxyClass, null);
            newCtMethod.setModifiers(1);
            methodBuffer.delete(0, methodBuffer.length());
            methodBuffer.append("{");
            if (methodName.equals("close")) continue;
            boolean existsSQLException = ProxyClassesGenerator.exitsSQLException(ctMethod.getExceptionTypes());
            if (existsSQLException) {
                methodBuffer.append("  try{");
            }
            if (methodName.startsWith("insert") || methodName.startsWith("update") || methodName.startsWith("delete")) {
                if (ctMethod.getReturnType() == CtClass.voidType) {
                    methodBuffer.append("raw.").append(methodName).append("($$);").append(" p.updateAccessTime();");
                } else {
                    methodBuffer.append(ctMethod.getReturnType().getName()).append(" r=raw.").append(methodName).append("($$);").append(" p.updateAccessTime();").append(" return r;");
                }
            } else {
                CtClass ctReturnType = ctMethod.getReturnType();
                if (ctReturnType == ctResultSetMetaDataClass) {
                    methodBuffer.append("return new ProxyResultSetMetaData(raw.").append(methodName).append("($$),this,p);");
                } else if (ctReturnType == CtClass.voidType) {
                    methodBuffer.append("raw.").append(methodName).append("($$);");
                } else {
                    methodBuffer.append("return raw.").append(methodName).append("($$);");
                }
            }
            if (existsSQLException) {
                methodBuffer.append("  }catch(SQLException e){ p.checkSQLException(e);throw e;}");
            }
            methodBuffer.append("}");
            newCtMethod.setBody(methodBuffer.toString());
            ctResultSetClassProxyClass.addMethod(newCtMethod);
        }
    }

    private static void addOverrideMethodsForProxyResultSetMetaDataClass(CtClass ctProxyResultSetMetaDataClass, CtClass ctResultSetMetaDataClass, CtClass ctResultSetMetaDataSuperClass) throws Exception {
        ArrayList<CtMethod> linkedList = new ArrayList<CtMethod>(50);
        HashSet<String> notNeedAddProxyMethods = ProxyClassesGenerator.findMethodsNotNeedProxy(ctResultSetMetaDataSuperClass);
        ProxyClassesGenerator.resolveInterfaceMethods(ctResultSetMetaDataClass, linkedList, notNeedAddProxyMethods);
        StringBuilder methodBuffer = new StringBuilder(40);
        for (CtMethod ctMethod : linkedList) {
            String methodName = ctMethod.getName();
            CtMethod newCtMethod = CtNewMethod.copy((CtMethod)ctMethod, (CtClass)ctProxyResultSetMetaDataClass, null);
            newCtMethod.setModifiers(1);
            methodBuffer.delete(0, methodBuffer.length());
            methodBuffer.append("{").append("this.owner.checkClosed();");
            boolean existsSQLException = ProxyClassesGenerator.exitsSQLException(ctMethod.getExceptionTypes());
            if (existsSQLException) {
                methodBuffer.append("  try{");
            }
            if (ctMethod.getReturnType() == CtClass.voidType) {
                methodBuffer.append("raw.").append(methodName).append("($$);");
            } else {
                methodBuffer.append("return raw.").append(methodName).append("($$);");
            }
            if (existsSQLException) {
                methodBuffer.append(" }catch(SQLException e){ p.checkSQLException(e);throw e;}");
            }
            methodBuffer.append("}");
            newCtMethod.setBody(methodBuffer.toString());
            ctProxyResultSetMetaDataClass.addMethod(newCtMethod);
        }
    }

    private static boolean exitsSQLException(CtClass[] exceptionTypes) {
        if (exceptionTypes == null) {
            return false;
        }
        for (CtClass exceptionClass : exceptionTypes) {
            if (!"java.sql.SQLException".equals(exceptionClass.getName())) continue;
            return true;
        }
        return false;
    }

    private static String getCtMethodSignature(String methodOwer, CtMethod method) throws Exception {
        StringBuilder builder = new StringBuilder(20);
        builder.append("\"").append(methodOwer).append(".").append(method.getName()).append("(");
        CtClass[] paramTypes = method.getParameterTypes();
        int l = paramTypes.length;
        for (int i = 0; i < l; ++i) {
            if (i > 0) {
                builder.append(",");
            }
            builder.append(paramTypes[i].getName());
        }
        builder.append(")").append("\"");
        return builder.toString();
    }

    private static void resolveInterfaceMethods(CtClass interfaceClass, List<CtMethod> linkedList, HashSet<String> exitSignatureSet) throws Exception {
        for (CtMethod ctMethod : interfaceClass.getDeclaredMethods()) {
            int modifiers = ctMethod.getModifiers();
            String signature = ctMethod.getName() + ctMethod.getSignature();
            if (!Modifier.isAbstract((int)modifiers) || !Modifier.isPublic((int)modifiers) && !Modifier.isProtected((int)modifiers) || Modifier.isStatic((int)modifiers) || Modifier.isFinal((int)modifiers) || exitSignatureSet.contains(signature)) continue;
            linkedList.add(ctMethod);
            exitSignatureSet.add(signature);
        }
        for (CtMethod ctMethod : interfaceClass.getInterfaces()) {
            ProxyClassesGenerator.resolveInterfaceMethods((CtClass)ctMethod, linkedList, exitSignatureSet);
        }
    }

    private static void getConnectionStatementMethods(ClassPool classPool, CtClass ctConnectionInterfaceClass, List<CtMethod> linkedList) throws Exception {
        CtClass ctStatementClass = classPool.get(Statement.class.getName());
        CtClass ctPreparedStatementClass = classPool.get(PreparedStatement.class.getName());
        CtClass ctCallableStatementClass = classPool.get(CallableStatement.class.getName());
        for (CtMethod ctMethod : ctConnectionInterfaceClass.getMethods()) {
            CtClass ctResultType;
            int modifiers = ctMethod.getModifiers();
            if (!Modifier.isAbstract((int)modifiers) || !Modifier.isPublic((int)modifiers) && !Modifier.isProtected((int)modifiers) || Modifier.isStatic((int)modifiers) || Modifier.isFinal((int)modifiers) || (ctResultType = ctMethod.getReturnType()) != ctStatementClass && ctResultType != ctPreparedStatementClass && ctResultType != ctCallableStatementClass) continue;
            linkedList.add(ctMethod);
        }
    }

    private static void getStatementExecutionMethods(CtClass ctStatementInterfaceClass, List<CtMethod> linkedList) {
        for (CtMethod ctMethod : ctStatementInterfaceClass.getMethods()) {
            String methodName = ctMethod.getName();
            if ("executeBatch".equals(methodName) || "executeLargeBatch".equals(methodName) || !methodName.startsWith("execute")) continue;
            linkedList.add(ctMethod);
        }
    }
}

