/*
 * Decompiled with CFR 0.152.
 */
package com.jthemedetecor;

import com.jthemedetecor.OsThemeDetector;
import com.jthemedetecor.util.ConcurrentHashSet;
import com.sun.jna.Callback;
import com.sun.jna.Pointer;
import de.jangassen.jfa.foundation.Foundation;
import de.jangassen.jfa.foundation.ID;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MacOSThemeDetector
extends OsThemeDetector {
    private static final Logger logger = LoggerFactory.getLogger(MacOSThemeDetector.class);
    private final Set<Consumer<Boolean>> listeners = new ConcurrentHashSet<Consumer<Boolean>>();
    private final Pattern themeNamePattern = Pattern.compile(".*dark.*", 2);
    private final ExecutorService callbackExecutor = Executors.newSingleThreadExecutor(DetectorThread::new);
    private final Callback themeChangedCallback = new Callback(){

        public void callback() {
            MacOSThemeDetector.this.callbackExecutor.execute(() -> MacOSThemeDetector.this.notifyListeners(MacOSThemeDetector.this.isDark()));
        }
    };

    MacOSThemeDetector() {
        this.initObserver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initObserver() {
        Foundation.NSAutoreleasePool pool = new Foundation.NSAutoreleasePool();
        try {
            ID delegateClass = Foundation.allocateObjcClassPair((ID)Foundation.getObjcClass((String)"NSObject"), (String)"NSColorChangesObserver");
            if (!ID.NIL.equals((Object)delegateClass)) {
                if (!Foundation.addMethod((ID)delegateClass, (Pointer)Foundation.createSelector((String)"handleAppleThemeChanged:"), (Callback)this.themeChangedCallback, (String)"v@")) {
                    logger.error("Observer method cannot be added");
                }
                Foundation.registerObjcClassPair((ID)delegateClass);
            }
            ID delegate = Foundation.invoke((String)"NSColorChangesObserver", (String)"new", (Object[])new Object[0]);
            Foundation.invoke((ID)Foundation.invoke((String)"NSDistributedNotificationCenter", (String)"defaultCenter", (Object[])new Object[0]), (String)"addObserver:selector:name:object:", (Object[])new Object[]{delegate, Foundation.createSelector((String)"handleAppleThemeChanged:"), Foundation.nsString((String)"AppleInterfaceThemeChangedNotification"), ID.NIL});
        }
        finally {
            pool.drain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDark() {
        Foundation.NSAutoreleasePool pool = new Foundation.NSAutoreleasePool();
        try {
            ID userDefaults = Foundation.invoke((String)"NSUserDefaults", (String)"standardUserDefaults", (Object[])new Object[0]);
            String appleInterfaceStyle = Foundation.toStringViaUTF8((ID)Foundation.invoke((ID)userDefaults, (String)"objectForKey:", (Object[])new Object[]{Foundation.nsString((String)"AppleInterfaceStyle")}));
            boolean bl = this.isDarkTheme(appleInterfaceStyle);
            return bl;
        }
        catch (RuntimeException e) {
            logger.error("Couldn't execute theme name query with the Os", (Throwable)e);
        }
        finally {
            pool.drain();
        }
        return false;
    }

    private boolean isDarkTheme(String themeName) {
        return themeName != null && this.themeNamePattern.matcher(themeName).matches();
    }

    @Override
    public void registerListener(@NotNull Consumer<Boolean> darkThemeListener) {
        this.listeners.add(darkThemeListener);
    }

    @Override
    public void removeListener(@Nullable Consumer<Boolean> darkThemeListener) {
        this.listeners.remove(darkThemeListener);
    }

    private void notifyListeners(boolean isDark) {
        this.listeners.forEach(listener -> listener.accept(isDark));
    }

    private static final class DetectorThread
    extends Thread {
        DetectorThread(@NotNull Runnable runnable) {
            super(runnable);
            this.setName("MacOS Theme Detector Thread");
            this.setDaemon(true);
        }
    }
}

