/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.jdbc;

import com.p6spy.engine.common.ConnectionInformation;
import com.p6spy.engine.common.StatementInformation;
import io.sentry.util.StringUtils;
import java.net.URI;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DatabaseUtils {
    @NotNull
    private static final DatabaseDetails EMPTY = new DatabaseDetails(null, null);

    public static DatabaseDetails readFrom(@Nullable StatementInformation statementInformation) {
        if (statementInformation == null) {
            return EMPTY;
        }
        @Nullable ConnectionInformation connectionInformation = statementInformation.getConnectionInformation();
        return DatabaseUtils.readFrom(connectionInformation);
    }

    public static DatabaseDetails readFrom(@Nullable ConnectionInformation connectionInformation) {
        if (connectionInformation == null) {
            return EMPTY;
        }
        return DatabaseUtils.parse(connectionInformation.getUrl());
    }

    public static DatabaseDetails parse(@Nullable String databaseConnectionUrl) {
        if (databaseConnectionUrl == null) {
            return EMPTY;
        }
        try {
            @NotNull String rawUrl = DatabaseUtils.removeP6SpyPrefix(databaseConnectionUrl.toLowerCase(Locale.ROOT));
            @NotNull String[] urlParts = rawUrl.split(":", -1);
            if (urlParts.length > 1) {
                @NotNull String dbSystem = urlParts[0];
                return DatabaseUtils.parseDbSystemSpecific(dbSystem, urlParts, rawUrl);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return EMPTY;
    }

    @NotNull
    private static DatabaseDetails parseDbSystemSpecific(@NotNull String dbSystem, @NotNull String[] urlParts, @NotNull String urlString) {
        if ("hsqldb".equalsIgnoreCase(dbSystem) || "h2".equalsIgnoreCase(dbSystem) || "derby".equalsIgnoreCase(dbSystem) || "sqlite".equalsIgnoreCase(dbSystem)) {
            if (urlString.contains("//")) {
                return DatabaseUtils.parseAsUri(dbSystem, StringUtils.removePrefix((String)urlString, (String)(dbSystem + ":")));
            }
            if (urlParts.length > 2) {
                String dbNameAndMaybeMore = urlParts[2];
                return new DatabaseDetails(dbSystem, StringUtils.substringBefore((String)dbNameAndMaybeMore, (String)";"));
            }
            if (urlParts.length > 1) {
                String dbNameAndMaybeMore = urlParts[1];
                return new DatabaseDetails(dbSystem, StringUtils.substringBefore((String)dbNameAndMaybeMore, (String)";"));
            }
        }
        if ("mariadb".equalsIgnoreCase(dbSystem) || "mysql".equalsIgnoreCase(dbSystem) || "postgresql".equalsIgnoreCase(dbSystem) || "mongo".equalsIgnoreCase(dbSystem)) {
            return DatabaseUtils.parseAsUri(dbSystem, urlString);
        }
        if ("sqlserver".equalsIgnoreCase(dbSystem)) {
            try {
                String dbProperty = ";databasename=";
                int index = urlString.indexOf(dbProperty);
                if (index >= 0) {
                    @NotNull String dbNameAndMaybeMore = urlString.substring(index + dbProperty.length());
                    return new DatabaseDetails(dbSystem, StringUtils.substringBefore((String)dbNameAndMaybeMore, (String)";"));
                }
            }
            catch (Throwable dbProperty) {
                // empty catch block
            }
        }
        if ("oracle".equalsIgnoreCase(dbSystem)) {
            String serviceNamePrefix;
            int indexOfServiceName;
            String uriPrefix = "oracle:thin:@//";
            int indexOfUri = urlString.indexOf(uriPrefix);
            if (indexOfUri >= 0) {
                @NotNull String uri = "makethisaprotocol://" + urlString.substring(indexOfUri + uriPrefix.length());
                return DatabaseUtils.parseAsUri(dbSystem, uri);
            }
            int indexOfTnsNames = urlString.indexOf("oracle:thin:@(");
            if (indexOfTnsNames >= 0 && (indexOfServiceName = urlString.indexOf(serviceNamePrefix = "(service_name=")) >= 0) {
                int indexOfClosingBrace = urlString.indexOf(")", indexOfServiceName);
                @NotNull String serviceName = urlString.substring(indexOfServiceName + serviceNamePrefix.length(), indexOfClosingBrace);
                return new DatabaseDetails(dbSystem, serviceName);
            }
        }
        if ("datadirect".equalsIgnoreCase(dbSystem) || "tibcosoftware".equalsIgnoreCase(dbSystem) || "jtds".equalsIgnoreCase(dbSystem) || "microsoft".equalsIgnoreCase(dbSystem)) {
            return DatabaseUtils.parse(StringUtils.removePrefix((String)urlString, (String)(dbSystem + ":")));
        }
        return new DatabaseDetails(dbSystem, null);
    }

    @NotNull
    private static DatabaseDetails parseAsUri(@NotNull String dbSystem, @NotNull String urlString) {
        try {
            @NotNull URI url = new URI(urlString);
            String path = StringUtils.removePrefix((String)url.getPath(), (String)"/");
            String pathWithoutProperties = StringUtils.substringBefore((String)path, (String)";");
            return new DatabaseDetails(dbSystem, pathWithoutProperties);
        }
        catch (Throwable t) {
            System.out.println(t.getMessage());
            return new DatabaseDetails(dbSystem, null);
        }
    }

    @NotNull
    private static String removeP6SpyPrefix(@NotNull String url) {
        return StringUtils.removePrefix((String)StringUtils.removePrefix((String)url, (String)"jdbc:"), (String)"p6spy:");
    }

    public static final class DatabaseDetails {
        @Nullable
        private final String dbSystem;
        @Nullable
        private final String dbName;

        DatabaseDetails(@Nullable String dbSystem, @Nullable String dbName) {
            this.dbSystem = dbSystem;
            this.dbName = dbName;
        }

        @Nullable
        public String getDbSystem() {
            return this.dbSystem;
        }

        @Nullable
        public String getDbName() {
            return this.dbName;
        }
    }
}

