/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.btn.ability.impl;

import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.alert.AlertLevel;
import com.ghostchu.peerbanhelper.btn.BtnNetwork;
import com.ghostchu.peerbanhelper.btn.ability.AbstractBtnAbility;
import com.ghostchu.peerbanhelper.databasent.service.MetadataService;
import com.ghostchu.peerbanhelper.event.btn.BtnRuleUpdateEvent;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.util.IPAddressUtil;
import com.ghostchu.peerbanhelper.util.URLUtil;
import com.ghostchu.peerbanhelper.util.backgroundtask.FunctionalBackgroundTask;
import com.ghostchu.peerbanhelper.util.rule.MatchResult;
import com.ghostchu.peerbanhelper.util.rule.MatchResultEnum;
import com.ghostchu.peerbanhelper.util.rule.matcher.IPMatcher;
import com.ghostchu.peerbanhelper.wrapper.BanMetadata;
import com.google.gson.JsonObject;
import inet.ipaddr.IPAddress;
import inet.ipaddr.format.util.DualIPv4v6AssociativeTries;
import io.sentry.Sentry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BtnAbilityIPAllowList
extends AbstractBtnAbility {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BtnAbilityIPAllowList.class);
    private final BtnNetwork btnNetwork;
    private final long interval;
    private final String endpoint;
    private final long randomInitialDelay;
    private final IPMatcher ipMatcher = new IPMatcher("btn-ip-allowlist", "Empty IP Allowlist", List.of(new DualIPv4v6AssociativeTries()));
    private final MetadataService metadataDao;
    private final boolean powCaptcha;
    private String ruleVersion = "initial";

    public BtnAbilityIPAllowList(BtnNetwork btnNetwork, MetadataService metadataDao, JsonObject ability) {
        this.btnNetwork = btnNetwork;
        this.metadataDao = metadataDao;
        this.interval = ability.get("interval").getAsLong();
        this.endpoint = ability.get("endpoint").getAsString();
        this.randomInitialDelay = ability.get("random_initial_delay").getAsLong();
        this.powCaptcha = ability.has("pow_captcha") && ability.get("pow_captcha").getAsBoolean();
        this.setLastStatus(true, new TranslationComponent(Lang.BTN_STAND_BY));
    }

    private void loadCacheFile() {
        String cacheVersion = this.metadataDao.get("btn.ability.ip_allowlist.cache.version");
        String cacheValue = this.metadataDao.get("btn.ability.ip_allowlist.cache.value");
        if (cacheValue != null) {
            DualIPv4v6AssociativeTries associativeTries = new DualIPv4v6AssociativeTries();
            int loaded = this.stringToIPList(cacheValue, (DualIPv4v6AssociativeTries<String>)associativeTries);
            this.ipMatcher.setData("BTN AllowList (Local Cache)", List.of(associativeTries));
            this.ruleVersion = cacheVersion;
            log.debug("[BTN AllowList] Loaded {} IP rules from cache file. Cached version: {}", (Object)loaded, (Object)cacheVersion);
        }
    }

    @Override
    public String getName() {
        return "BtnAbilityIPAllowList";
    }

    @Override
    public TranslationComponent getDisplayName() {
        return new TranslationComponent(Lang.BTN_ABILITY_IP_ALLOWLIST_TITLE);
    }

    @Override
    public TranslationComponent getDescription() {
        return new TranslationComponent(Lang.BTN_ABILITY_IP_ALLOWLIST_DESCRIPTION, this.ruleVersion, this.ipMatcher.size());
    }

    @Override
    public void load() {
        try {
            this.loadCacheFile();
            this.unbanAllowedBannedPeers();
            this.setLastStatus(true, new TranslationComponent(Lang.BTN_ABILITY_IP_ALLOWLIST_LOADED_FROM_CACHE, this.ruleVersion, this.ipMatcher.size()));
        }
        catch (Exception e) {
            log.error(TextManager.tlUI(Lang.BTN_ABILITY_IP_ALLOWLIST_LOAD_FAILED_FROM_CACHE, new Object[0]), (Throwable)e);
            this.setLastStatus(false, new TranslationComponent(e.getClass().getName() + ": " + e.getMessage()));
        }
        this.btnNetwork.getScheduler().scheduleWithFixedDelay(this::updateRule, ThreadLocalRandom.current().nextLong(this.randomInitialDelay), this.interval, TimeUnit.MILLISECONDS);
    }

    private void updateRule() {
        this.btnNetwork.getBackgroundTaskManager().addTaskAsync(new FunctionalBackgroundTask(new TranslationComponent(Lang.BTN_ABILITY_ALLOW_LIST_SYNC_SERVER), (task, callback) -> {
            String version = Objects.requireNonNullElse(this.ruleVersion, "initial");
            String url = URLUtil.appendUrl(this.endpoint, Map.of("rev", version));
            Request.Builder request = new Request.Builder().url(url).get();
            if (this.powCaptcha) {
                this.btnNetwork.gatherAndSolveCaptchaBlocking(request, "ip_allowlist");
            }
            try (Response response = this.btnNetwork.getHttpClient().newCall(request.build()).execute();){
                if (response.code() == 204) {
                    this.setLastStatus(true, new TranslationComponent(Lang.BTN_ABILITY_IP_ALLOWLIST_LOADED_FROM_REMOTE_NO_CHANGES, version, this.ipMatcher.size()));
                    return;
                }
                String responseBody = response.body().string();
                if (!response.isSuccessful()) {
                    log.error(TextManager.tlUI(Lang.BTN_REQUEST_FAILS, response.code() + " - " + responseBody));
                    this.setLastStatus(false, new TranslationComponent(Lang.BTN_HTTP_ERROR, response.code(), responseBody));
                } else {
                    DualIPv4v6AssociativeTries associativeTries = new DualIPv4v6AssociativeTries();
                    int loaded = this.stringToIPList(responseBody, (DualIPv4v6AssociativeTries<String>)associativeTries);
                    this.ipMatcher.setData("BTN AllowList (Remote)", List.of(associativeTries));
                    Main.getEventBus().post((Object)new BtnRuleUpdateEvent());
                    this.ruleVersion = response.header("X-BTN-ContentVersion", "unknown");
                    this.metadataDao.set("btn.ability.ip_allowlist.cache.version", this.ruleVersion);
                    this.metadataDao.set("btn.ability.ip_allowlist.cache.value", responseBody);
                    log.info(TextManager.tlUI(Lang.BTN_ABILITY_IP_ALLOWLIST_LOADED_FROM_REMOTE, this.ruleVersion, loaded));
                    this.setLastStatus(true, new TranslationComponent(Lang.BTN_ABILITY_IP_ALLOWLIST_LOADED_FROM_REMOTE, this.ruleVersion, loaded));
                    this.btnNetwork.getModuleMatchCache().invalidateAll();
                }
            }
            catch (Exception e) {
                log.error(TextManager.tlUI(Lang.BTN_REQUEST_FAILS, new Object[0]), (Throwable)e);
                this.setLastStatus(false, new TranslationComponent(Lang.BTN_UNKNOWN_ERROR, e.getClass().getName() + ": " + e.getMessage()));
            }
            finally {
                this.unbanAllowedBannedPeers();
            }
        })).join();
    }

    private void unbanAllowedBannedPeers() {
        ArrayList unbanPeers = new ArrayList();
        this.btnNetwork.getServer().getBanList().forEach((ip, meta) -> {
            try {
                MatchResult matchResult = this.ipMatcher.match(ip.toNormalizedString());
                if (matchResult.result() == MatchResultEnum.TRUE) {
                    unbanPeers.add(new UnbanPeerTask((IPAddress)ip, (BanMetadata)meta, matchResult));
                }
            }
            catch (Exception e) {
                log.debug("Error while matching IP {} against allowlist, skipping unban check for this IP. Error: {}", (Object)ip.toNormalizedString(), (Object)e.getMessage());
                Sentry.captureException((Throwable)e);
            }
        });
        for (UnbanPeerTask unbanPeer : unbanPeers) {
            this.btnNetwork.getServer().scheduleUnBanPeer(unbanPeer.getIpAddress());
            this.btnNetwork.getAlertManager().publishAlert(false, AlertLevel.INFO, "btn-allowlist-unbanned-peer-" + unbanPeer.getIpAddress().toNormalizedString() + UUID.randomUUID().toString(), new TranslationComponent(Lang.BTN_ABILITY_ALLOW_LIST_UNBAN_ALERT_TITLE), new TranslationComponent(Lang.BTN_ABILITY_ALLOW_LIST_UNBAN_ALERT_DESCRIPTION, unbanPeer.getIpAddress().toNormalizedString(), unbanPeer.getBanMetadata().getBanAt().toString(), unbanPeer.getBanMetadata().getRule(), unbanPeer.getBanMetadata().getDescription(), unbanPeer.getResult().comment()));
            log.info(TextManager.tlUI(Lang.BTN_ABILITY_ALLOW_LIST_UNBAN_PEER, unbanPeer.getBanMetadata(), unbanPeer.getResult().comment()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int stringToIPList(String data, DualIPv4v6AssociativeTries<String> ips) {
        AtomicInteger count = new AtomicInteger();
        StringJoiner sj = new StringJoiner("\n");
        for (String ele : data.split("\n")) {
            if (ele.isBlank()) continue;
            if (ele.startsWith("#")) {
                sj.add(ele.substring(1));
                continue;
            }
            try {
                Map.Entry<IPAddress, String> parsedIp = this.parseRuleLine(ele, sj.toString());
                if (parsedIp == null) continue;
                count.getAndIncrement();
                ips.put(parsedIp.getKey(), (Object)parsedIp.getValue());
            }
            catch (Exception e) {
                log.error("Unable parse rule: {}", (Object)ele, (Object)e);
            }
            finally {
                sj = new StringJoiner("\n");
            }
        }
        return count.get();
    }

    private Map.Entry<IPAddress, @Nullable String> parseRuleLine(String ele, String preReadComment) {
        if (ele.contains(",")) {
            String comment;
            String[] spilted = ele.split(",");
            if (spilted.length < 3) {
                return null;
            }
            IPAddress start = IPAddressUtil.getIPAddress(spilted[0]);
            IPAddress end = IPAddressUtil.getIPAddress(spilted[1]);
            int level = Integer.parseInt(spilted[2]);
            String string = comment = spilted.length > 3 ? spilted[3] : preReadComment;
            if (level >= 128) {
                return null;
            }
            if (start == null || end == null) {
                return null;
            }
            return Map.entry(start.spanWithRange(end).coverWithPrefixBlock(), comment);
        }
        if (ele.contains("#")) {
            String ip = ele.substring(0, ele.indexOf("#"));
            String comment = null;
            if (ele.contains("#")) {
                comment = ele.substring(ele.indexOf("#") + 1);
            }
            return Map.entry(IPAddressUtil.getIPAddress(ip), Optional.ofNullable(comment).orElse(preReadComment));
        }
        return Map.entry(IPAddressUtil.getIPAddress(ele), preReadComment);
    }

    @Override
    public void unload() {
    }

    @Generated
    public IPMatcher getIpMatcher() {
        return this.ipMatcher;
    }

    private static class UnbanPeerTask {
        private IPAddress ipAddress;
        private BanMetadata banMetadata;
        private MatchResult result;

        @Generated
        public IPAddress getIpAddress() {
            return this.ipAddress;
        }

        @Generated
        public BanMetadata getBanMetadata() {
            return this.banMetadata;
        }

        @Generated
        public MatchResult getResult() {
            return this.result;
        }

        @Generated
        public void setIpAddress(IPAddress ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Generated
        public void setBanMetadata(BanMetadata banMetadata) {
            this.banMetadata = banMetadata;
        }

        @Generated
        public void setResult(MatchResult result) {
            this.result = result;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UnbanPeerTask)) {
                return false;
            }
            UnbanPeerTask other = (UnbanPeerTask)o;
            if (!other.canEqual(this)) {
                return false;
            }
            IPAddress this$ipAddress = this.getIpAddress();
            IPAddress other$ipAddress = other.getIpAddress();
            if (this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress)) {
                return false;
            }
            BanMetadata this$banMetadata = this.getBanMetadata();
            BanMetadata other$banMetadata = other.getBanMetadata();
            if (this$banMetadata == null ? other$banMetadata != null : !((Object)this$banMetadata).equals(other$banMetadata)) {
                return false;
            }
            MatchResult this$result = this.getResult();
            MatchResult other$result = other.getResult();
            return !(this$result == null ? other$result != null : !((Object)this$result).equals(other$result));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof UnbanPeerTask;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            IPAddress $ipAddress = this.getIpAddress();
            result = result * 59 + ($ipAddress == null ? 43 : $ipAddress.hashCode());
            BanMetadata $banMetadata = this.getBanMetadata();
            result = result * 59 + ($banMetadata == null ? 43 : ((Object)$banMetadata).hashCode());
            MatchResult $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : ((Object)$result).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "BtnAbilityIPAllowList.UnbanPeerTask(ipAddress=" + String.valueOf(this.getIpAddress()) + ", banMetadata=" + String.valueOf(this.getBanMetadata()) + ", result=" + String.valueOf(this.getResult()) + ")";
        }

        @Generated
        public UnbanPeerTask(IPAddress ipAddress, BanMetadata banMetadata, MatchResult result) {
            this.ipAddress = ipAddress;
            this.banMetadata = banMetadata;
            this.result = result;
        }
    }
}

