/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.databasent.driver;

import com.ghostchu.peerbanhelper.databasent.DatabaseDriver;
import javax.sql.DataSource;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.stone.beecp.BeeDataSource;

public abstract class AbstractDatabaseDriver
implements DatabaseDriver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractDatabaseDriver.class);
    private DataSource dataSource;

    @Override
    @NotNull
    public String getMapperXmlPath() {
        return "mapper/" + this.getType().getMapperType() + "/**/*.xml";
    }

    @Override
    public void close() throws Exception {
        DataSource dataSource = this.dataSource;
        if (dataSource instanceof BeeDataSource) {
            BeeDataSource beeDataSource = (BeeDataSource)dataSource;
            if (!beeDataSource.isClosed()) {
                beeDataSource.close();
            }
        } else {
            log.warn("Given DataSource is not an instance of BeeDataSource, cannot close it properly.");
        }
    }

    @Override
    @NotNull
    public DataSource getDataSource() {
        if (this.dataSource != null) {
            return this.dataSource;
        }
        this.dataSource = this.createDataSource();
        return this.dataSource;
    }

    @NotNull
    protected abstract DataSource createDataSource();
}

