/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.databasent.driver.mysql;

import com.ghostchu.peerbanhelper.databasent.DatabaseType;
import com.ghostchu.peerbanhelper.databasent.driver.AbstractDatabaseDriver;
import com.ghostchu.peerbanhelper.util.MiscUtil;
import java.io.IOException;
import javax.sql.DataSource;
import org.bspfsystems.yamlconfiguration.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.stone.beecp.BeeDataSource;
import org.stone.beecp.BeeDataSourceConfig;

public class MySQLDatabaseDriver
extends AbstractDatabaseDriver {
    private final BeeDataSource dataSource;

    public MySQLDatabaseDriver(@NotNull ConfigurationSection section) throws IOException {
        BeeDataSourceConfig config = new BeeDataSourceConfig();
        String host = section.getString("host");
        int port = section.getInt("port");
        String database = section.getString("database");
        String username = section.getString("username");
        String password = section.getString("password");
        config.setJdbcUrl("jdbc:p6spy:mysql://" + host + ":" + port + "/" + database + "?useSSL=false&serverTimezone=UTC&allowPublicKeyRetrieval=true");
        config.setUsername(username);
        config.setPassword(password);
        config.setDriverClassName("com.p6spy.engine.spy.P6SpyDriver");
        config.setMaxActive(10);
        config.setMaxWait(30000L);
        config.setIntervalOfClearTimeout(600000L);
        config.setAliveTestSql("SELECT 1");
        config.setFairMode(true);
        config.addConnectionFactoryProperty("cachePrepStmts", (Object)"true");
        config.addConnectionFactoryProperty("prepStmtCacheSize", (Object)"250");
        config.addConnectionFactoryProperty("prepStmtCacheSqlLimit", (Object)"2048");
        this.dataSource = new BeeDataSource(config);
        MiscUtil.removeBeeCPShutdownHook(this.dataSource);
    }

    @Override
    @NotNull
    public DatabaseType getType() {
        return DatabaseType.MYSQL;
    }

    @Override
    @NotNull
    protected DataSource createDataSource() {
        return this.dataSource;
    }
}

